/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.editor.wiki.actions;

import com.ibm.team.apt.internal.client.IterationPlanData;
import com.ibm.team.apt.internal.client.IterationPlanItem;
import com.ibm.team.apt.internal.client.util.IDeferredResolver;
import com.ibm.team.apt.internal.client.wiki.WikiLinks;
import com.ibm.team.apt.internal.ide.ui.editor.IterationPlanEditor;
import com.ibm.team.apt.internal.ide.ui.editor.wiki.WikiViewer;
import com.ibm.team.apt.internal.ide.ui.editor.wiki.actions.AbstractWikiAction;
import com.ibm.team.apt.internal.ide.ui.editor.wiki.actions.Messages;
import com.ibm.team.apt.internal.ide.ui.util.ExceptionHandler;
import com.ibm.team.apt.internal.ide.ui.util.UI;
import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.process.common.IIterationHandle;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.WorkItemOperation;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.common.model.ICategoryHandle;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.rcp.ui.ImagePool;
import com.ibm.team.workitem.rcp.ui.internal.wizards.NewWorkItemWizard;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.ReplaceEdit;

public class ExtractWorkItemAction
extends AbstractWikiAction {
    private IterationPlanEditor fEditor;

    public ExtractWorkItemAction(IterationPlanEditor editor, WikiViewer wikiViewer) {
        super(wikiViewer, Messages.ExtractWorkItemAction_LABEL, ImagePool.WORKITEM_CREATE);
        this.fEditor = editor;
    }

    public void run() {
        final ITextSelection selection = (ITextSelection)this.fViewer.getSelection();
        IterationPlanData data = this.fEditor.getIterationPlanData();
        final FeedFromPlanOperation operation = new FeedFromPlanOperation(selection, data);
        NewWorkItemWizard wizard = new NewWorkItemWizard((IProjectAreaHandle)data.getProjectArea());
        wizard.setPostCreationOperation((WorkItemOperation)operation);
        WizardDialog dialog = new WizardDialog(this.fEditor.getSite().getShell(), (IWizard)wizard);
        int open = dialog.open();
        if (open != 0) {
            return;
        }
        try {
            this.fEditor.blockingResolve(new IDeferredResolver<Void>(){

                public Void resolve(IProgressMonitor monitor) throws TeamRepositoryException {
                    IWorkItem item;
                    boolean proceed = operation.join(monitor);
                    if (proceed && (item = operation.getItem()) != null) {
                        IterationPlanItem planItem;
                        final String link = WikiLinks.link((Object)Location.itemLocation((IItemHandle)item, null), (Object)"${Summary} (${Id})");
                        IterationPlanData planData = ExtractWorkItemAction.this.fEditor.getIterationPlanData();
                        if (planData.getIterationPlan() != null && (planItem = planData.getIterationPlan().getPlanItem((IWorkItemHandle)item)) != null) {
                            planItem.modified();
                        }
                        UI.asyncExec(ExtractWorkItemAction.this.fViewer.getControl(), new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    ReplaceEdit edit = new ReplaceEdit(selection.getOffset(), selection.getLength(), link);
                                    edit.apply((this).ExtractWorkItemAction.this.fViewer.getDocument());
                                    (this).ExtractWorkItemAction.this.fViewer.setSelectedRange(edit.getOffset(), edit.getLength());
                                }
                                catch (MalformedTreeException malformedTreeException) {
                                }
                                catch (BadLocationException badLocationException) {
                                    // empty catch block
                                }
                            }
                        });
                    }
                    return null;
                }
            });
        }
        catch (TeamRepositoryException e) {
            ExceptionHandler.handle(e, this.fViewer.getControl().getShell(), Messages.ExtractWorkItemAction_FAILED_DIALOG_TITLE, Messages.ExtractWorkItemAction_FAILED_DIALOG_MESSAGE);
        }
    }

    private static class FeedFromPlanOperation
    extends WorkItemOperation {
        private final Object MUTEX = new Object();
        private ITextSelection fSelection;
        private IterationPlanData fData;
        private IWorkItem fItem;

        public FeedFromPlanOperation(ITextSelection selection, IterationPlanData data) {
            super(Messages.ExtractWorkItemAction_JOB_UPDATE_PROFILE, IWorkItem.MEDIUM_PROFILE);
            this.fSelection = selection;
            this.fData = data;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void execute(WorkItemWorkingCopy workingCopy, IProgressMonitor monitor) throws TeamRepositoryException {
            Object object = this.MUTEX;
            synchronized (object) {
                this.fItem = workingCopy.getWorkItem();
                this.fItem.setHTMLSummary(XMLString.createFromPlainText((String)this.fSelection.getText()));
                this.fItem.setTarget((IIterationHandle)this.fData.getIteration());
                if (!this.fData.getCategories().isEmpty()) {
                    this.fItem.setCategory((ICategoryHandle)this.fData.getCategories().get(0));
                }
                this.MUTEX.notifyAll();
            }
        }

        protected void commit(WorkItemWorkingCopy[] workingCopies, IProgressMonitor monitor) throws TeamRepositoryException {
        }

        public IWorkItem getItem() {
            return this.fItem;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean join(IProgressMonitor monitor) {
            while (this.fItem == null && !monitor.isCanceled()) {
                try {
                    Object object = this.MUTEX;
                    synchronized (object) {
                        this.MUTEX.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return !monitor.isCanceled();
        }
    }
}

