/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.editor.wiki;

import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.internal.wiki.transformer.IItemReferenceDetector;
import com.ibm.team.workitem.common.internal.wiki.transformer.IReferenceTransformer;
import com.ibm.team.workitem.common.model.IAttachment;
import com.ibm.team.workitem.ide.ui.internal.editor.FileHelper;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;

public class WorkItemAttachmentReferenceTransformer
implements IReferenceTransformer {
    private IItemManager fItemManager;

    public WorkItemAttachmentReferenceTransformer(IItemManager mgr) {
        this.fItemManager = mgr;
    }

    public void transform(IItemReferenceDetector.Reference reference) {
        if (reference == null) {
            return;
        }
        Location location = reference.getLocation();
        if (location == null) {
            return;
        }
        IItemType type = location.getItemType();
        if (type == IAttachment.ITEM_TYPE) {
            try {
                IItem item = this.fItemManager.fetchPartialItem(location, 0, Arrays.asList(IItem.ITEM_ID_PROPERTY), null);
                if (item instanceof IAttachment) {
                    IAttachment attachment = (IAttachment)item;
                    reference.setName(attachment.getName());
                    String contentType = this.getContentType(attachment);
                    reference.setContentType(contentType);
                    if (contentType != null && contentType.startsWith("image")) {
                        File file = FileHelper.createTemporaryFile((IAttachment)attachment, null);
                        reference.setUri(file.toURI());
                    }
                }
            }
            catch (IOException iOException) {
            }
            catch (TeamRepositoryException teamRepositoryException) {
                // empty catch block
            }
        }
    }

    private String getContentType(IAttachment attachment) {
        String suffix;
        String name = attachment.getName().toLowerCase();
        int suffixIndex = name.lastIndexOf(46);
        if (suffixIndex > 0 && ("png".equals(suffix = name.substring(suffixIndex + 1)) || "gif".equals(suffix) || "jpg".equals(suffix) || "jpeg".equals(suffix))) {
            return "image/" + suffix;
        }
        IContent content = attachment.getContent();
        if (content != null) {
            return content.getContentType();
        }
        return null;
    }
}

