/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.editor.wiki;

import com.ibm.team.apt.internal.ide.ui.PlanningUIPlugin;
import com.ibm.team.apt.internal.ide.ui.editor.DeferredVariableResolver;
import com.ibm.team.apt.internal.ide.ui.editor.wiki.WikiDocument;
import com.ibm.team.apt.internal.ide.ui.editor.wiki.WikiPartitionScanner;
import com.ibm.team.apt.internal.ide.ui.editor.wiki.WikiViewer;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.contentassist.TeamContextProvider;
import com.ibm.team.jface.tooltip.EditorTooltipSupport;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.workitem.common.internal.wiki.transformer.IVariableResolver;
import com.ibm.team.workitem.common.internal.wiki.transformer.Transformer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.DefaultTextHover;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.widgets.Shell;

public final class WikiTextHover
extends DefaultTextHover
implements ITextHoverExtension {
    private WikiViewer fSourceViewer;
    private IInformationControlCreator fInfomationControlCreator;
    private DeferredVariableResolver fVariableResolver;

    public WikiTextHover(ISourceViewer sourceViewer) {
        super(sourceViewer);
        Assert.isLegal((boolean)(sourceViewer instanceof WikiViewer));
        this.fSourceViewer = (WikiViewer)sourceViewer;
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion region) {
        if (!(this.fSourceViewer.getDocument() instanceof WikiDocument)) {
            return null;
        }
        long now = System.currentTimeMillis();
        WikiDocument document = (WikiDocument)this.fSourceViewer.getDocument();
        Transformer transformer = document.getTransformer();
        if (this.fVariableResolver == null && this.fSourceViewer.getContextProvider() instanceof TeamContextProvider) {
            ITeamRepository repository = ((TeamContextProvider)this.fSourceViewer.getContextProvider()).getTeamRepository();
            this.fVariableResolver = new DeferredVariableResolver(DeferredVariableResolver.Mode.Blocking, repository.itemManager(), null);
        }
        transformer.setVariableResolver((IVariableResolver)this.fVariableResolver);
        try {
            ITypedRegion partition = document.getPartition(WikiPartitionScanner.Partitions.WIKI_PARTITING, region.getOffset(), true);
            String xhtml = transformer.transform(document.get(partition.getOffset(), partition.getLength()), document.getOptions());
            try {
                Thread.sleep(Math.max(0L, 500L - (System.currentTimeMillis() - now)));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return xhtml;
        }
        catch (BadLocationException e) {
            PlanningUIPlugin.log(e);
            return null;
        }
        catch (BadPartitioningException e) {
            PlanningUIPlugin.log(e);
            return null;
        }
    }

    public IInformationControlCreator getHoverControlCreator() {
        if (this.fInfomationControlCreator == null) {
            this.fInfomationControlCreator = new IInformationControlCreator(){
                private IInformationControl fInformationControl;

                public IInformationControl createInformationControl(Shell parent) {
                    if (this.fInformationControl == null) {
                        this.fInformationControl = new EditorTooltipSupport(parent, true, false){

                            protected String getMarkup(Object element, boolean isFocus) {
                                if (element instanceof String) {
                                    return (String)element;
                                }
                                return null;
                            }
                        };
                    }
                    return this.fInformationControl;
                }
            };
        }
        return this.fInfomationControlCreator;
    }
}

