/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.editor.wiki;

import com.ibm.team.apt.internal.ide.ui.editor.wiki.Messages;
import com.ibm.team.apt.internal.ide.ui.editor.wiki.WikiAttachmentProposalComputer;
import com.ibm.team.apt.internal.ide.ui.editor.wiki.WikiColorProposalComputer;
import com.ibm.team.apt.internal.ide.ui.editor.wiki.WikiCompletionProcessor;
import com.ibm.team.apt.internal.ide.ui.editor.wiki.WikiDefaultProposalComputer;
import com.ibm.team.apt.internal.ide.ui.editor.wiki.WikiPartitionScanner;
import com.ibm.team.apt.internal.ide.ui.editor.wiki.WikiPresentationReconciler;
import com.ibm.team.apt.internal.ide.ui.editor.wiki.WikiReferenceInsertionStrategy;
import com.ibm.team.apt.internal.ide.ui.editor.wiki.WikiTextHover;
import com.ibm.team.apt.internal.ide.ui.editor.wiki.WikiViewer;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.contentassist.ContentAssistContextProvider;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.contentassist.ContentAssistProposalCategory;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.contentassist.FavoritesProposalComputer;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.contentassist.IContentAssistProposalsComputer;
import com.ibm.team.jface.tooltip.EditorTooltipSupport;
import com.ibm.team.workitem.ide.ui.internal.editor.UserPickerProposalComputer;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemPickerProposalComputer;
import com.ibm.team.workitem.ide.ui.internal.editor.templates.TemplateProposalComputer;
import com.ibm.team.workitem.rcp.ui.internal.UserProposalComputer;
import com.ibm.team.workitem.rcp.ui.internal.WorkItemHistoryProposalComputer;
import java.util.ArrayList;
import org.eclipse.jface.internal.text.html.HTMLTextPresenter;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.quickassist.IQuickAssistAssistant;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;
import org.eclipse.jface.text.quickassist.QuickAssistAssistant;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.MonoReconciler;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;
import org.eclipse.ui.texteditor.spelling.SpellingCorrectionProcessor;
import org.eclipse.ui.texteditor.spelling.SpellingReconcileStrategy;

public class WikiSourceViewerConfiguration
extends TextSourceViewerConfiguration {
    private final ResourceManager fResources;
    private IInformationControlCreator fInfomationControlCreator;
    private ContentAssistContextProvider fContextProvider;
    private ITextHover fTextHover;

    public WikiSourceViewerConfiguration(ResourceManager resources, ContentAssistContextProvider contextProvider) {
        this.fResources = resources;
        this.fContextProvider = contextProvider;
    }

    public String getConfiguredDocumentPartitioning(ISourceViewer sourceViewer) {
        return WikiPartitionScanner.Partitions.WIKI_PARTITING;
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return WikiPartitionScanner.Partitions.TYPES;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        ContentAssistant assistant = new ContentAssistant();
        assistant.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        assistant.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
        assistant.setProposalSelectorBackground(sourceViewer.getTextWidget().getBackground());
        assistant.setAutoActivationDelay(500);
        assistant.setStatusLineVisible(true);
        assistant.setRepeatedInvocationMode(true);
        WikiCompletionProcessor processor = new WikiCompletionProcessor(this.getCategories(WikiPartitionScanner.Partitions.PARAGRAPH), assistant, "__dftl_partition_content_type", this.fResources, this.fContextProvider);
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, WikiPartitionScanner.Partitions.PARAGRAPH.id);
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__dftl_partition_content_type");
        processor = new WikiCompletionProcessor(this.getCategories(WikiPartitionScanner.Partitions.TABLE), assistant, "__dftl_partition_content_type", this.fResources, this.fContextProvider);
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, WikiPartitionScanner.Partitions.TABLE.id);
        processor = new WikiCompletionProcessor(this.getCategories(WikiPartitionScanner.Partitions.BULLET_LIST), assistant, "__dftl_partition_content_type", this.fResources, this.fContextProvider);
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, WikiPartitionScanner.Partitions.BULLET_LIST.id);
        processor = new WikiCompletionProcessor(this.getCategories(WikiPartitionScanner.Partitions.NUMBERED_LIST), assistant, "__dftl_partition_content_type", this.fResources, this.fContextProvider);
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, WikiPartitionScanner.Partitions.NUMBERED_LIST.id);
        processor = new WikiCompletionProcessor(this.getCategories(WikiPartitionScanner.Partitions.HEADING), assistant, "__dftl_partition_content_type", this.fResources, this.fContextProvider);
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, WikiPartitionScanner.Partitions.HEADING.id);
        return assistant;
    }

    private ContentAssistProposalCategory[] getCategories(WikiPartitionScanner.Partitions partition) {
        ContentAssistProposalCategory[] result = new ContentAssistProposalCategory[]{new ContentAssistProposalCategory(Messages.WikiCompletionProcessor_SHOW_DEFAULT_PROPOSAL_MESSAGE, new IContentAssistProposalsComputer[]{new WikiDefaultProposalComputer(partition)}), new ContentAssistProposalCategory(Messages.WikiCompletionProcessor_SHOW_ATTACHMENT_PROPOSAL_MESSAGE, new IContentAssistProposalsComputer[]{new WikiAttachmentProposalComputer()}), new ContentAssistProposalCategory(Messages.WikiCompletionProcessor_SHOW_COLOR_PROPOSAL_MESSAGE, new IContentAssistProposalsComputer[]{new WikiColorProposalComputer()}), new ContentAssistProposalCategory(Messages.WikiSourceViewerConfiguration_FAVORITES_PROPOSAL_MESSAGE, new IContentAssistProposalsComputer[]{new FavoritesProposalComputer(WikiReferenceInsertionStrategy.getDefault())}), new ContentAssistProposalCategory(Messages.WikiSourceViewerConfiguration_WORK_ITEM_HISTORY_PROPOSAL_MESSAGE, new IContentAssistProposalsComputer[]{new WorkItemHistoryProposalComputer(WikiReferenceInsertionStrategy.getDefault()), new WorkItemPickerProposalComputer(WikiReferenceInsertionStrategy.getDefault())}), new ContentAssistProposalCategory(Messages.WikiSourceViewerConfiguration_USERS_PROPOSAL_MESSAGE, new IContentAssistProposalsComputer[]{new UserProposalComputer(WikiReferenceInsertionStrategy.getDefault()), new UserPickerProposalComputer(WikiReferenceInsertionStrategy.getDefault())}), new ContentAssistProposalCategory(Messages.WikiSourceViewerConfiguration_TEMPLATE_PROPOSAL_MESSAGE, new IContentAssistProposalsComputer[]{new TemplateProposalComputer("context_type_wiki_editor")})};
        return result;
    }

    public IInformationControlCreator getInformationControlCreator(ISourceViewer sourceViewer) {
        if (this.fInfomationControlCreator != null) {
            return this.fInfomationControlCreator;
        }
        this.fInfomationControlCreator = new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new EditorTooltipSupport(parent, false, false){

                    public void setInformation(String information) {
                        this.dispose();
                        super.setInformation(information);
                    }

                    protected String getMarkup(Object element, boolean isFocus) {
                        if (element instanceof String) {
                            return (String)element;
                        }
                        return null;
                    }
                };
            }
        };
        return this.fInfomationControlCreator;
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        if (this.fTextHover == null && sourceViewer instanceof WikiViewer) {
            this.fTextHover = new WikiTextHover(sourceViewer);
        }
        return this.fTextHover;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        WikiPresentationReconciler reconciler = new WikiPresentationReconciler(this.fResources);
        reconciler.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        return reconciler;
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        if (!sourceViewer.isEditable()) {
            return null;
        }
        SpellingReconcileStrategy strategy = new SpellingReconcileStrategy(sourceViewer, EditorsUI.getSpellingService());
        MonoReconciler reconciler = new MonoReconciler((IReconcilingStrategy)strategy, false);
        reconciler.setIsIncrementalReconciler(false);
        reconciler.setDelay(500);
        return reconciler;
    }

    public IQuickAssistAssistant getQuickAssistAssistant(ISourceViewer sourceViewer) {
        QuickAssistAssistant assistant = new QuickAssistAssistant();
        assistant.setQuickAssistProcessor((IQuickAssistProcessor)new InternalSpellingCorrectionProcessor());
        assistant.setInformationControlCreator(new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DefaultInformationControl(parent, 0, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(true));
            }
        });
        assistant.setProposalSelectorBackground(sourceViewer.getTextWidget().getDisplay().getSystemColor(1));
        assistant.setProposalSelectorForeground(sourceViewer.getTextWidget().getDisplay().getSystemColor(2));
        return assistant;
    }

    private class InternalSpellingCorrectionProcessor
    implements IQuickAssistProcessor {
        private IQuickAssistProcessor fSpellingCorrectionProcessor = new SpellingCorrectionProcessor();

        private InternalSpellingCorrectionProcessor() {
        }

        public ICompletionProposal[] computeQuickAssistProposals(IQuickAssistInvocationContext invocationContext) {
            ICompletionProposal[] orignialProposals;
            if (!EditorsUI.getPreferenceStore().getBoolean("spellingEnabled")) {
                return new ICompletionProposal[0];
            }
            ArrayList<InternalSpellingCorrectionProposal> proposals = new ArrayList<InternalSpellingCorrectionProposal>();
            ICompletionProposal[] iCompletionProposalArray = orignialProposals = this.fSpellingCorrectionProcessor.computeQuickAssistProposals(invocationContext);
            int n = orignialProposals.length;
            int n2 = 0;
            while (n2 < n) {
                ICompletionProposal originalProposal = iCompletionProposalArray[n2];
                proposals.add(new InternalSpellingCorrectionProposal(originalProposal, invocationContext));
                ++n2;
            }
            return proposals.toArray(new ICompletionProposal[proposals.size()]);
        }

        public boolean canAssist(IQuickAssistInvocationContext invocationContext) {
            return this.fSpellingCorrectionProcessor.canAssist(invocationContext);
        }

        public boolean canFix(Annotation annotation) {
            return this.fSpellingCorrectionProcessor.canFix(annotation);
        }

        public String getErrorMessage() {
            return this.fSpellingCorrectionProcessor.getErrorMessage();
        }
    }

    private class InternalSpellingCorrectionProposal
    implements ICompletionProposal,
    IDocumentListener {
        private ICompletionProposal fSpellingCompletionProposal;
        private IQuickAssistInvocationContext fInvocationContext;
        private boolean fChanged;

        public InternalSpellingCorrectionProposal(ICompletionProposal spellingCompletionProposal, IQuickAssistInvocationContext invocationContext) {
            this.fSpellingCompletionProposal = spellingCompletionProposal;
            this.fInvocationContext = invocationContext;
        }

        public void apply(IDocument document) {
            Point selection;
            try {
                this.fChanged = false;
                document.addDocumentListener((IDocumentListener)this);
                this.fSpellingCompletionProposal.apply(document);
            }
            finally {
                document.removeDocumentListener((IDocumentListener)this);
            }
            if (!this.fChanged && (selection = this.getSelection(document)) != null) {
                IReconciler reconciler = WikiSourceViewerConfiguration.this.getReconciler(this.fInvocationContext.getSourceViewer());
                IReconcilingStrategy strategy = reconciler.getReconcilingStrategy("");
                strategy.setDocument(document);
                strategy.reconcile((IRegion)new Region(selection.x, selection.y));
            }
        }

        public String getAdditionalProposalInfo() {
            return this.fSpellingCompletionProposal.getAdditionalProposalInfo();
        }

        public IContextInformation getContextInformation() {
            return this.fSpellingCompletionProposal.getContextInformation();
        }

        public String getDisplayString() {
            return this.fSpellingCompletionProposal.getDisplayString();
        }

        public Image getImage() {
            return this.fSpellingCompletionProposal.getImage();
        }

        public Point getSelection(IDocument document) {
            return this.fSpellingCompletionProposal.getSelection(document);
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
        }

        public void documentChanged(DocumentEvent event) {
            this.fChanged = true;
        }
    }
}

