/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.editor.wiki;

import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.client.wiki.WikiLinks;
import com.ibm.team.apt.internal.ide.ui.PlanningUIPlugin;
import com.ibm.team.foundation.common.URIReference;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.contentassist.ReferenceInsertionStrategy;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.Location;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemType;
import java.net.URI;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

public class WikiReferenceInsertionStrategy
extends ReferenceInsertionStrategy {
    private static ReferenceInsertionStrategy fInstance;

    public static ReferenceInsertionStrategy getDefault() {
        if (fInstance == null) {
            fInstance = new WikiReferenceInsertionStrategy();
        }
        return fInstance;
    }

    public int insert(URIReference reference, Object element, IDocument document, int offset, String replacement) throws CoreException {
        try {
            String link;
            if (element instanceof IWorkItem) {
                IWorkItem workItem = (IWorkItem)element;
                IWorkItemType workItemType = this.getWorkItemType(workItem);
                if (workItemType != null) {
                    link = WikiLinks.link((IWorkItem)workItem, (IWorkItemType)workItemType);
                } else {
                    URI uri = reference.getURI();
                    link = WikiLinks.link((Object)uri.toASCIIString(), (Object)reference.getName());
                }
            } else {
                URI uri = reference.getURI();
                if (element instanceof IItemHandle) {
                    Location location = Location.itemLocation((IItemHandle)((IItemHandle)element), null);
                    uri = location.toRelativeUri();
                }
                link = WikiLinks.link((Object)uri.toASCIIString(), (Object)reference.getName());
            }
            document.replace(offset - replacement.length(), replacement.length(), link);
            return offset - replacement.length() + link.length();
        }
        catch (BadLocationException e) {
            throw new CoreException((IStatus)new Status(4, PlanningUIPlugin.getPluginId(), e.getLocalizedMessage(), (Throwable)e));
        }
    }

    private IWorkItemType getWorkItemType(IWorkItem item) {
        IWorkItemClient client = PlanningClientPlugin.getWorkItemClient((IItemHandle)item);
        return client.findCachedWorkItemType(item.getProjectArea(), item.getWorkItemType());
    }
}

