/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.editor.wiki;

import com.ibm.team.apt.internal.ide.ui.editor.wiki.LineBeginRule;
import com.ibm.team.apt.internal.ide.ui.editor.wiki.WikiPartitionRule;
import com.ibm.team.apt.internal.ide.ui.editor.wiki.WikiPartitionScanner;
import com.ibm.team.workitem.common.internal.wiki.transformer.Token;
import com.ibm.team.workitem.common.internal.wiki.transformer.Tokens;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.PatternRule;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.swt.graphics.RGB;

public class WikiPresentationReconciler
extends PresentationReconciler {
    private final ResourceManager fResources;

    public WikiPresentationReconciler(ResourceManager resources) {
        this.fResources = resources;
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer(this.getDefaultScanner());
        this.setDamager((IPresentationDamager)dr, WikiPartitionScanner.Partitions.PARAGRAPH.id);
        this.setDamager((IPresentationDamager)dr, WikiPartitionScanner.Partitions.TABLE.id);
        this.setRepairer((IPresentationRepairer)dr, WikiPartitionScanner.Partitions.PARAGRAPH.id);
        this.setRepairer((IPresentationRepairer)dr, WikiPartitionScanner.Partitions.TABLE.id);
        dr = new DefaultDamagerRepairer(this.getCodeScanner()){

            public IRegion getDamageRegion(ITypedRegion partition, DocumentEvent e, boolean documentPartitioningChanged) {
                return partition;
            }
        };
        this.setDamager((IPresentationDamager)dr, WikiPartitionScanner.Partitions.CODE.id);
        this.setRepairer((IPresentationRepairer)dr, WikiPartitionScanner.Partitions.CODE.id);
        dr = new DefaultDamagerRepairer(this.getHeadingsScanner());
        this.setDamager((IPresentationDamager)dr, WikiPartitionScanner.Partitions.HEADING.id);
        this.setRepairer((IPresentationRepairer)dr, WikiPartitionScanner.Partitions.HEADING.id);
        dr = new DefaultDamagerRepairer(this.getListsScanner());
        this.setDamager((IPresentationDamager)dr, WikiPartitionScanner.Partitions.BULLET_LIST.id);
        this.setDamager((IPresentationDamager)dr, WikiPartitionScanner.Partitions.NUMBERED_LIST.id);
        this.setRepairer((IPresentationRepairer)dr, WikiPartitionScanner.Partitions.BULLET_LIST.id);
        this.setRepairer((IPresentationRepairer)dr, WikiPartitionScanner.Partitions.NUMBERED_LIST.id);
    }

    private ITokenScanner getDefaultScanner() {
        RuleBasedScanner scanner = new RuleBasedScanner();
        IRule[] rules = new IRule[]{this.createFormattingsRule(), this.createLinkRule(), this.createImageRule()};
        scanner.setRules(rules);
        return scanner;
    }

    private ITokenScanner getListsScanner() {
        RuleBasedScanner scanner = new RuleBasedScanner();
        IRule[] rules = new IRule[]{this.createNumberedItemsRule(), this.createBulletItemsRule(), this.createFormattingsRule(), this.createLinkRule(), this.createImageRule()};
        scanner.setRules(rules);
        return scanner;
    }

    private ITokenScanner getCodeScanner() {
        RuleBasedScanner scanner = new RuleBasedScanner();
        IRule[] rules = new IRule[]{this.createCodeRule()};
        scanner.setRules(rules);
        return scanner;
    }

    private ITokenScanner getHeadingsScanner() {
        RuleBasedScanner scanner = new RuleBasedScanner();
        IRule[] rules = new IRule[]{new LineBeginRule('=', 6, this.createToken(new RGB(200, 100, 50), null, 1))};
        scanner.setRules(rules);
        return scanner;
    }

    private IRule createFormattingsRule() {
        final ArrayList<String> tokens = new ArrayList<String>();
        tokens.addAll(Arrays.asList(Tokens.asStringArray((Token[])Tokens.FORMATS)));
        tokens.add(Token.LINE_BREAK.wiki);
        WordRule rule = new WordRule(new IWordDetector(){
            private char fLastWordStart;

            public boolean isWordStart(char c) {
                for (String string : tokens) {
                    if (string.charAt(0) != c) continue;
                    this.fLastWordStart = c;
                    return true;
                }
                return false;
            }

            public boolean isWordPart(char c) {
                return this.fLastWordStart == c;
            }
        });
        IToken token = this.createToken(new RGB(0, 0, 200), null, 1);
        for (String string : tokens) {
            rule.addWord(string, token);
        }
        return rule;
    }

    private IRule createBulletItemsRule() {
        return new LineBeginRule('*', 5, this.createToken(new RGB(255, 140, 0), null, 1));
    }

    private IRule createNumberedItemsRule() {
        return new LineBeginRule('#', 5, this.createToken(new RGB(255, 140, 0), null, 0));
    }

    private IRule createCodeRule() {
        return new MultiLineRule(Token.CODE_START.wiki, Token.CODE_END.wiki, this.createToken(new RGB(105, 105, 105), null, 0), '~');
    }

    private IRule createLinkRule() {
        return new PatternRule(Token.LINK_START.wiki, Token.LINK_END.wiki, this.createToken(new RGB(50, 50, 50), null, 0), '~', true);
    }

    private IRule createImageRule() {
        return new PatternRule(Token.IMG_START.wiki, Token.IMG_END.wiki, this.createToken(new RGB(50, 50, 50), null, 0), '~', true);
    }

    public IToken createToken(RGB fg, RGB bg, int style) {
        return new org.eclipse.jface.text.rules.Token((Object)new TextAttribute(fg == null ? null : this.fResources.createColor(fg), bg == null ? null : this.fResources.createColor(bg), style));
    }

    void installDebugColorer(PresentationReconciler reconciler) {
        RuleBasedScanner scanner = new RuleBasedScanner();
        scanner.setRules(new IRule[]{new WikiPartitionRule()});
        String[] stringArray = WikiPartitionScanner.Partitions.TYPES;
        int n = WikiPartitionScanner.Partitions.TYPES.length;
        int n2 = 0;
        while (n2 < n) {
            String partition = stringArray[n2];
            DefaultDamagerRepairer repairer = new DefaultDamagerRepairer((ITokenScanner)scanner);
            reconciler.setDamager((IPresentationDamager)repairer, partition);
            reconciler.setRepairer((IPresentationRepairer)repairer, partition);
            ++n2;
        }
    }

    void installDebugDamapgerRepairer(PresentationReconciler reconciler) {
        Iterator<RGB> iter = Arrays.asList(new RGB(255, 0, 0), new RGB(0, 255, 0), new RGB(0, 0, 255), new RGB(50, 50, 50), new RGB(100, 100, 100), new RGB(200, 200, 200)).iterator();
        String[] stringArray = WikiPartitionScanner.Partitions.TYPES;
        int n = WikiPartitionScanner.Partitions.TYPES.length;
        int n2 = 0;
        while (n2 < n) {
            String partition = stringArray[n2];
            DefaultDamagerRepairer repairer = new DefaultDamagerRepairer(this.getDebugScanner(iter.next()));
            reconciler.setDamager((IPresentationDamager)repairer, partition);
            reconciler.setRepairer((IPresentationRepairer)repairer, partition);
            ++n2;
        }
    }

    ITokenScanner getDebugScanner(RGB color) {
        org.eclipse.jface.text.rules.Token token = new org.eclipse.jface.text.rules.Token((Object)new TextAttribute(null, this.fResources.createColor(color), 0));
        RuleBasedScanner scanner = new RuleBasedScanner();
        scanner.setRules(new IRule[]{new WordRule(new IWordDetector(){

            public boolean isWordPart(char c) {
                return this.isWordStart(c);
            }

            public boolean isWordStart(char c) {
                return c != ' ' && c != '\n' && c != '\n';
            }
        }, (IToken)token)});
        return scanner;
    }
}

