/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.editor.wiki;

import com.ibm.team.apt.internal.ide.ui.editor.wiki.WikiPartitionScanner;
import com.ibm.team.workitem.common.internal.wiki.transformer.ILexerInput;
import com.ibm.team.workitem.common.internal.wiki.transformer.Lexer;
import com.ibm.team.workitem.common.internal.wiki.transformer.Symbol;
import com.ibm.team.workitem.common.internal.wiki.transformer.Tokens;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public final class WikiPartitionRule
implements IPredicateRule {
    private static final com.ibm.team.workitem.common.internal.wiki.transformer.Token[] tokens;
    private Lexer fLexer = new Lexer(tokens);

    static {
        ArrayList<com.ibm.team.workitem.common.internal.wiki.transformer.Token> list = new ArrayList<com.ibm.team.workitem.common.internal.wiki.transformer.Token>(20);
        list.add(com.ibm.team.workitem.common.internal.wiki.transformer.Token.EOF);
        list.add(com.ibm.team.workitem.common.internal.wiki.transformer.Token.SEPARATOR);
        list.addAll(Arrays.asList(Tokens.EOL));
        list.addAll(Arrays.asList(com.ibm.team.workitem.common.internal.wiki.transformer.Token.WHITESPACE, com.ibm.team.workitem.common.internal.wiki.transformer.Token.TAB, com.ibm.team.workitem.common.internal.wiki.transformer.Token.CHARACTER));
        list.addAll(Arrays.asList(com.ibm.team.workitem.common.internal.wiki.transformer.Token.CODE_START, com.ibm.team.workitem.common.internal.wiki.transformer.Token.CODE_END));
        list.addAll(Arrays.asList(Tokens.HEADINGS));
        list.addAll(Arrays.asList(Tokens.NUMBERED_ITEMS));
        list.addAll(Arrays.asList(Tokens.BULLET_ITEMS));
        tokens = list.toArray(new com.ibm.team.workitem.common.internal.wiki.transformer.Token[0]);
    }

    public IToken evaluate(ICharacterScanner scanner) {
        return this.evaluate(scanner, true);
    }

    public IToken evaluate(ICharacterScanner scanner, boolean resume) {
        CharacterScannerInput input = new CharacterScannerInput(scanner);
        this.fLexer.setInput((ILexerInput)input);
        WikiPartitionScanner.Partitions current = null;
        Symbol symbol = null;
        do {
            int column = scanner.getColumn();
            symbol = this.fLexer.nextSymbol();
            boolean startNewPartion = false;
            WikiPartitionScanner.Partitions next = null;
            if (current == WikiPartitionScanner.Partitions.CODE) {
                while ((symbol = this.fLexer.nextSymbol()).couldBe(new com.ibm.team.workitem.common.internal.wiki.transformer.Token[]{com.ibm.team.workitem.common.internal.wiki.transformer.Token.CODE_END, com.ibm.team.workitem.common.internal.wiki.transformer.Token.EOF}) == null) {
                }
                return this.createToken(WikiPartitionScanner.Partitions.CODE);
            }
            if (!this.matches(true, symbol, com.ibm.team.workitem.common.internal.wiki.transformer.Token.EOF)) {
                next = this.computePartition(symbol, column);
                switch (next) {
                    case HEADING: 
                    case BLANK: {
                        startNewPartion = true;
                        break;
                    }
                    case CODE: {
                        if (current == WikiPartitionScanner.Partitions.HEADING) break;
                        startNewPartion = true;
                        break;
                    }
                    case PARAGRAPH: {
                        if (current != null) break;
                        startNewPartion = true;
                        break;
                    }
                    case TABLE: {
                        if (current != null && WikiPartitionScanner.Partitions.TABLE == current) break;
                        startNewPartion = true;
                        break;
                    }
                    case BULLET_LIST: {
                        if (current != null && WikiPartitionScanner.Partitions.BULLET_LIST == current) break;
                        startNewPartion = true;
                        break;
                    }
                    case NUMBERED_LIST: {
                        if (current != null && WikiPartitionScanner.Partitions.NUMBERED_LIST == current) break;
                        startNewPartion = true;
                    }
                }
            }
            if (!startNewPartion) continue;
            if (current != null) {
                Object obj;
                if (next != WikiPartitionScanner.Partitions.BLANK && (obj = symbol.getData()) instanceof String) {
                    input.unread(((String)obj).toCharArray());
                }
                return this.createToken(current);
            }
            current = next;
        } while (!this.matches(true, symbol, com.ibm.team.workitem.common.internal.wiki.transformer.Token.EOF));
        if (current == null) {
            return Token.EOF;
        }
        return this.createToken(current);
    }

    private WikiPartitionScanner.Partitions computePartition(Symbol symbol, int column) {
        if (this.matches(true, symbol, com.ibm.team.workitem.common.internal.wiki.transformer.Token.CODE_START)) {
            return WikiPartitionScanner.Partitions.CODE;
        }
        if (column == 0) {
            if (this.matches(true, symbol, new com.ibm.team.workitem.common.internal.wiki.transformer.Token[][]{Tokens.HEADINGS})) {
                return WikiPartitionScanner.Partitions.HEADING;
            }
            if (this.matches(true, symbol, com.ibm.team.workitem.common.internal.wiki.transformer.Token.NUMBERED_1)) {
                return WikiPartitionScanner.Partitions.NUMBERED_LIST;
            }
            if (this.matches(true, symbol, com.ibm.team.workitem.common.internal.wiki.transformer.Token.BULLET_1)) {
                return WikiPartitionScanner.Partitions.BULLET_LIST;
            }
            if (this.matches(true, symbol, com.ibm.team.workitem.common.internal.wiki.transformer.Token.SEPARATOR)) {
                return WikiPartitionScanner.Partitions.TABLE;
            }
            if (this.matches(true, symbol, new com.ibm.team.workitem.common.internal.wiki.transformer.Token[][]{Tokens.EOL})) {
                return WikiPartitionScanner.Partitions.BLANK;
            }
        }
        return WikiPartitionScanner.Partitions.PARAGRAPH;
    }

    public boolean matches(boolean keep, Symbol symbol, com.ibm.team.workitem.common.internal.wiki.transformer.Token token) {
        boolean matches;
        boolean bl = matches = symbol.couldBe(new com.ibm.team.workitem.common.internal.wiki.transformer.Token[]{token}) != null;
        if (matches && !keep) {
            this.fLexer.returnSymbol(symbol);
        }
        return matches;
    }

    public boolean matches(boolean keep, Symbol symbol, com.ibm.team.workitem.common.internal.wiki.transformer.Token[] ... rest) {
        if (symbol == null) {
            return false;
        }
        com.ibm.team.workitem.common.internal.wiki.transformer.Token[][] tokenArray = rest;
        int n = rest.length;
        int n2 = 0;
        while (n2 < n) {
            com.ibm.team.workitem.common.internal.wiki.transformer.Token[] tokens = tokenArray[n2];
            if (symbol.couldBe(tokens) != null) {
                if (!keep) {
                    this.fLexer.returnSymbol(symbol);
                }
                return true;
            }
            ++n2;
        }
        return false;
    }

    public IToken createToken(WikiPartitionScanner.Partitions type) {
        if (type == WikiPartitionScanner.Partitions.BLANK) {
            type = WikiPartitionScanner.Partitions.PARAGRAPH;
        }
        return new Token((Object)type.id);
    }

    public IToken getSuccessToken() {
        return Token.UNDEFINED;
    }

    public static class CharacterScannerInput
    implements ILexerInput {
        private boolean fEOF;
        private final ICharacterScanner fScanner;
        private int fCharPos;

        public CharacterScannerInput(ICharacterScanner scanner) {
            this.fScanner = scanner;
        }

        public boolean eof() {
            return this.fEOF;
        }

        public char[] read(int len) {
            char[] cbuf = new char[len];
            int i = 0;
            while (i < len) {
                int read = this.fScanner.read();
                if (read == -1) {
                    this.fEOF = true;
                    this.unread2(i + 1);
                    return null;
                }
                cbuf[i] = (char)read;
                ++i;
            }
            this.fCharPos += len;
            return cbuf;
        }

        public int read() {
            int ch = this.fScanner.read();
            if (ch == -1) {
                this.fEOF = true;
                this.unread2(1);
            }
            ++this.fCharPos;
            return ch;
        }

        public void unread(char[] cbuf) {
            int len = cbuf.length;
            this.unread2(len);
            this.fEOF = false;
        }

        public void unread(int ch) {
            if (ch == -1) {
                return;
            }
            this.unread2(1);
        }

        public int getCurrentOffset() {
            return this.fCharPos;
        }

        private void unread2(int n) {
            while (n > 0) {
                this.fScanner.unread();
                --this.fCharPos;
                --n;
            }
        }
    }
}

