/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.editor.wiki;

import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.client.wiki.WikiLinks;
import com.ibm.team.apt.internal.ide.ui.editor.wiki.Messages;
import com.ibm.team.apt.internal.ide.ui.editor.wiki.WikiViewer;
import com.ibm.team.apt.internal.ide.ui.util.TeamRunnable;
import com.ibm.team.apt.internal.ide.ui.util.UI;
import com.ibm.team.foundation.common.URIReference;
import com.ibm.team.foundation.rcp.core.hyperlinks.Hyperlinks;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.common.internal.wiki.transformer.Token;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.IWorkItemType;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.PlatformUI;

public class WikiDropAdapter
extends ViewerDropAdapter {
    public WikiDropAdapter(WikiViewer viewer) {
        super((Viewer)viewer);
    }

    public void dragEnter(DropTargetEvent event) {
        this.doDragChanged(event);
    }

    public void dragOperationChanged(DropTargetEvent event) {
        this.doDragChanged(event);
    }

    private void doDragChanged(DropTargetEvent event) {
        event.detail = (event.operations & 1) != 0 ? 1 : ((event.operations & 4) != 0 ? 4 : 16);
    }

    public boolean validateDrop(Object target, int operation, TransferData transferType) {
        IStructuredSelection selection = (IStructuredSelection)LocalSelectionTransfer.getTransfer().getSelection();
        if (selection != null) {
            Object[] elements;
            Object[] objectArray = elements = selection.toArray();
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                if (Hyperlinks.handles((Object)element)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public boolean performDrop(Object data) {
        if (!(data instanceof IStructuredSelection)) {
            return false;
        }
        final IStructuredSelection selection = (IStructuredSelection)data;
        if (selection.isEmpty()) {
            return false;
        }
        StyledText widget = this.getWikiViewer().getTextWidget();
        if (widget == null || widget.isDisposed()) {
            return false;
        }
        final ArrayList references = new ArrayList();
        try {
            PlatformUI.getWorkbench().getProgressService().run(true, true, (IRunnableWithProgress)new TeamRunnable(){

                @Override
                protected void execute(IProgressMonitor monitor) throws TeamRepositoryException, InvocationTargetException, InterruptedException {
                    Object[] elements = selection.toArray();
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)elements.length);
                    Object[] objectArray = elements;
                    int n = elements.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object element = objectArray[n2];
                        if (element instanceof IWorkItemHandle) {
                            IWorkItemHandle handle = (IWorkItemHandle)element;
                            SubMonitor subProgress = progress.newChild(1);
                            IItemManager itemManager = PlanningClientPlugin.getTeamRepository((IItemHandle)handle).itemManager();
                            IWorkItemClient workItemClient = PlanningClientPlugin.getWorkItemClient((IItemHandle)handle);
                            IWorkItem workItem = (IWorkItem)itemManager.fetchPartialItem((IItemHandle)handle, 0, Arrays.asList(IWorkItem.PROJECT_AREA_PROPERTY, IWorkItem.SUMMARY_PROPERTY, IWorkItem.ID_PROPERTY, IWorkItem.TYPE_PROPERTY), (IProgressMonitor)subProgress.newChild(1));
                            IWorkItemType workItemType = workItemClient.findWorkItemType(workItem.getProjectArea(), workItem.getWorkItemType(), (IProgressMonitor)subProgress.newChild(1));
                            references.add(WikiLinks.link((IWorkItem)workItem, (IWorkItemType)workItemType));
                        } else {
                            URIReference reference = Hyperlinks.create((Object)element, (IProgressMonitor)progress.newChild(1));
                            references.add(WikiLinks.link((Object)reference.getURI(), (Object)reference.getName()));
                        }
                        ++n2;
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            PlanningClientPlugin.log((Throwable)e);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Object choise = Messages.WikiDropAdapter_POPUP_LINE;
        if (references.size() > 1) {
            Point location = widget.getLocationAtOffset(widget.getCaretOffset());
            choise = WikiDropAdapter.openSelectionPopup((Control)widget, widget.getDisplay().map((Control)widget, null, location), Messages.WikiDropAdapter_POPUP_TITLE, Messages.WikiDropAdapter_POPUP_BULLETS, Messages.WikiDropAdapter_POPUP_NUMBERED, Messages.WikiDropAdapter_POPUP_LINE);
            if (choise == null) {
                return false;
            }
        }
        MultiTextEdit edit = new MultiTextEdit();
        for (String reference : references) {
            if (choise == Messages.WikiDropAdapter_POPUP_BULLETS) {
                edit.addChild((TextEdit)new InsertEdit(widget.getCaretOffset(), String.valueOf(Token.BULLET_1.wiki) + " " + reference + "\n"));
                continue;
            }
            if (choise == Messages.WikiDropAdapter_POPUP_NUMBERED) {
                edit.addChild((TextEdit)new InsertEdit(widget.getCaretOffset(), String.valueOf(Token.NUMBERED_1.wiki) + " " + reference + "\n"));
                continue;
            }
            edit.addChild((TextEdit)new InsertEdit(widget.getCaretOffset(), reference));
        }
        try {
            edit.apply(this.getWikiViewer().getDocument());
        }
        catch (MalformedTreeException e) {
            PlanningClientPlugin.log((Throwable)e);
        }
        catch (BadLocationException e) {
            PlanningClientPlugin.log((Throwable)e);
        }
        return true;
    }

    protected WikiViewer getWikiViewer() {
        return (WikiViewer)super.getViewer();
    }

    private static Object openSelectionPopup(Control parent, Point location, String title, Object ... elements) {
        return WikiDropAdapter.openSelectionPopup(parent, location, title, (ILabelProvider)new LabelProvider(), (IStructuredContentProvider)new ArrayContentProvider(), (Object)elements);
    }

    private static Object openSelectionPopup(Control parent, Point location, String title, ILabelProvider labelProvider, IStructuredContentProvider contentProvider, Object input) {
        Object[] elements;
        Menu menu = new Menu(parent);
        MenuItem titleItem = new MenuItem(menu, 8);
        titleItem.setText(title);
        titleItem.setEnabled(false);
        final Object[] selection = new Object[1];
        SelectionListener listener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                selection[0] = e.widget.getData();
            }
        };
        Object[] objectArray = elements = contentProvider.getElements(input);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            MenuItem item = new MenuItem(menu, 8);
            item.setData(element);
            item.setImage(labelProvider.getImage(element));
            item.setText(labelProvider.getText(element));
            item.addSelectionListener(listener);
            ++n2;
        }
        new MenuItem(menu, 2);
        MenuItem cancelItem = new MenuItem(menu, 8);
        cancelItem.setText(Messages.WikiDropAdapter_POPUP_CANCEL);
        UI.showAndDisposeMenu(menu, location);
        return selection[0];
    }
}

