/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.editor.wiki;

import com.ibm.team.apt.internal.ide.ui.editor.wiki.WikiPartitionScanner;
import com.ibm.team.workitem.common.internal.wiki.transformer.Transformer;
import java.util.EnumSet;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;

public class WikiDocument
extends Document {
    protected Transformer fTransformer;
    protected EnumSet<Transformer.Option> fOptions;

    public WikiDocument(String content, Transformer transformer, EnumSet<Transformer.Option> options) {
        super(content);
        Assert.isNotNull((Object)transformer);
        Assert.isNotNull(options);
        this.fTransformer = transformer;
        this.fOptions = options;
    }

    public Transformer getTransformer() {
        return this.fTransformer;
    }

    public EnumSet<Transformer.Option> getOptions() {
        return this.fOptions;
    }

    public String transform() {
        if (this.getLength() == 0) {
            return null;
        }
        try {
            return this.transform(0, this.getLength());
        }
        catch (BadLocationException e) {
            return null;
        }
    }

    public String transform(int offset, int length) throws BadLocationException {
        return this.transform(offset, length, this.getOptions());
    }

    public String transform(int offset, int length, EnumSet<Transformer.Option> options) throws BadLocationException {
        String wiki = this.get(offset, length);
        return this.fTransformer.transform(wiki, options);
    }

    public String transformLine(int offset) throws BadLocationException {
        IRegion region = this.getLineInformationOfOffset(offset);
        return this.transform(region.getOffset(), region.getLength());
    }

    public String transformPartition(int offset) throws BadLocationException, BadPartitioningException {
        ITypedRegion region = this.getPartition(WikiPartitionScanner.Partitions.WIKI_PARTITING, offset, true);
        return this.transform(region.getOffset(), region.getLength());
    }
}

