/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.editor.wiki;

import com.ibm.team.apt.internal.ide.ui.editor.wiki.WikiCompletionProcessor;
import com.ibm.team.apt.internal.ide.ui.editor.wiki.WikiPartitionScanner;
import com.ibm.team.apt.internal.ide.ui.editor.wiki.WikiProposalComputer;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.contentassist.ContentAssistContext;
import com.ibm.team.workitem.common.internal.wiki.transformer.Token;
import com.ibm.team.workitem.common.internal.wiki.transformer.Tokens;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.contentassist.ICompletionProposal;

public class WikiDefaultProposalComputer
extends WikiProposalComputer {
    private final WikiPartitionScanner.Partitions fPartition;

    public WikiDefaultProposalComputer(WikiPartitionScanner.Partitions partition) {
        this.fPartition = partition;
    }

    public List<ICompletionProposal> computeCompletionProposals(ContentAssistContext context) {
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        if (WikiPartitionScanner.Partitions.HEADING.id.equals(this.fPartition.id)) {
            WikiCompletionProcessor.computeProposals(proposals, (WikiCompletionProcessor.WikiContentAssistContext)context, Tokens.HEADINGS);
        } else if (WikiPartitionScanner.Partitions.BULLET_LIST.id.equals(this.fPartition.id)) {
            WikiCompletionProcessor.computeBulletProposals(proposals, (WikiCompletionProcessor.WikiContentAssistContext)context);
            WikiCompletionProcessor.computeNumberedProposals(proposals, (WikiCompletionProcessor.WikiContentAssistContext)context);
            WikiCompletionProcessor.computeFormatsProposals(proposals, (WikiCompletionProcessor.WikiContentAssistContext)context);
            WikiCompletionProcessor.computeCodeProposal(proposals, (WikiCompletionProcessor.WikiContentAssistContext)context);
        } else if (WikiPartitionScanner.Partitions.NUMBERED_LIST.id.equals(this.fPartition.id)) {
            WikiCompletionProcessor.computeNumberedProposals(proposals, (WikiCompletionProcessor.WikiContentAssistContext)context);
            WikiCompletionProcessor.computeBulletProposals(proposals, (WikiCompletionProcessor.WikiContentAssistContext)context);
            WikiCompletionProcessor.computeFormatsProposals(proposals, (WikiCompletionProcessor.WikiContentAssistContext)context);
            WikiCompletionProcessor.computeCodeProposal(proposals, (WikiCompletionProcessor.WikiContentAssistContext)context);
        } else {
            WikiCompletionProcessor.computeFormatsProposals(proposals, (WikiCompletionProcessor.WikiContentAssistContext)context);
            WikiCompletionProcessor.computeProposals(proposals, (WikiCompletionProcessor.WikiContentAssistContext)context, Tokens.HEADINGS);
            WikiCompletionProcessor.computeBulletProposals(proposals, (WikiCompletionProcessor.WikiContentAssistContext)context);
            WikiCompletionProcessor.computeNumberedProposals(proposals, (WikiCompletionProcessor.WikiContentAssistContext)context);
            WikiCompletionProcessor.computeProposals(proposals, (WikiCompletionProcessor.WikiContentAssistContext)context, Token.HORIZONTAL_LINE);
            WikiCompletionProcessor.computeCodeProposal(proposals, (WikiCompletionProcessor.WikiContentAssistContext)context);
        }
        return proposals;
    }
}

