/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.editor.wiki;

import com.ibm.team.apt.internal.client.wiki.Attachments;
import com.ibm.team.apt.internal.client.wiki.ResolvedWikiPageAttachment;
import com.ibm.team.apt.internal.ide.ui.ImagePool;
import com.ibm.team.apt.internal.ide.ui.PlanningUIPlugin;
import com.ibm.team.apt.internal.ide.ui.editor.StyledWikiDocument;
import com.ibm.team.apt.internal.ide.ui.editor.wiki.Messages;
import com.ibm.team.apt.internal.ide.ui.editor.wiki.RichWikiDocument;
import com.ibm.team.apt.internal.ide.ui.editor.wiki.WikiDocument;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.contentassist.AdditionalInformationInput;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.contentassist.CompletionProposal;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.contentassist.ContentAssistContext;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.contentassist.ContentAssistContextProvider;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.contentassist.ContentAssistProcessor;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.contentassist.ContentAssistProposalCategory;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.contentassist.ContextProviderContentAssistContext;
import com.ibm.team.links.common.IItemReference;
import com.ibm.team.links.common.IReference;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.common.internal.wiki.transformer.Token;
import com.ibm.team.workitem.common.internal.wiki.transformer.Tokens;
import com.ibm.team.workitem.common.internal.wiki.transformer.Transformer;
import com.ibm.team.workitem.common.model.IAttachment;
import com.ibm.team.workitem.common.model.IAttachmentHandle;
import com.ibm.team.workitem.common.model.WorkItemEndPoints;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class WikiCompletionProcessor
extends ContentAssistProcessor {
    private final ResourceManager fResources;
    private Map<Token, Image> fImageMap = new HashMap<Token, Image>();
    private Image fImgAttachment;
    private ContentAssistContextProvider fContextProvider;

    public WikiCompletionProcessor(ContentAssistProposalCategory[] categories, ContentAssistant assistant, String partition, ResourceManager resources, ContentAssistContextProvider contextProvider) {
        super(categories, assistant, partition);
        this.fContextProvider = contextProvider;
        this.fResources = resources;
        this.createResources();
    }

    protected ContentAssistContext createContext(ITextViewer viewer, int offset) {
        return new WikiContentAssistContext(viewer, offset, this.fImageMap, this.fImgAttachment, this.fContextProvider);
    }

    protected void createResources() {
        Image image = this.fResources.createImage(ImagePool.LIST_BULLETED);
        this.fImageMap.put(Token.BULLET_1, image);
        this.fImageMap.put(Token.BULLET_2, image);
        this.fImageMap.put(Token.BULLET_3, image);
        this.fImageMap.put(Token.BULLET_4, image);
        this.fImageMap.put(Token.BULLET_5, image);
        image = this.fResources.createImage(ImagePool.LIST_NUMBERED);
        this.fImageMap.put(Token.NUMBERED_1, image);
        this.fImageMap.put(Token.NUMBERED_2, image);
        this.fImageMap.put(Token.NUMBERED_3, image);
        this.fImageMap.put(Token.NUMBERED_4, image);
        this.fImageMap.put(Token.NUMBERED_5, image);
        image = this.fResources.createImage(ImagePool.HEADINGS);
        this.fImageMap.put(Token.HEADING_1, image);
        this.fImageMap.put(Token.HEADING_2, image);
        this.fImageMap.put(Token.HEADING_3, image);
        this.fImageMap.put(Token.HEADING_4, image);
        this.fImageMap.put(Token.HEADING_5, image);
        this.fImageMap.put(Token.HEADING_6, image);
        image = this.fResources.createImage(ImagePool.EMPHASIS_BOLD);
        this.fImageMap.put(Token.BOLD, image);
        image = this.fResources.createImage(ImagePool.EMPHASIS_ITALIC);
        this.fImageMap.put(Token.ITALICS, image);
        image = this.fResources.createImage(ImagePool.EMPHASIS_UNDERLINE);
        this.fImageMap.put(Token.UNDERLINE, image);
        image = this.fResources.createImage(ImagePool.EMPHASIS_STRIKEOUT);
        this.fImageMap.put(Token.STRIKE_OUT, image);
        image = this.fResources.createImage(ImagePool.CODE_INLINE);
        this.fImageMap.put(Token.CODE_START, image);
        image = this.fResources.createImage(ImagePool.HLINE);
        this.fImageMap.put(Token.HORIZONTAL_LINE, image);
        this.fImgAttachment = this.fResources.createImage(ImagePool.ADD_ATTACHMENT);
    }

    public static void computeBulletProposals(List<ICompletionProposal> list, WikiContentAssistContext context) {
        int count = WikiCompletionProcessor.countCharAtBeginOfPreviousLine('*', context.getOffset(), context.getDocument());
        Token[] tokens = new Token[Math.min(count + 1, Tokens.BULLET_ITEMS.length)];
        System.arraycopy(Tokens.BULLET_ITEMS, 0, tokens, 0, tokens.length);
        WikiCompletionProcessor.computeProposals(list, context, tokens);
    }

    public static void computeNumberedProposals(List<ICompletionProposal> list, WikiContentAssistContext context) {
        int count = WikiCompletionProcessor.countCharAtBeginOfPreviousLine('#', context.getOffset(), context.getDocument());
        Token[] tokens = new Token[Math.min(count + 1, Tokens.NUMBERED_ITEMS.length)];
        System.arraycopy(Tokens.NUMBERED_ITEMS, 0, tokens, 0, tokens.length);
        WikiCompletionProcessor.computeProposals(list, context, tokens);
    }

    public static void computeProposals(List<ICompletionProposal> proposals, WikiContentAssistContext context, Token ... tokens) {
        String prefix = context.getPrefix();
        if (prefix.length() == 0 && WikiCompletionProcessor.offsetInLine(context.getOffset(), context.getDocument()) != 0) {
            return;
        }
        Token[] tokenArray = tokens;
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            final Token token = tokenArray[n2];
            if (token.wiki.startsWith(prefix)) {
                String replaceStr = String.valueOf(token.wiki) + ' ';
                proposals.add((ICompletionProposal)new TokenBasedProposal(token, context.getTokenImage(token), replaceStr, context.getOffset() - prefix.length(), prefix.length(), replaceStr.length()){

                    @Override
                    public String getAdditionalProposalInfo() {
                        return WikiCompletionProcessor.computeFormattingsInfo(token, token.wiki, null);
                    }
                });
            }
            ++n2;
        }
    }

    public static void computeFormatsProposals(List<ICompletionProposal> list, WikiContentAssistContext context) {
        Token[] formats = new Token[]{Token.BOLD, Token.ITALICS, Token.UNDERLINE, Token.STRIKE_OUT};
        String prefix = context.getPrefix();
        Token[] tokenArray = formats;
        int n = formats.length;
        int n2 = 0;
        while (n2 < n) {
            Token token = tokenArray[n2];
            String replaceStr = String.valueOf(token.wiki) + token.wiki;
            int replaceOffset = context.getOffset();
            int replaceLength = 0;
            if (token.wiki.startsWith(prefix)) {
                replaceOffset -= prefix.length();
                replaceLength = prefix.length();
            }
            list.add((ICompletionProposal)new TokenBasedProposal(token, context.getTokenImage(token), replaceStr, replaceOffset, replaceLength, token.wiki.length()));
            ++n2;
        }
    }

    public static void computeCodeProposal(List<ICompletionProposal> list, WikiContentAssistContext context) {
        String prefix = context.getPrefix();
        if (Token.CODE_START.wiki.startsWith(prefix)) {
            final StringBuilder text = new StringBuilder();
            text.append(Token.CODE_START.wiki);
            text.append(Token.CODE_END.wiki);
            list.add((ICompletionProposal)new TokenBasedProposal(Token.CODE_START, context.getTokenImage(Token.CODE_START), text.toString(), context.getOffset() - prefix.length(), prefix.length(), 3){

                public String getDisplayString() {
                    return text.toString();
                }

                @Override
                public String getAdditionalProposalInfo() {
                    return WikiCompletionProcessor.computeFormattingsInfo(NLS.bind((String)"{0}{1}{0}", (Object)Token.BOLD.wiki, (Object[])new Object[]{Messages.WikiCompletionProcessor_UNFORMATTED_TEXT}), Token.CODE_START.wiki, Token.CODE_END.wiki);
                }
            });
        }
    }

    public static void computeForegroundProposals(List<ICompletionProposal> list, WikiContentAssistContext context) {
        String prefix = context.getPrefix();
        Token[] tokenArray = Tokens.BASE_COLORS;
        int n = Tokens.BASE_COLORS.length;
        int n2 = 0;
        while (n2 < n) {
            final Token token = tokenArray[n2];
            final String before = String.valueOf(token.wiki) + Token.COLOR.wiki;
            final String after = Token.COLOR.wiki;
            int replaceOffset = context.getOffset();
            int replaceLength = 0;
            if (token.wiki.startsWith(prefix)) {
                replaceOffset -= prefix.length();
                replaceLength = prefix.length();
            }
            list.add((ICompletionProposal)new TokenBasedProposal(token, context.getTokenImage(token), String.valueOf(before) + after, replaceOffset, replaceLength, before.length()){

                public String getDisplayString() {
                    return NLS.bind((String)Messages.WikiCompletionProcessor_FOREGROUND_PROPOSAL, (Object)Tokens.getDisplayString((Token)token), (Object[])new Object[]{Token.COLOR.wiki});
                }

                @Override
                public String getAdditionalProposalInfo() {
                    return WikiCompletionProcessor.computeFormattingsInfo(token, before, after);
                }
            });
            ++n2;
        }
    }

    public static void computeBackgroundProposals(List<ICompletionProposal> list, WikiContentAssistContext context) {
        String prefix = context.getPrefix();
        Token[] tokenArray = Tokens.BASE_COLORS;
        int n = Tokens.BASE_COLORS.length;
        int n2 = 0;
        while (n2 < n) {
            final Token token = tokenArray[n2];
            final String before = Token.COLOR.wiki;
            final String after = String.valueOf(Token.COLOR.wiki) + token.wiki;
            int colorTokenLength = Token.COLOR.wiki.length();
            String replaceString = String.valueOf(before) + after;
            int cursorOffset = colorTokenLength;
            int replaceOffset = context.getOffset();
            int replaceLength = 0;
            if (Token.COLOR.wiki.startsWith(prefix)) {
                replaceOffset -= prefix.length();
                replaceLength = prefix.length();
            } else if (prefix.endsWith(Token.COLOR.wiki)) {
                replaceString = token.wiki;
                cursorOffset = token.wiki.length();
            }
            list.add((ICompletionProposal)new TokenBasedProposal(token, context.getTokenImage(token), replaceString, replaceOffset, replaceLength, cursorOffset){

                public String getDisplayString() {
                    return NLS.bind((String)Messages.WikiCompletionProcessor_BACKGROUND_PROPOSAL, (Object)Tokens.getDisplayString((Token)token), (Object[])new Object[]{Token.COLOR.wiki});
                }

                @Override
                public String getAdditionalProposalInfo() {
                    return WikiCompletionProcessor.computeFormattingsInfo(token, before, after);
                }
            });
            ++n2;
        }
    }

    public static void computeAttachmentProposals(List<ICompletionProposal> list, WikiContentAssistContext context) {
        WikiDocument document;
        String prefix = context.getPrefix();
        IDocument doc = context.getDocument();
        if (doc instanceof StyledWikiDocument) {
            document = (StyledWikiDocument)doc;
            List attachments = ((StyledWikiDocument)document).getPage().getAttachments();
            for (ResolvedWikiPageAttachment attachment : attachments) {
                String name = attachment.getAttachment().getName();
                String replaceStr = Attachments.asWiki((ResolvedWikiPageAttachment)attachment);
                WikiCompletionProcessor.addAttachmentProposal(list, context, prefix, name, replaceStr, replaceStr);
            }
        }
        if (doc instanceof RichWikiDocument) {
            document = (RichWikiDocument)doc;
            WorkItemWorkingCopy workingCopy = ((RichWikiDocument)document).getWorkItem();
            IAuditableClient auditableClient = (IAuditableClient)workingCopy.getTeamRepository().getClientLibrary(IAuditableClient.class);
            try {
                String linkAttachment = com.ibm.team.workitem.common.internal.linkdetection.Messages.getString(null, (String)"AttachmentLinkDetector.ATTACHMENT");
                for (IReference ref : workingCopy.getReferences().getReferences(WorkItemEndPoints.ATTACHMENT)) {
                    IAttachment attachment = (IAttachment)auditableClient.resolveAuditable((IAuditableHandle)((IAttachmentHandle)((IItemReference)ref).getReferencedItem()), IAttachment.SMALL_PROFILE, null);
                    String name = attachment.getName();
                    String replaceStr = Attachments.asWiki((IAttachment)attachment, (String)linkAttachment);
                    WikiCompletionProcessor.addAttachmentProposal(list, context, prefix, name, replaceStr, name);
                }
            }
            catch (TeamRepositoryException teamRepositoryException) {
                // empty catch block
            }
        }
    }

    private static void addAttachmentProposal(List<ICompletionProposal> list, WikiContentAssistContext context, String prefix, String name, final String replaceStr, final String additionalInfo) {
        int len = 0;
        if (name.startsWith(prefix)) {
            len = prefix.length();
        }
        list.add((ICompletionProposal)new TokenBasedProposal(replaceStr, context.getAttachementImage(), context.getOffset() - len, len, replaceStr.length()){

            public String getDisplayString() {
                return replaceStr;
            }

            @Override
            public String getAdditionalProposalInfo() {
                return additionalInfo;
            }
        });
    }

    private static String computeFormattingsInfo(Token token, String before, String after) {
        return WikiCompletionProcessor.computeFormattingsInfo(Tokens.getDisplayString((Token)token), before, after);
    }

    private static String computeFormattingsInfo(String token, String before, String after) {
        StringBuilder text = new StringBuilder();
        if (before != null) {
            text.append(before);
        }
        text.append(token);
        if (after != null) {
            text.append(after);
        }
        text.append(new Transformer().transform(text.toString(), EnumSet.noneOf(Transformer.Option.class)));
        return text.toString();
    }

    private static int offsetInLine(int offset, IDocument document) {
        try {
            IRegion region = document.getLineInformationOfOffset(offset);
            return offset - region.getOffset();
        }
        catch (BadLocationException e) {
            PlanningUIPlugin.log(e);
            return -1;
        }
    }

    private static int countCharAtBeginOfPreviousLine(char ch, int offset, IDocument document) {
        int line;
        block4: {
            line = document.getLineOfOffset(offset);
            if (line != 0) break block4;
            return -1;
        }
        try {
            IRegion region = document.getLineInformation(line - 1);
            String prefix = document.get(region.getOffset(), region.getLength());
            int count = 0;
            int index = 0;
            while (index < prefix.length() && prefix.charAt(index++) == ch) {
                ++count;
            }
            return count;
        }
        catch (BadLocationException e) {
            PlanningUIPlugin.log(e);
            return -1;
        }
    }

    public static class TokenBasedProposal
    extends CompletionProposal
    implements Comparable<TokenBasedProposal> {
        private final String fReplaceStr;
        private final int fReplaceOffset;
        private final int fReplaceLength;
        private final int fCursorOffset;
        private final Token fToken;

        public TokenBasedProposal(Token token, Image image, String replaceStr, int replaceOffset, int replaceLength, int cursorOffset) {
            super(NLS.bind((String)Messages.WikiCompletionProcessor_PROPOSAL_LABEL, (Object)Tokens.getDisplayString((Token)token), (Object[])new Object[]{token.wiki}), image);
            Assert.isNotNull((Object)token);
            Assert.isNotNull((Object)replaceStr);
            Assert.isLegal((replaceOffset >= 0 ? 1 : 0) != 0);
            Assert.isLegal((replaceLength >= 0 ? 1 : 0) != 0);
            this.fReplaceStr = replaceStr;
            this.fReplaceOffset = replaceOffset;
            this.fReplaceLength = replaceLength;
            this.fCursorOffset = cursorOffset;
            this.fToken = token;
        }

        public TokenBasedProposal(String replaceStr, Image image, int replaceOffset, int replaceLength, int cursorOffset) {
            super(replaceStr, image);
            Assert.isNotNull((Object)replaceStr);
            Assert.isLegal((replaceOffset >= 0 ? 1 : 0) != 0);
            Assert.isLegal((replaceLength >= 0 ? 1 : 0) != 0);
            this.fReplaceStr = replaceStr;
            this.fReplaceOffset = replaceOffset;
            this.fReplaceLength = replaceLength;
            this.fCursorOffset = cursorOffset;
            this.fToken = null;
        }

        public void apply(IDocument document, char trigger, int offset) {
            try {
                document.replace(this.fReplaceOffset, this.fReplaceLength, this.fReplaceStr);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        public String getAdditionalProposalInfo() {
            return WikiCompletionProcessor.computeFormattingsInfo(this.fToken, this.fToken.wiki, this.fToken.wiki);
        }

        public boolean isValidFor(IDocument document, int offset) {
            return true;
        }

        protected AdditionalInformationInput getAdditionaInformationInput(IProgressMonitor monitor) {
            String info = this.getAdditionalProposalInfo();
            return new AdditionalInformationInput(info, info);
        }

        public Point getSelection(IDocument document) {
            return new Point(this.fReplaceOffset + this.fCursorOffset, 0);
        }

        @Override
        public int compareTo(TokenBasedProposal o) {
            return -(this.fReplaceLength - o.fReplaceLength);
        }
    }

    static class WikiContentAssistContext
    extends ContextProviderContentAssistContext {
        private final Map<Token, Image> fImageMap;
        private final Image fImgAttachment;

        public WikiContentAssistContext(ITextViewer viewer, int offset, Map<Token, Image> imageMap, Image imgAttachment, ContentAssistContextProvider contextProvider) {
            super(viewer, offset, contextProvider);
            this.fImageMap = imageMap;
            this.fImgAttachment = imgAttachment;
        }

        public Image getTokenImage(Token token) {
            return this.fImageMap.get(token);
        }

        public Image getAttachementImage() {
            return this.fImgAttachment;
        }
    }
}

