/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.editor.wiki;

import com.ibm.team.apt.internal.ide.ui.editor.Messages;
import com.ibm.team.apt.internal.ide.ui.util.UI;
import java.util.Collection;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Control;

public class ScriptExecutor
extends Job {
    private final LinkedBlockingQueue<String> fQueue = new LinkedBlockingQueue();
    private final Browser fBrowser;

    public ScriptExecutor(Browser browser) {
        super(Messages.WikiFormPage2_JOB_RUN_SCRIPTS);
        this.setSystem(true);
        this.fBrowser = browser;
        this.fBrowser.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ScriptExecutor.this.fQueue.clear();
            }
        });
    }

    public void post(String script) {
        this.fQueue.add(script);
        this.schedule();
    }

    public void post(Collection<String> scripts) {
        this.fQueue.addAll(scripts);
        this.schedule();
    }

    public boolean shouldRun() {
        final boolean[] visible = new boolean[1];
        UI.syncExec((Control)this.fBrowser, new Runnable(){

            @Override
            public void run() {
                visible[0] = ScriptExecutor.this.fBrowser.getVisible();
            }
        });
        return visible[0] && !this.fQueue.isEmpty();
    }

    protected IStatus run(IProgressMonitor monitor) {
        while (!this.fQueue.isEmpty()) {
            try {
                final String script = this.fQueue.poll(500L, TimeUnit.MILLISECONDS);
                if (script == null) continue;
                UI.syncExec((Control)this.fBrowser, new Runnable(){

                    @Override
                    public void run() {
                        ScriptExecutor.this.fBrowser.execute(script);
                    }
                });
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return Status.OK_STATUS;
    }
}

