/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.editor.wiki;

import com.ibm.team.apt.internal.ide.core.common.StyleSheetResources;
import com.ibm.team.apt.internal.ide.ui.editor.wiki.WikiDocument;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.common.internal.wiki.transformer.Transformer;
import java.util.EnumSet;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.forms.FormColors;

public class RichWikiDocument
extends WikiDocument {
    private static final String PLAN_EDITOR_FONT_FAMILY = "$planEditorFontFamily$";
    private static final String PLAN_EDITOR_FONT_SIZE = "$planEditorFontSize$";
    private static final String PLAN_EDITOR_HEADING_COLOR = "$planEditorHeadingColor$";
    private static final String PLAN_EDITOR_KEY_LINE_COLOR = "$planEditorKeyLineColor$";
    private static final boolean IS_MAC = "carbon".equals(SWT.getPlatform()) || "cocoa".equals(SWT.getPlatform());
    private static final IPath STYLE_SHEET_LOCATION = new Path("resources/planNotes/");
    private final String TEMPLATE = "<html><head><style><!--STYLE--></style><script><!--SCRIPT--></script></head><body><!--BODY--></body></html>";
    private String fScript = "";
    private String fStyle = "";
    private WorkItemWorkingCopy fWorkItem = null;

    public static String defaultStyles(Control control) {
        StringBuilder css = new StringBuilder();
        css.append(RichWikiDocument.loadDefaultStyle(control));
        return css.toString();
    }

    private static String loadDefaultStyle(Control control) {
        String styleInformation = StyleSheetResources.getStyleSheet((IPath)STYLE_SHEET_LOCATION);
        Font font = JFaceResources.getFont((String)"com.ibm.team.apt.ide.ui.iterationPlanEditor.wiki.font");
        Display display = control.getDisplay();
        RGB selectionColor = display.getSystemColor(26).getRGB();
        RGB keyLineColor = FormColors.blend((RGB)selectionColor, (RGB)new RGB(255, 255, 255), (int)30);
        boolean useSelectionColor = (selectionColor.equals((Object)display.getSystemColor(1).getRGB()) || !selectionColor.equals((Object)display.getSystemColor(2).getRGB())) && FormColors.testTwoPrimaryColors((RGB)selectionColor, (int)0, (int)120);
        RGB headingsColor = useSelectionColor ? selectionColor : FormColors.blend((RGB)selectionColor, (RGB)display.getSystemColor(24).getRGB(), (int)50);
        StringBuilder buffer = new StringBuilder(styleInformation);
        RichWikiDocument.replace(buffer, PLAN_EDITOR_FONT_FAMILY, font.getFontData()[0].getName());
        RichWikiDocument.replace(buffer, PLAN_EDITOR_FONT_SIZE, String.valueOf(font.getFontData()[0].getHeight()) + (IS_MAC ? "px" : "pt"));
        RichWikiDocument.replace(buffer, PLAN_EDITOR_HEADING_COLOR, RichWikiDocument.getColorValue(headingsColor));
        RichWikiDocument.replace(buffer, PLAN_EDITOR_KEY_LINE_COLOR, RichWikiDocument.getColorValue(keyLineColor));
        return buffer.toString();
    }

    private static String getColorValue(RGB color) {
        return String.format("#%06x", 65536 * color.red + 256 * color.green + color.blue);
    }

    private static void replace(StringBuilder buffer, String toReplace, String replacement) {
        int index = 0;
        int length = toReplace.length();
        while ((index = buffer.indexOf(toReplace, index)) != -1) {
            buffer.replace(index, index + length, replacement);
        }
    }

    public static String defaultScripts() {
        return "function replaceAll(id, text){var i= 0;for(i=0; i<id.length; i++){ var n= document.getElementById(id[i]); while (n.hasChildNodes()) { n.removeChild(n.firstChild) }; n.appendChild(document.createTextNode(text[i]));}}\nfunction updateImage(id, value){document.getElementById(id).src= value;}\n";
    }

    public RichWikiDocument(String content, Transformer transformer, EnumSet<Transformer.Option> options) {
        super(content, transformer, options);
    }

    public void setScript(String script) {
        Assert.isNotNull((Object)script);
        this.fScript = script;
    }

    public void setStyle(String style) {
        Assert.isNotNull((Object)style);
        this.fStyle = style;
    }

    public WorkItemWorkingCopy getWorkItem() {
        return this.fWorkItem;
    }

    public void setWorkItem(WorkItemWorkingCopy workitem) {
        this.fWorkItem = workitem;
    }

    @Override
    public String transform(int offset, int length, EnumSet<Transformer.Option> options) throws BadLocationException {
        String html = "<html><head><style><!--STYLE--></style><script><!--SCRIPT--></script></head><body><!--BODY--></body></html>";
        html = html.replace("<!--STYLE-->", this.fStyle);
        html = html.replace("<!--SCRIPT-->", this.fScript);
        html = html.replace("<!--BODY-->", super.transform(offset, length, options));
        return html;
    }
}

