/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.editor.wiki;

import com.ibm.team.apt.internal.common.wiki.transformer.WikiPageAttachmentReferenceDetector;
import com.ibm.team.apt.internal.ide.ui.editor.DeferredVariableResolver;
import com.ibm.team.apt.internal.ide.ui.editor.wiki.Messages;
import com.ibm.team.apt.internal.ide.ui.editor.wiki.ScriptExecutor;
import com.ibm.team.apt.internal.ide.ui.editor.wiki.WikiDocument;
import com.ibm.team.apt.internal.ide.ui.editor.wiki.WikiPartitionScanner;
import com.ibm.team.apt.internal.ide.ui.editor.wiki.WikiViewer;
import com.ibm.team.apt.internal.ide.ui.editor.wiki.WorkItemAttachmentReferenceTransformer;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.contentassist.ContentAssistContextProvider;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.contentassist.TeamContextProvider;
import com.ibm.team.jface.util.UIUpdaterJob;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.workitem.common.internal.wiki.transformer.IItemReferenceDetector;
import com.ibm.team.workitem.common.internal.wiki.transformer.IReferenceTransformer;
import com.ibm.team.workitem.common.internal.wiki.transformer.IVariableResolver;
import com.ibm.team.workitem.rcp.ui.internal.IProjectAreaContextProvider;
import java.net.URI;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class PreviewWikiViewer
extends WikiViewer {
    private UIUpdaterJob fUpdaterJob;
    private boolean fEditable = false;
    private PreviewLayout fLayout;
    private FastPartitioner fPartitioner;
    private ScriptExecutor fScriptExecutor;
    private Browser fBrowser;
    private WikiPageAttachmentReferenceDetector fReferenceDetector;
    private DeferredVariableResolver fVariableResolver;
    private IReferenceTransformer fReferenceTransformer;

    public PreviewWikiViewer(Composite parent, IVerticalRuler ruler, int styles, ContentAssistContextProvider contextProvider) {
        super(parent, ruler, styles, contextProvider);
    }

    protected void createControl(Composite parent, int styles) {
        Composite composite = new Composite(parent, 0);
        this.fLayout = new PreviewLayout(composite);
        this.fPartitioner = new FastPartitioner((IPartitionTokenScanner)new WikiPartitionScanner(), WikiPartitionScanner.Partitions.TYPES);
        composite.setLayout((Layout)this.fLayout);
        super.createControl(composite, styles);
        this.fBrowser = this.createBrowser(composite);
        this.fLayout.reveal((Control)this.fBrowser);
    }

    protected Browser createBrowser(Composite parent) {
        Browser browser = new Browser(parent, 0);
        this.fScriptExecutor = new ScriptExecutor(browser);
        return browser;
    }

    public void setDocument(IDocument document) {
        Assert.isLegal((document == null || document instanceof WikiDocument ? 1 : 0) != 0);
        int oldOffset = this.getTextWidget().getCaretOffset();
        WikiDocument oldDocument = (WikiDocument)this.getDocument();
        IUndoManager undoManager = this.getUndoManager();
        if (oldDocument != null) {
            this.fPartitioner.disconnect();
            if (undoManager != null) {
                undoManager.disconnect();
            }
        }
        if (document != null) {
            ((WikiDocument)document).setDocumentPartitioner(WikiPartitionScanner.Partitions.WIKI_PARTITING, (IDocumentPartitioner)this.fPartitioner);
            this.fPartitioner.connect(document);
            if (undoManager != null) {
                undoManager.connect((ITextViewer)this);
            }
            super.setDocument(document, (IAnnotationModel)new AnnotationModel());
            this.getTextWidget().setCaretOffset(oldOffset > this.getTextWidget().getCharCount() ? 0 : oldOffset);
        }
        this.syncView();
    }

    public void setEditable(boolean editable) {
        if (this.fEditable == editable) {
            return;
        }
        this.fEditable = editable;
        if (!this.fEditable) {
            this.syncView();
        }
        this.fLayout.reveal((Control)(this.fEditable ? super.getControl() : this.getBrowserWidget()));
    }

    @Override
    protected void handleDispose() {
        if (this.fUpdaterJob != null) {
            this.fUpdaterJob.cancel();
        }
        super.handleDispose();
    }

    private void syncView() {
        if (this.fUpdaterJob != null) {
            this.fUpdaterJob.cancel();
        }
        this.fBrowser.setText(Messages.PreviewWikiViewer_loading);
        this.fUpdaterJob = new UIUpdaterJob(Messages.PreviewWikiViewer_loadingJobName){
            String fMarkup;

            public IStatus runInBackground(IProgressMonitor monitor) {
                WikiDocument document = (WikiDocument)PreviewWikiViewer.this.getDocument();
                if (document != null) {
                    document.getTransformer().setVariableResolver(PreviewWikiViewer.this.getVariableResolver());
                    document.getTransformer().setItemReferenceDetector(PreviewWikiViewer.this.getReferenceDetector());
                    document.getTransformer().setReferenceTransformer(PreviewWikiViewer.this.getReferenceTransformer());
                    this.fMarkup = document.transform();
                }
                return super.runInBackground(monitor);
            }

            public IStatus runInUI(IProgressMonitor monitor) {
                if (PreviewWikiViewer.this.fBrowser != null && !PreviewWikiViewer.this.fBrowser.isDisposed()) {
                    PreviewWikiViewer.this.fBrowser.setText(this.fMarkup == null ? "" : this.fMarkup);
                    PreviewWikiViewer.this.fScriptExecutor.schedule();
                }
                return super.runInUI(monitor);
            }
        };
        this.fUpdaterJob.schedule();
    }

    public Control getControl() {
        return this.fLayout.getControl();
    }

    public Browser getBrowserWidget() {
        return this.fBrowser;
    }

    public boolean getEditable() {
        return this.fEditable;
    }

    @Override
    protected IVariableResolver getVariableResolver() {
        if (this.fVariableResolver != null) {
            return this.fVariableResolver;
        }
        if (this.fContextProvider instanceof TeamContextProvider) {
            ITeamRepository repository = ((TeamContextProvider)this.fContextProvider).getTeamRepository();
            this.fVariableResolver = new DeferredVariableResolver(DeferredVariableResolver.Mode.SingleDispatch, repository.itemManager(), this.fScriptExecutor);
            return this.fVariableResolver;
        }
        return super.getVariableResolver();
    }

    @Override
    protected IItemReferenceDetector getReferenceDetector() {
        if (this.fReferenceDetector != null) {
            return this.fReferenceDetector;
        }
        if (this.fContextProvider instanceof TeamContextProvider) {
            ITeamRepository repository = ((TeamContextProvider)this.fContextProvider).getTeamRepository();
            IProjectAreaHandle projectArea = null;
            if (this.fContextProvider instanceof IProjectAreaContextProvider) {
                projectArea = ((IProjectAreaContextProvider)this.fContextProvider).getProjectArea();
            }
            this.fReferenceDetector = new WikiPageAttachmentReferenceDetector(URI.create(repository.getRepositoryURI()), projectArea);
            return this.fReferenceDetector;
        }
        return super.getReferenceDetector();
    }

    protected IReferenceTransformer getReferenceTransformer() {
        if (this.fReferenceTransformer == null) {
            ITeamRepository repository = ((TeamContextProvider)this.fContextProvider).getTeamRepository();
            this.fReferenceTransformer = new WorkItemAttachmentReferenceTransformer(repository.itemManager());
        }
        return this.fReferenceTransformer;
    }

    public class PreviewLayout
    extends StackLayout {
        private Composite fReceiver;

        public PreviewLayout(Composite receiver) {
            this.fReceiver = receiver;
        }

        public void reveal(Control control) {
            this.checkHierarchy(control);
            this.topControl = control;
            this.fReceiver.layout(false, true);
            this.topControl.forceFocus();
        }

        public Composite getControl() {
            return this.fReceiver;
        }

        void checkHierarchy(Control control) {
            Control[] children;
            Control[] controlArray = children = this.fReceiver.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                if (child.equals(control)) {
                    return;
                }
                ++n2;
            }
            SWT.error((int)5);
        }
    }
}

