/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.editor.wiki;

import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public final class LineBeginRule
implements IRule {
    private final IToken fToken;
    private final char fCh;
    private final int fLen;

    LineBeginRule(char ch, int len, IToken token) {
        this.fCh = ch;
        this.fLen = len;
        this.fToken = token;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        if (scanner.getColumn() != 0) {
            return Token.UNDEFINED;
        }
        int len = this.len(scanner);
        if (len > 0) {
            while (len > this.fLen) {
                scanner.unread();
                --len;
            }
            return this.fToken;
        }
        return Token.UNDEFINED;
    }

    private int len(ICharacterScanner scanner) {
        int c = scanner.read();
        if (c == this.fCh) {
            return 1 + this.len(scanner);
        }
        if (c != -1) {
            scanner.unread();
        }
        return 0;
    }
}

