/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.editor.pages;

import com.ibm.team.apt.common.IPlanReferences;
import com.ibm.team.apt.ide.core.IResolvedIterationPlanRecord;
import com.ibm.team.calm.foundation.client.internal.ResourceReference;
import com.ibm.team.calm.foundation.client.preview.ResourceReferenceResolver;
import com.ibm.team.calm.foundation.common.preview.IResourceReferenceResolver;
import com.ibm.team.calm.foundation.rcp.ui.preview.ResourceReferenceContentProvider;
import com.ibm.team.calm.foundation.rcp.ui.preview.ResourceReferenceLabelProvider;
import com.ibm.team.foundation.common.internal.util.Dates;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.jface.tooltip.TooltipSupport;
import com.ibm.team.links.common.IReference;
import com.ibm.team.links.common.registry.IEndPointDescriptor;
import com.ibm.team.links.common.registry.ILinkType;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.workitem.rcp.ui.WorkItemUI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.IViewerLabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class PlanLinksTree {
    private IResolvedIterationPlanRecord fPlan;
    private TreeViewer fViewer;
    private ResourceManager fResourceManager;
    IResourceReferenceResolver fResourceReferenceResolver = new ResourceReferenceResolver();

    public PlanLinksTree(Composite parent, FormToolkit toolkit, ResourceManager resourceManager) {
        this.fResourceManager = resourceManager;
        this.createTree(parent, toolkit);
    }

    public void setInput(Object input) {
        if (input != null && input instanceof IResolvedIterationPlanRecord) {
            this.fPlan = (IResolvedIterationPlanRecord)input;
            this.fViewer.setContentProvider((IContentProvider)new PlanLinksContentProvider(this.fPlan.getTeamRepository()));
            this.fViewer.setInput((Object)this.fPlan);
            this.fViewer.expandAll();
        }
    }

    private void createTree(Composite parent, FormToolkit toolkit) {
        this.fViewer = new TreeViewer(parent, 770);
        Control control = this.fViewer.getControl();
        toolkit.adapt(control, false, false);
        control.setData("FormWidgetFactory.drawBorder", (Object)"treeBorder");
        GridData data = new GridData(4, 4, true, true);
        data.widthHint = 200;
        data.heightHint = this.fViewer.getTree().getItemHeight() * 2;
        control.setLayoutData((Object)data);
        this.fViewer.setLabelProvider((IBaseLabelProvider)new PlanLinksLabelProvider());
        this.fViewer.setComparator((ViewerComparator)new PlanLinksComparator());
        new TooltipSupport(this.fViewer.getControl(), true, false);
    }

    public TreeViewer getTreeViewer() {
        return this.fViewer;
    }

    public void addNewReferences(ILinkType linkType, IReference[] newReferences) {
        if (newReferences != null) {
            ArrayList<IReference> referencesToResolve = new ArrayList<IReference>();
            IReference[] iReferenceArray = newReferences;
            int n = newReferences.length;
            int n2 = 0;
            while (n2 < n) {
                boolean isNewLinkType;
                IReference newReference = iReferenceArray[n2];
                boolean bl = isNewLinkType = !this.hasLinkType(this.fViewer, linkType);
                if (isNewLinkType) {
                    this.fViewer.add((Object)this.fPlan, (Object)linkType);
                }
                if (newReference.isURIReference()) {
                    newReference = this.fResourceReferenceResolver.makeResolvable(newReference, (Object)this.fPlan.getTeamRepository());
                }
                if (!this.hasReference(this.fViewer, newReference)) {
                    this.fViewer.add((Object)linkType, (Object)newReference);
                }
                if (isNewLinkType) {
                    this.fViewer.expandToLevel((Object)linkType, 1);
                } else {
                    referencesToResolve.add(newReference);
                }
                ++n2;
            }
            if (!referencesToResolve.isEmpty()) {
                this.fResourceReferenceResolver.resolveInBackground(referencesToResolve);
            }
        }
    }

    public void removeReferences(ILinkType linkType, IReference[] removedReferences) {
        if (removedReferences != null) {
            IReference[] iReferenceArray = removedReferences;
            int n = removedReferences.length;
            int n2 = 0;
            while (n2 < n) {
                IReference removedReference = iReferenceArray[n2];
                IReference targetReferene = this.fResourceReferenceResolver.makeResolvable(removedReference, (Object)this.fPlan.getTeamRepository());
                this.fViewer.remove((Object)linkType, new Object[]{targetReferene});
                if (!((ITreeContentProvider)this.fViewer.getContentProvider()).hasChildren((Object)linkType)) {
                    this.fViewer.remove((Object)linkType);
                }
                ++n2;
            }
        }
    }

    private boolean hasLinkType(TreeViewer viewer, ILinkType linkType) {
        TreeItem[] typeItems = viewer.getTree().getItems();
        int i = 0;
        while (i < typeItems.length) {
            TreeItem item = typeItems[i];
            if (linkType.equals(item.getData())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean hasReference(TreeViewer viewer, IReference reference) {
        TreeItem[] typeItems = viewer.getTree().getItems();
        int i = 0;
        while (i < typeItems.length) {
            TreeItem item = typeItems[i];
            if (reference.equals(item.getData())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static class PlanLinksComparator
    extends ViewerComparator {
        private PlanLinksComparator() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof IReference && ((IReference)e1).getLink() != null && e2 instanceof IReference && ((IReference)e2).getLink() != null) {
                Date modified1 = ((IReference)e1).getLink().modified();
                Date modified2 = ((IReference)e2).getLink().modified();
                if (modified1 == null && modified2 == null) {
                    return super.compare(viewer, e1, e2);
                }
                if (modified1 == null) {
                    return 1;
                }
                if (modified2 == null) {
                    return -1;
                }
                return Dates.compareTo((Date)modified1, (Date)modified2);
            }
            return super.compare(viewer, e1, e2);
        }
    }

    private class PlanLinksContentProvider
    extends ResourceReferenceContentProvider
    implements ITreeContentProvider {
        private IResolvedIterationPlanRecord fPlan;

        public PlanLinksContentProvider(ITeamRepository teamRepository) {
            super(teamRepository);
            this.fPlan = null;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof IResolvedIterationPlanRecord) {
                this.fPlan = (IResolvedIterationPlanRecord)inputElement;
                IPlanReferences planReferences = this.fPlan.getReferences();
                Collection linkTypes = planReferences.getLinkTypes();
                HashSet<ILinkType> visible = new HashSet<ILinkType>();
                for (ILinkType linkType : linkTypes) {
                    if (linkType.isInternal() || !planReferences.hasReferences(linkType)) continue;
                    visible.add(linkType);
                }
                return this.triggerElementResolution(visible.toArray());
            }
            return new Object[0];
        }

        public boolean hasChildren(Object element) {
            if (this.fPlan != null && element instanceof ILinkType) {
                ILinkType linkType = (ILinkType)element;
                return !linkType.isInternal() && this.fPlan.getReferences().hasReferences(linkType);
            }
            return false;
        }

        public Object[] getChildren(Object parentElement) {
            Object[] result = new Object[]{};
            if (this.fPlan != null && parentElement instanceof ILinkType) {
                ILinkType linkType = (ILinkType)parentElement;
                result = this.fPlan.getReferences().getReferences(linkType).toArray();
            }
            return super.getElements((Object)result);
        }

        public Object getParent(Object element) {
            if (element instanceof IReference) {
                return ((IReference)element).getLink().getLinkType();
            }
            return null;
        }
    }

    private class PlanLinksLabelProvider
    extends ResourceReferenceLabelProvider
    implements ITableLabelProvider,
    IViewerLabelProvider,
    IFontProvider {
        private Font fLinkTypeFont;

        private PlanLinksLabelProvider() {
        }

        public void updateLabel(ViewerLabel label, Object element) {
            super.updateLabel(label, element);
            if (label.getImage() == null) {
                label.setImage(this.getColumnImage(element, 0));
            }
            if (label.getText() == null || "".equals(label.getText())) {
                label.setText(this.getColumnText(element, 0));
            }
            if (label.getFont() == null) {
                label.setFont(this.getFont(element));
            }
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (element instanceof ILinkType) {
                ILinkType linkType = (ILinkType)element;
                ImageDescriptor descriptor = WorkItemUI.getImageDescriptor((URL)linkType.getTargetEndPointDescriptor().getIcon());
                return JazzResources.getImageWithDefault((ResourceManager)PlanLinksTree.this.fResourceManager, (ImageDescriptor)descriptor);
            }
            if (element instanceof ResourceReference) {
                IEndPointDescriptor referenceType = ((ResourceReference)element).getLink().getLinkType().getTargetEndPointDescriptor();
                ImageDescriptor descriptor = WorkItemUI.getImageDescriptor((URL)referenceType.getIcon());
                return JazzResources.getImageWithDefault((ResourceManager)PlanLinksTree.this.fResourceManager, (ImageDescriptor)descriptor);
            }
            return JazzResources.getImageWithDefault((ResourceManager)PlanLinksTree.this.fResourceManager, null);
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof ILinkType) {
                return ((ILinkType)element).getTargetEndPointDescriptor().getDisplayName();
            }
            if (element instanceof IReference) {
                return ((IReference)element).getComment();
            }
            return element.toString();
        }

        public Font getFont(Object element) {
            if (element instanceof ILinkType) {
                if (this.fLinkTypeFont == null) {
                    Font defaultFont = JFaceResources.getDefaultFont();
                    FontData[] data = defaultFont.getFontData();
                    int i = 0;
                    while (i < data.length) {
                        data[i].setStyle(1);
                        ++i;
                    }
                    this.fLinkTypeFont = PlanLinksTree.this.fResourceManager.createFont(FontDescriptor.createFrom((FontData[])data));
                }
                return this.fLinkTypeFont;
            }
            return null;
        }

        public void dispose() {
            super.dispose();
            if (PlanLinksTree.this.fResourceManager != null) {
                PlanLinksTree.this.fResourceManager.dispose();
                PlanLinksTree.this.fResourceManager = null;
            }
        }
    }
}

