/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.editor.pages;

import com.ibm.team.apt.ide.core.IResolvedIterationPlanRecord;
import com.ibm.team.apt.internal.ide.ui.ImagePool;
import com.ibm.team.apt.internal.ide.ui.editor.pages.Messages;
import com.ibm.team.apt.internal.ide.ui.editor.pages.PlanLinkActions;
import com.ibm.team.calm.foundation.client.linking.CALMLinkingCache;
import com.ibm.team.calm.foundation.common.linking.CALMLinkTypeInformation;
import com.ibm.team.calm.foundation.common.linking.CALMLinkTypeInformationRegistry;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.links.common.registry.ILinkType;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.IInputSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.texteditor.IUpdate;

public class PlanLinksToolPanel {
    private final CALMLinkingCache fCALMLinkingCache;
    private final PlanLinkActions fPlanLinkActions;
    private ResourceManager fResourceManager = new LocalResourceManager(JFaceResources.getResources());

    public PlanLinksToolPanel(IResolvedIterationPlanRecord plan, CALMLinkingCache calmLinkingCache) {
        this.fCALMLinkingCache = calmLinkingCache;
        this.fPlanLinkActions = new PlanLinkActions(plan);
    }

    public void createToolPanel(IWorkbenchPage page, Composite parent, FormToolkit toolkit, TreeViewer treeViewer) {
        Composite toolPanel = toolkit.createComposite(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        toolPanel.setLayout((Layout)layout);
        toolkit.paintBordersFor(toolPanel);
        AddLinkDropDownButton addLinkButton = new AddLinkDropDownButton(page, toolPanel, toolkit);
        addLinkButton.getControl().setLayoutData((Object)new GridData(4, 128, false, false));
        ActionButton openLink = new ActionButton((StructuredViewer)treeViewer, this.fPlanLinkActions.getOpenAction((IInputSelectionProvider)treeViewer), toolPanel, toolkit);
        openLink.getControl().setLayoutData((Object)new GridData(4, 128, false, false));
        ActionButton deleteLink = new ActionButton((StructuredViewer)treeViewer, this.fPlanLinkActions.getDeleteAction((IInputSelectionProvider)treeViewer), toolPanel, toolkit);
        deleteLink.getControl().setLayoutData((Object)new GridData(4, 128, false, false));
        toolPanel.setLayoutData((Object)new GridData(4, 128, false, false));
    }

    public Action getOpenLinkAction(TreeViewer treeViewer) {
        return this.fPlanLinkActions.getOpenAction((IInputSelectionProvider)treeViewer);
    }

    public Action getDeleteLinkAction(TreeViewer treeViewer) {
        return this.fPlanLinkActions.getDeleteAction((IInputSelectionProvider)treeViewer);
    }

    public void addEmptySelectionActions(IWorkbenchPage page, IMenuManager manager) {
        Collection calmLinkTypes = this.fCALMLinkingCache.getAvailableLinkTypes();
        boolean hasAdded = false;
        for (CALMLinkTypeInformation calmLinkType : calmLinkTypes) {
            if (!calmLinkType.hasPickerServiceDescriptionForTarget()) continue;
            manager.add((IAction)this.fPlanLinkActions.getAddAction(page, this.fCALMLinkingCache, calmLinkType));
            hasAdded = true;
        }
        if (!hasAdded) {
            manager.add((IAction)new Action(Messages.PlanLinks_NoLinks){});
        } else {
            manager.add((IContributionItem)new Separator());
        }
        manager.add((IContributionItem)new Separator("additions"));
    }

    public void addEndpointActions(IWorkbenchPage page, IMenuManager manager, List<ILinkType> linkTypes, IInputSelectionProvider inputProvider) {
        PlanLinkActions.DeleteLinkAction delete;
        ISelection selection = inputProvider.getSelection();
        if (selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
            return;
        }
        PlanLinkActions.OpenLinkAction open = this.fPlanLinkActions.getOpenAction(inputProvider);
        if (open.isEnabled()) {
            manager.add((IAction)open);
        }
        manager.add((IContributionItem)new Separator());
        if (linkTypes != null) {
            for (ILinkType linkType : linkTypes) {
                PlanLinkActions.AddLinkAction add = this.fPlanLinkActions.getAddAction(page, this.fCALMLinkingCache, CALMLinkTypeInformationRegistry.getLinkTypeInformation((ILinkType)linkType));
                if (!add.isEnabled()) continue;
                manager.add((IAction)add);
            }
        }
        if ((delete = this.fPlanLinkActions.getDeleteAction(inputProvider)).isEnabled()) {
            manager.add((IAction)delete);
        }
        manager.add((IContributionItem)new Separator("additions"));
    }

    private class ActionButton {
        private Action fAction;
        private Button fButton;
        private StructuredViewer fViewer;

        public ActionButton(StructuredViewer viewer, String text, Composite parent, FormToolkit toolkit) {
            this.fViewer = viewer;
            this.fButton = toolkit.createButton(parent, text, 0);
            this.fButton.setEnabled(false);
            this.fButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (ActionButton.this.fAction != null && ActionButton.this.fAction.isEnabled()) {
                        ActionButton.this.fAction.run();
                    }
                }
            });
        }

        public ActionButton(StructuredViewer viewer, Action action, Composite parent, FormToolkit toolkit) {
            this(viewer, action.getText(), parent, toolkit);
            this.fAction = action;
            this.fButton.setEnabled(this.fAction.isEnabled());
            this.configureAction();
        }

        private void configureAction() {
            if (this.fAction != null && this.fAction instanceof IUpdate) {
                this.fViewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent event) {
                        ((IUpdate)ActionButton.this.fAction).update();
                        ActionButton.this.fButton.setEnabled(ActionButton.this.fAction.isEnabled());
                    }
                });
            }
        }

        public void setAction(Action action) {
            this.fAction = action;
            this.fButton.setEnabled(this.fAction.isEnabled());
            this.configureAction();
        }

        public Control getControl() {
            return this.fButton;
        }
    }

    private class AddLinkDropDownButton {
        private Button fButton;

        AddLinkDropDownButton(final IWorkbenchPage page, Composite parent, FormToolkit toolkit) {
            this.fButton = toolkit.createButton(parent, Messages.PlanLinks_ADD, 0x4000000);
            this.fButton.setImage(JazzResources.getImageWithDefault((ResourceManager)PlanLinksToolPanel.this.fResourceManager, (ImageDescriptor)ImagePool.DROPDOWN));
            this.fButton.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    Menu menu = AddLinkDropDownButton.this.getMenu((Control)AddLinkDropDownButton.this.fButton, page);
                    Point location = AddLinkDropDownButton.this.fButton.getParent().toDisplay(AddLinkDropDownButton.this.fButton.getLocation());
                    location.y += ((AddLinkDropDownButton)AddLinkDropDownButton.this).fButton.getBounds().height;
                    menu.setLocation(location);
                    AddLinkDropDownButton.this.showAndDisposeOnHide(menu);
                }
            });
        }

        public Control getControl() {
            return this.fButton;
        }

        private Menu getMenu(Control parent, IWorkbenchPage page) {
            MenuManager manager = new MenuManager();
            PlanLinksToolPanel.this.addEmptySelectionActions(page, (IMenuManager)manager);
            return manager.createContextMenu(parent);
        }

        private void showAndDisposeOnHide(Menu menu) {
            menu.setVisible(true);
            menu.addMenuListener((MenuListener)new MenuAdapter(){

                public void menuHidden(final MenuEvent e) {
                    e.display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            e.widget.dispose();
                        }
                    });
                }
            });
        }
    }
}

