/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.editor.pages;

import com.ibm.team.apt.common.IIterationPlanRecord;
import com.ibm.team.apt.ide.core.IResolvedIterationPlanRecord;
import com.ibm.team.apt.ide.ui.editor.IterationPlanEditorPage;
import com.ibm.team.apt.internal.client.IPlanReferenceListener;
import com.ibm.team.apt.internal.ide.ui.editor.IterationPlanEditor;
import com.ibm.team.apt.internal.ide.ui.editor.pages.Messages;
import com.ibm.team.apt.internal.ide.ui.editor.pages.PlanLinksToolPanel;
import com.ibm.team.apt.internal.ide.ui.editor.pages.PlanLinksTree;
import com.ibm.team.apt.internal.ide.ui.util.UI;
import com.ibm.team.calm.foundation.client.linking.CALMLinkingCache;
import com.ibm.team.jface.util.ConvertingSelectionProvider;
import com.ibm.team.links.common.IReference;
import com.ibm.team.links.common.registry.ILinkType;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.ui.editor.TeamFormPart;
import com.ibm.team.ui.editor.TeamFormSectionPart;
import com.ibm.team.workitem.client.internal.util.ClientUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.IInputSelectionProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class PlanLinksPage
extends IterationPlanEditorPage {
    private IResolvedIterationPlanRecord fPlanRecord;
    private PlanLinksTree fPlanLinksTree;
    private CALMLinkingCache fCALMLinkingCache;

    public PlanLinksPage(FormEditor editor, String id, String title) {
        super(editor, id, title);
    }

    @Override
    public void setInput(IResolvedIterationPlanRecord record) {
        this.fPlanRecord = record;
        ((IterationPlanEditor)this.getEditor()).getIterationPlanData().addPlanReferenceListener(new IPlanReferenceListener(){

            public void referencesAdded(ILinkType linkType, IReference[] addedReferences) {
                PlanLinksPage.this.fPlanLinksTree.addNewReferences(linkType, addedReferences);
            }

            public void referencesRemoved(ILinkType linkType, IReference[] removedReferences) {
                PlanLinksPage.this.fPlanLinksTree.removeReferences(linkType, removedReferences);
            }
        });
    }

    protected void createFormContent(IManagedForm form) {
        UI.hookHelpListener((Control)this.getManagedForm().getForm(), "com.ibm.team.apt.ide.ui.tab_plan_links");
        Composite body = form.getForm().getBody();
        body.setLayout((Layout)new GridLayout(1, false));
        SashForm tab = new SashForm(body, 512);
        tab.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        form.getToolkit().adapt((Composite)tab);
        PlanLinksPart linksPart = new PlanLinksPart();
        int style = 256;
        style |= 0x40;
        TeamFormSectionPart teamForm = new TeamFormSectionPart(form, (Composite)tab, style |= 0x2000, Messages.PlanLinks_Links, new TeamFormPart[]{linksPart});
        tab.setWeights(new int[]{1});
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 100;
        teamForm.getSection().setLayoutData((Object)data);
        linksPart.setInput(this.fPlanRecord);
    }

    public static class InternalConvertingSelectionProvider
    extends ConvertingSelectionProvider {
        private Viewer fViewer;

        public InternalConvertingSelectionProvider(Viewer viewer) {
            super((ISelectionProvider)viewer);
            this.fViewer = viewer;
        }

        protected ISelection convertFrom(ISelection viewerSelection) {
            if (!(viewerSelection instanceof IStructuredSelection)) {
                return viewerSelection;
            }
            Object input = this.fViewer.getInput();
            if (!(input instanceof IResolvedIterationPlanRecord)) {
                return viewerSelection;
            }
            IStructuredSelection selection = (IStructuredSelection)viewerSelection;
            ArrayList<Object> result = new ArrayList<Object>(selection.size());
            for (Object element : selection) {
                IItemHandle adapter = null;
                if (element instanceof IReference) {
                    adapter = ClientUtils.findItemHandle((String)((IResolvedIterationPlanRecord)input).getTeamRepository().getRepositoryURI(), (IReference)((IReference)element));
                }
                if (adapter != null) {
                    result.add(adapter);
                    continue;
                }
                result.add(element);
            }
            return new StructuredSelection(result);
        }
    }

    private class PlanLinksPart
    extends TeamFormPart {
        private ResourceManager fResourceManager = new LocalResourceManager(JFaceResources.getResources());

        private PlanLinksPart() {
        }

        public void createContent(Composite parent) {
            FormToolkit toolkit = this.getSite().getToolkit();
            toolkit.setBorderStyle(0);
            GridLayout layout = new GridLayout(2, false);
            layout.marginHeight = 1;
            layout.marginWidth = 1;
            parent.setLayout((Layout)layout);
            PlanLinksPage.this.fCALMLinkingCache = new CALMLinkingCache(IIterationPlanRecord.ITEM_TYPE, (IProjectAreaHandle)PlanLinksPage.this.fPlanRecord.getProjectArea());
            this.initializeCALMLinkingCache();
            final PlanLinksToolPanel toolPanel = new PlanLinksToolPanel(PlanLinksPage.this.fPlanRecord, PlanLinksPage.this.fCALMLinkingCache);
            PlanLinksPage.this.fPlanLinksTree = new PlanLinksTree(parent, toolkit, this.fResourceManager);
            PlanLinksPage.this.fPlanLinksTree.getTreeViewer().addOpenListener(new IOpenListener(){

                public void open(OpenEvent event) {
                    toolPanel.getOpenLinkAction(PlanLinksPage.this.fPlanLinksTree.getTreeViewer()).run();
                }
            });
            PlanLinksPage.this.fPlanLinksTree.getTreeViewer().getControl().addKeyListener(new KeyListener(){

                public void keyReleased(KeyEvent e) {
                    if (e.keyCode == 127) {
                        toolPanel.getDeleteLinkAction(PlanLinksPage.this.fPlanLinksTree.getTreeViewer()).run();
                    }
                }

                public void keyPressed(KeyEvent e) {
                }
            });
            this.getSite().registerSelectionProvider((ISelectionProvider)PlanLinksPage.this.fPlanLinksTree.getTreeViewer(), PlanLinksPage.this.fPlanLinksTree.getTreeViewer().getControl());
            toolPanel.createToolPanel(this.getSite().getWorkbenchPage(), parent, toolkit, PlanLinksPage.this.fPlanLinksTree.getTreeViewer());
            this.createContextMenu(PlanLinksPage.this.fPlanLinksTree.getTreeViewer(), PlanLinksPage.this.fPlanLinksTree.getTreeViewer().getControl(), toolPanel);
            toolkit.paintBordersFor(parent);
        }

        public void setInput(Object input) {
            PlanLinksPage.this.fPlanLinksTree.setInput(input);
        }

        public boolean stretchHorizontally() {
            return true;
        }

        public boolean stretchVertically() {
            return true;
        }

        private void initializeCALMLinkingCache() {
            try {
                this.getSite().getWorkbenchPage().getWorkbenchWindow().run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor progressMonitor) throws InvocationTargetException {
                        try {
                            PlanLinksPart.this.performCALMLinkingCacheInit(progressMonitor);
                        }
                        catch (TeamRepositoryException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                });
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        private void performCALMLinkingCacheInit(IProgressMonitor monitor) throws TeamRepositoryException {
            PlanLinksPage.this.fCALMLinkingCache.initialize(monitor);
        }

        private void createContextMenu(TreeViewer treeViewer, Control control, final PlanLinksToolPanel toolPanel) {
            MenuManager menuMgr = new MenuManager("#PopupMenu");
            menuMgr.setRemoveAllWhenShown(true);
            menuMgr.addMenuListener(new IMenuListener(){

                public void menuAboutToShow(IMenuManager manager) {
                    PlanLinksPart.this.addSelectionActions(PlanLinksPart.this.getSite().getWorkbenchPage(), manager, (IInputSelectionProvider)PlanLinksPage.this.fPlanLinksTree.getTreeViewer(), toolPanel);
                }
            });
            this.getSite().registerContextMenu(this.getId(), menuMgr, (ISelectionProvider)new InternalConvertingSelectionProvider((Viewer)PlanLinksPage.this.fPlanLinksTree.getTreeViewer()));
            Menu menu = menuMgr.createContextMenu(control);
            control.setMenu(menu);
        }

        private void addSelectionActions(IWorkbenchPage page, IMenuManager manager, IInputSelectionProvider inputProvider, PlanLinksToolPanel toolPanel) {
            if (inputProvider.getSelection().isEmpty()) {
                toolPanel.addEmptySelectionActions(page, manager);
                return;
            }
            IStructuredSelection selection = (IStructuredSelection)inputProvider.getSelection();
            ArrayList<ILinkType> selectedLinkTypes = null;
            for (Object next : selection) {
                if (!(next instanceof IReference)) continue;
                ILinkType linkType = ((IReference)next).getLink().getLinkType();
                if (selectedLinkTypes == null) {
                    selectedLinkTypes = new ArrayList<ILinkType>();
                }
                if (selectedLinkTypes.contains(linkType)) continue;
                selectedLinkTypes.add(linkType);
            }
            if (selectedLinkTypes != null) {
                toolPanel.addEndpointActions(page, manager, selectedLinkTypes, inputProvider);
            }
        }
    }
}

