/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.editor.pages;

import com.ibm.team.apt.common.IPlanReferences;
import com.ibm.team.apt.ide.core.IResolvedIterationPlanRecord;
import com.ibm.team.apt.internal.ide.ui.editor.pages.Messages;
import com.ibm.team.apt.internal.ide.ui.editor.pages.PlanLinkPostActionListener;
import com.ibm.team.calm.foundation.client.internal.ResourceReference;
import com.ibm.team.calm.foundation.client.linking.CALMLinkingCache;
import com.ibm.team.calm.foundation.common.linking.CALMLinkTypeInformation;
import com.ibm.team.calm.foundation.common.linking.OSLCReference;
import com.ibm.team.calm.foundation.rcp.ui.linking.CALMResourcePickerDialog;
import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.foundation.common.URIReference;
import com.ibm.team.foundation.rcp.core.hyperlinks.ContextProvider;
import com.ibm.team.foundation.rcp.core.hyperlinks.Hyperlinks;
import com.ibm.team.foundation.rcp.core.hyperlinks.StandardContextProvider;
import com.ibm.team.links.common.ILink;
import com.ibm.team.links.common.IReference;
import com.ibm.team.links.common.IURIReference;
import com.ibm.team.links.common.factory.IReferenceFactory;
import com.ibm.team.links.common.registry.IEndPointDescriptor;
import com.ibm.team.links.common.registry.ILinkType;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.client.internal.util.ClientUtils;
import com.ibm.team.workitem.rcp.ui.WorkItemUI;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.IInputSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.texteditor.IUpdate;

public class PlanLinkActions {
    private IResolvedIterationPlanRecord fPlan;

    public PlanLinkActions(IResolvedIterationPlanRecord plan) {
        this.fPlan = plan;
    }

    public AddLinkAction getAddAction(IWorkbenchPage page, CALMLinkingCache calmLinkingCache, CALMLinkTypeInformation linkType) {
        return new AddLinkAction(page, calmLinkingCache, linkType, new PlanLinkPostActionListener[0]);
    }

    public OpenLinkAction getOpenAction(IInputSelectionProvider selectionProvider) {
        return new OpenLinkAction(selectionProvider, new PlanLinkPostActionListener[0]);
    }

    public DeleteLinkAction getDeleteAction(IInputSelectionProvider selectionProvider) {
        return new DeleteLinkAction(selectionProvider, new PlanLinkPostActionListener[0]);
    }

    public class AddLinkAction
    extends Action {
        private final IWorkbenchPage fPage;
        private final CALMLinkingCache fLinkCache;
        private final CALMLinkTypeInformation fLinkType;
        private final IEndPointDescriptor fTargetDescriptor;

        AddLinkAction(IWorkbenchPage page, CALMLinkingCache calmLinkingCache, CALMLinkTypeInformation linkType, PlanLinkPostActionListener ... listeners) {
            this.fPage = page;
            this.fLinkCache = calmLinkingCache;
            this.fLinkType = linkType;
            this.fTargetDescriptor = linkType.getItemLinkType().getTargetEndPointDescriptor();
            this.setText(this.getEmptySelectionOperationLabel(this.fTargetDescriptor));
            if (this.fTargetDescriptor != null && this.fTargetDescriptor.getIcon() != null) {
                this.setImageDescriptor(WorkItemUI.getImageDescriptor((URL)this.fTargetDescriptor.getIcon()));
            }
        }

        public void run() {
            this.addResourceReference();
            super.run();
        }

        private void addResourceReference() {
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    Collection references;
                    IWorkbenchWindow window = AddLinkAction.this.fPage.getWorkbenchWindow();
                    Collection serviceProviders = AddLinkAction.this.fLinkCache.getServiceProviders(AddLinkAction.this.fLinkType);
                    CALMResourcePickerDialog providerDlg = new CALMResourcePickerDialog(window.getShell(), (IRunnableContext)window, AddLinkAction.this.fLinkType, (IProjectAreaHandle)PlanLinkActions.this.fPlan.getProjectArea(), serviceProviders);
                    int result = providerDlg.open();
                    if (result == 0 && (references = providerDlg.getPickedReferences()) != null && !references.isEmpty()) {
                        IPlanReferences planReferences = PlanLinkActions.this.fPlan.getReferences();
                        for (OSLCReference reference : references) {
                            IURIReference newReference = IReferenceFactory.INSTANCE.createReferenceFromURI(reference.getResourceURI(), reference.getLabel());
                            boolean referenceExists = false;
                            for (IReference curOld : planReferences.getReferences(AddLinkAction.this.fLinkType.getItemLinkType())) {
                                if (!reference.getResourceURI().equals(curOld.createURI())) continue;
                                referenceExists = true;
                                break;
                            }
                            if (referenceExists) continue;
                            planReferences.addReference(AddLinkAction.this.fLinkType.getItemLinkType(), (IReference)newReference);
                        }
                    }
                }
            });
        }

        private String getEmptySelectionOperationLabel(IEndPointDescriptor linkType) {
            return NLS.bind((String)Messages.PlanLinks_ADD_OPERATION, (Object)linkType.getDisplayName(), (Object[])new Object[0]);
        }
    }

    public class DeleteLinkAction
    extends Action
    implements IUpdate {
        private final IInputSelectionProvider fInputProvider;

        public DeleteLinkAction(IInputSelectionProvider inputProvider, PlanLinkPostActionListener ... listeners) {
            this.fInputProvider = inputProvider;
            this.setText(Messages.PlanLinks_REMOVE);
            this.update();
        }

        public void update() {
            this.setEnabled(this.canRun());
        }

        private boolean canRun() {
            ISelection selection = this.fInputProvider.getSelection();
            if (selection.isEmpty()) {
                return false;
            }
            IResolvedIterationPlanRecord input = (IResolvedIterationPlanRecord)this.fInputProvider.getInput();
            if (!(selection instanceof IStructuredSelection) || input == null) {
                return false;
            }
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            for (Object object : structuredSelection) {
                if (!(object instanceof IReference)) {
                    return false;
                }
                ILinkType linkType = this.findReferenceType(object);
                if (linkType != null) continue;
                return false;
            }
            return true;
        }

        private ILinkType findReferenceType(Object element) {
            if (element instanceof ILinkType) {
                return (ILinkType)element;
            }
            if (element instanceof IReference) {
                return ((IReference)element).getLink().getLinkType();
            }
            return null;
        }

        public void run() {
            if (!this.canRun()) {
                return;
            }
            IStructuredSelection selection = (IStructuredSelection)this.fInputProvider.getSelection();
            IResolvedIterationPlanRecord plan = (IResolvedIterationPlanRecord)this.fInputProvider.getInput();
            for (Object next : selection) {
                if (!(next instanceof IReference)) continue;
                if (next instanceof ResourceReference) {
                    ILink removedLink = ((ResourceReference)next).getLink();
                    plan.getReferences().removeReference(removedLink.getLinkType(), removedLink.getTargetRef());
                    continue;
                }
                IReference reference = (IReference)next;
                plan.getReferences().removeReference(reference.getLink().getLinkType(), reference);
            }
            super.run();
        }
    }

    public class OpenLinkAction
    extends Action
    implements IUpdate {
        private IInputSelectionProvider fInputProvider;

        public OpenLinkAction(IInputSelectionProvider inputProvider, PlanLinkPostActionListener ... listeners) {
            this.fInputProvider = inputProvider;
            this.setText(Messages.PlanLinks_OPEN);
            this.update();
        }

        public void update() {
            this.setEnabled(this.canRun());
        }

        private boolean canRun() {
            ISelection selection = this.fInputProvider.getSelection();
            if (selection.isEmpty()) {
                return false;
            }
            IResolvedIterationPlanRecord input = (IResolvedIterationPlanRecord)this.fInputProvider.getInput();
            if (!(selection instanceof IStructuredSelection) || input == null) {
                return false;
            }
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            for (Object object : structuredSelection) {
                if (object instanceof IReference) continue;
                return false;
            }
            return true;
        }

        public void run() {
            if (!this.canRun()) {
                return;
            }
            IStructuredSelection selection = (IStructuredSelection)this.fInputProvider.getSelection();
            ArrayList<IReference> references = new ArrayList<IReference>();
            for (Object next : selection) {
                if (!(next instanceof IReference)) continue;
                references.add((IReference)next);
            }
            this.openReferences(((IResolvedIterationPlanRecord)this.fInputProvider.getInput()).getTeamRepository(), references);
            super.run();
        }

        private void openReferences(final ITeamRepository teamRepository, final List<IReference> references) {
            FoundationJob job = new FoundationJob(Messages.PlanLinks_OPENING_REFERENCES){

                protected IStatus runProtected(IProgressMonitor monitor) {
                    ArrayList<URI> uris = new ArrayList<URI>();
                    URI context = null;
                    for (IReference reference : references) {
                        URI uri;
                        if (context == null) {
                            context = Location.itemLocation((IItemHandle)reference.getLink(), (String)teamRepository.getRepositoryURI()).toAbsoluteUri();
                        }
                        if ((uri = ClientUtils.createURI((String)teamRepository.getRepositoryURI(), (IReference)reference)) == null) continue;
                        uris.add(uri);
                    }
                    return Hyperlinks.open(uris, (ContextProvider)new StandardContextProvider(null, new URIReference("context", "", context)), (IProgressMonitor)monitor);
                }
            };
            job.setUser(true);
            job.schedule();
        }
    }
}

