/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.editor.outliner;

import com.ibm.team.apt.internal.ide.ui.editor.outliner.IUsageStatistics;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UsageStatistics
implements IUsageStatistics {
    private static final Pattern PATTERN = Pattern.compile("(.*?)@(\\d+)\\|");
    private HashMap<String, Integer> fRegistry = new HashMap();

    public UsageStatistics(String value) {
        if (value != null) {
            this.load(value);
        }
    }

    private void load(String string) {
        Matcher matcher = PATTERN.matcher(string);
        while (matcher.find()) {
            String identifier = matcher.group(1);
            Integer value = Integer.parseInt(matcher.group(2));
            this.fRegistry.put(identifier, value);
        }
    }

    @Override
    public List<String> keys() {
        ArrayList<String> result = new ArrayList<String>(this.fRegistry.keySet());
        this.sort(result);
        return result;
    }

    @Override
    public void sort(List<String> list) {
        Comparator<String> comparator = new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return UsageStatistics.this.rank(o2) - UsageStatistics.this.rank(o1);
            }
        };
        Collections.sort(list, comparator);
    }

    @Override
    public int rank(String identifier) {
        Integer value = this.fRegistry.get(identifier);
        return value == null ? 0 : value;
    }

    @Override
    public void touch(String identifier) {
        this.fRegistry.put(identifier, this.rank(identifier) + 1);
    }

    @Override
    public void promote(String identifier) {
        this.fRegistry.put(identifier, this.max() + 1);
    }

    @Override
    public boolean remove(String identifier) {
        return this.fRegistry.remove(identifier) != null;
    }

    private int max() {
        int max = Integer.MIN_VALUE;
        for (Integer value : this.fRegistry.values()) {
            max = Math.max(value, max);
        }
        return max;
    }

    private int min() {
        int min = Integer.MAX_VALUE;
        for (Integer value : this.fRegistry.values()) {
            min = Math.min(value, min);
        }
        return min;
    }

    public String toString() {
        StringBuilder result = new StringBuilder(this.fRegistry.size() * 10);
        int min = this.min();
        for (Map.Entry<String, Integer> entry : this.fRegistry.entrySet()) {
            result.append(entry.getKey());
            result.append('@');
            result.append(entry.getValue() - min);
            result.append('|');
        }
        return result.toString();
    }
}

