/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.editor.outliner;

import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.ide.ui.common.PlanOutlineResources;
import com.ibm.team.apt.internal.ide.ui.common.gadgets.GroupGadget;
import com.ibm.team.apt.internal.ide.ui.common.model.EntryUtils;
import com.ibm.team.apt.internal.ide.ui.common.structure.TimeElement;
import com.ibm.team.apt.internal.ide.ui.common.structure.TimeSpanDefinition;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.Messages;
import com.ibm.team.apt.internal.ide.ui.util.GCState;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.ContentOutlineItem;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GLabel;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GTreeNode;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GTreeNodeContent;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.Insets;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.OutlineResources;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.Rectangles;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.rtc.foundation.api.ui.model.IViewEntry;
import com.ibm.team.rtc.foundation.api.ui.model.IViewModelReadFunction;
import com.ibm.team.rtc.foundation.api.ui.model.IViewModelReader;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class TimeGadget
extends GroupGadget {
    public TimeGadget(ContentOutlineItem item, IViewEntry<TimeElement> groupEntry, Image collapsed, Image expanded) {
        super(item, collapsed, expanded, 0x1000400);
        this.setContent(new NodeContent(this, groupEntry));
    }

    @Override
    protected Point arrangeContent(int x, int y, int hint, int hint2) {
        return super.arrangeContent(x, y - 1, hint, hint2);
    }

    @Override
    protected void paintBackground(GC gc, OutlineResources resources) {
        GCState state = GCState.save(gc, 264);
        try {
            PlanOutlineResources planResources = (PlanOutlineResources)resources;
            Rectangle rect = this.getTransformation().toViewPort(this.getBounds());
            gc.setBackground(planResources.getSubHeadingMain());
            gc.fillRectangle(rect);
            gc.setForeground(planResources.getSubHeadingStart());
            gc.drawLine(rect.x, rect.y, rect.x + rect.width, rect.y);
            gc.drawLine(rect.x, rect.y + rect.height - 2, rect.x + rect.width, rect.y + rect.height - 2);
            gc.setForeground(planResources.getSubHeadingEnd());
            gc.drawLine(rect.x, rect.y + rect.height - 1, rect.x + rect.width, rect.y + rect.height - 1);
        }
        finally {
            state.restore();
        }
    }

    private static class NodeContent
    extends GTreeNodeContent {
        GLabel fNameLabel;
        GLabel fStatusLabel;
        private Insets fInsets;
        private final TimeSpanDefinition fTimeElement;

        public NodeContent(GTreeNode parent, final IViewEntry<TimeElement> groupEntry) {
            super(parent);
            this.fTimeElement = ((TimeElement)groupEntry.getElement()).getTimeSpan();
            PlanOutlineResources planResources = (PlanOutlineResources)this.getOutlineResources();
            this.fNameLabel = new GLabel(this, this.fTimeElement.getLabel(), 64);
            this.fNameLabel.setColor(planResources.getGroupStatusColor());
            this.fNameLabel.setFont(planResources.getGroupStatusFont());
            this.fNameLabel.setReturnParentElement(true);
            int[] counts = (int[])groupEntry.getModel().readModel((IViewModelReadFunction)new IViewModelReadFunction<int[], RuntimeException>(){

                public int[] run(IViewModelReader readAccessor) throws RuntimeException {
                    int[] result = new int[2];
                    for (PlanItem planItem : EntryUtils.elementsOfType(readAccessor.getChildren(groupEntry), PlanItem.class)) {
                        int n = planItem.isResolved() ? 1 : 0;
                        result[n] = result[n] + 1;
                    }
                    return result;
                }
            });
            int openCount = counts[0];
            int closedCount = counts[1];
            String text = "";
            if (closedCount > 0 && openCount > 0) {
                text = NLS.bind((String)Messages.TimeGadget_DETAILS_CLOSED_OPEN, (Object)closedCount, (Object[])new Object[]{openCount});
            } else if (closedCount > 0) {
                text = NLS.bind((String)Messages.TimeGadget_DETAILS_CLOSED, (Object)closedCount, (Object[])new Object[0]);
            } else if (openCount > 0) {
                text = NLS.bind((String)Messages.TimeGadget_DETAILS_OPEN, (Object)openCount, (Object[])new Object[0]);
            }
            this.fStatusLabel = new GLabel(this, text, 64);
            this.fStatusLabel.setColor(planResources.getGroupStatusColor());
            this.fStatusLabel.setFont(planResources.getGroupStatusFont());
            this.fInsets = new Insets(2, 4, 2, 4);
        }

        @Override
        public int computeMinimalWidth() {
            return this.max(this.fNameLabel.computeMinimalWidth(), this.fStatusLabel.computeMinimalWidth());
        }

        @Override
        protected Point arrangeContent(int x, int y, int wHint, int hHint) {
            int tx = x;
            this.fNameLabel.layout(tx, y, -1, -1);
            this.fStatusLabel.layout(tx += this.fNameLabel.getWidth() + ((PlanOutlineResources)this.getOutlineResources()).getSpaceWidth() * 2, y, Math.max(-1, wHint - (tx - x)), -1);
            tx += this.fStatusLabel.getWidth();
            if (this.fStatusLabel.getHeight() < this.fNameLabel.getHeight()) {
                this.fStatusLabel.move(0, this.fNameLabel.getHeight() - this.fStatusLabel.getHeight() - (this.fNameLabel.getDescent() - this.fStatusLabel.getDescent()));
            }
            return new Point(this.max(wHint, this.fNameLabel.getWidth() + this.fStatusLabel.getWidth()), this.max(this.fNameLabel.getHeight(), this.fStatusLabel.getHeight()));
        }

        @Override
        public void paint(GC gc, OutlineResources resources) {
            super.paint(gc, resources);
            if (this.getOutlineResources().debugLayout) {
                Rectangle bounds = this.getTransformation().toViewPort(this.fBounds);
                gc.drawRectangle(bounds.x, bounds.y, bounds.width - 1, bounds.height - 1);
            }
        }

        public void relayout() {
            Rectangle oldBounds = Rectangles.create(this.getBounds());
            this.layout(oldBounds.x, oldBounds.y, oldBounds.width, -1);
            this.getOutlineItem().getOutline().redraw(this, false);
        }

        @Override
        public Insets getInsets() {
            return this.fInsets;
        }

        @Override
        public Object getElement() {
            return this.fTimeElement;
        }
    }
}

