/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.editor.outliner;

import com.ibm.team.apt.internal.ide.ui.common.PlanOutlineResources;
import com.ibm.team.apt.internal.ide.ui.common.model.EntryUtils;
import com.ibm.team.apt.internal.ide.ui.common.structure.ColumnDescription;
import com.ibm.team.apt.internal.ide.ui.common.structure.ColumnElement;
import com.ibm.team.apt.internal.ide.ui.common.structure.RowElement;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.IDropTargetOverride;
import com.ibm.team.apt.internal.ide.ui.util.GCState;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.ContentOutlineItem;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GTreeNode;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GTreeNodeContent;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.OutlineResources;
import com.ibm.team.rtc.foundation.api.ui.model.IViewEntry;
import java.util.List;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.ui.IWorkbenchPartSite;

public class RowGadget
extends GTreeNode<RowContent>
implements IDropTargetOverride {
    private ColumnDescription[] fColumns;
    private RowElement fElement;

    public RowGadget(ContentOutlineItem outlineItem, IViewEntry<RowElement> entry, IWorkbenchPartSite site) {
        super(outlineItem, 0);
        this.fElement = (RowElement)entry.getElement();
        this.fColumns = ((RowElement)entry.getElement()).getColumns();
        this.setContent(new RowContent(this, entry, site));
    }

    @Override
    public IViewEntry<?> computeOverride(int x, int y, List<IViewEntry<?>> childEntries) {
        Rectangle outlineBounds = this.getTransformation().toViewPort(this.getOutlineItem().getBounds());
        ColumnDescription columnDescription = ((RowContent)this.getContent()).getColumnDescription(x - outlineBounds.x);
        if (columnDescription != null) {
            for (IViewEntry<?> outlineEntry : childEntries) {
                ColumnElement columnElement = EntryUtils.element(outlineEntry, ColumnElement.class);
                if (columnElement == null || !columnDescription.equals(columnElement.getDescription())) continue;
                return outlineEntry;
            }
        }
        return null;
    }

    @Override
    public void paint(GC gc, OutlineResources resources) {
        super.paint(gc, resources);
        if (this.fElement.isHeader()) {
            return;
        }
        GCState state = GCState.save(gc, 256);
        try {
            gc.setForeground(resources.getSelectionBorderColor());
            Rectangle outlineBounds = this.getTransformation().toViewPort(this.getOutlineItem().getBounds());
            int y = outlineBounds.y + ((RowContent)this.getContent()).getInsets().bottom() - 1;
            gc.drawLine(outlineBounds.x, y, outlineBounds.x + outlineBounds.width, y);
            PlanOutlineResources planResources = (PlanOutlineResources)resources;
            gc.setForeground(planResources.getTableGridColor());
            int x = outlineBounds.width / this.fColumns.length - 1 + outlineBounds.x;
            int i = 0;
            while (i < this.fColumns.length - 1) {
                gc.drawLine(x, y + 1, x, y + outlineBounds.height - 1);
                x += outlineBounds.width / this.fColumns.length;
                ++i;
            }
        }
        finally {
            state.restore();
        }
    }

    @Override
    protected Point arrangeContent(int x, int y, int wHint, int hHint) {
        super.arrangeContent(x, y, wHint, hHint);
        return new Point(1, 0);
    }

    @Override
    public Rectangle getBounds() {
        return this.getOutlineItem().getBounds();
    }

    @Override
    protected Rectangle getContentBounds() {
        return super.getBounds();
    }

    @Override
    public Rectangle getSelectionBounds() {
        return this.getBounds();
    }

    private int computeMinimalWidthWithColumns() {
        return 200;
    }

    public class RowContent
    extends GTreeNodeContent {
        private ColumnDescription[] fColumns;
        private int fColumnWidth;

        public RowContent(RowGadget parent, IViewEntry<RowElement> entry, IWorkbenchPartSite site) {
            super(parent);
            this.fColumns = ((RowElement)entry.getElement()).getColumns();
        }

        public ColumnDescription getColumnDescription(int x) {
            int index = x / (this.fColumnWidth / this.fColumns.length);
            if (index >= this.fColumns.length) {
                return this.fColumns[this.fColumns.length - 1];
            }
            return this.fColumns[index];
        }

        @Override
        protected Point arrangeContent(int x, int y, int wHint, int hHint) {
            this.fColumnWidth = wHint == -1 ? this.computeMinimalWidth() : wHint;
            return new Point(this.fColumnWidth, 0);
        }

        @Override
        public int computeMinimalWidth() {
            return RowGadget.this.computeMinimalWidthWithColumns() * this.fColumns.length;
        }
    }
}

