/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.editor.outliner;

import com.ibm.team.apt.api.common.planning.IProgressInformation;
import com.ibm.team.apt.api.common.planning.IProgressLabelProvider;
import com.ibm.team.apt.internal.ide.ui.common.PlanOutlineResources;
import com.ibm.team.apt.internal.ide.ui.common.gadgets.GroupNodeContent;
import com.ibm.team.apt.internal.ide.ui.common.structure.GroupElement;
import com.ibm.team.apt.internal.ide.ui.progress.ProgressIDE;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GProgressBar;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GTreeNode;
import com.ibm.team.rtc.common.scriptengine.IScriptableProxy;
import com.ibm.team.rtc.foundation.api.ui.model.IViewEntry;
import org.eclipse.swt.graphics.Point;

public class ProgressGroupNodeContent
extends GroupNodeContent {
    private GProgressBar fProgressBar;

    public ProgressGroupNodeContent(GTreeNode parent, IViewEntry<? extends GroupElement> groupEntry) {
        super(parent, groupEntry, ((GroupElement)groupEntry.getElement()).getLabel());
        IProgressInformation progressInformation = this.getProgressInformation(groupEntry);
        IProgressLabelProvider labelProvider = ProgressIDE.newLabelProvider(((IScriptableProxy)progressInformation).getScriptEnvironment(), groupEntry);
        this.fProgressBar = new GProgressBar(this, labelProvider, progressInformation);
    }

    @Override
    public int computeMinimalWidth() {
        PlanOutlineResources resources = this.getPlanOutlineResources();
        return super.computeMinimalWidth() + 2 * resources.getSpaceWidth() + this.fProgressBar.computeMinimalWidth();
    }

    @Override
    protected Point arrangeContent(int x, int y, int wHint, int hHint) {
        Point parent = super.arrangeContent(x, y, wHint, hHint);
        PlanOutlineResources resources = this.getPlanOutlineResources();
        this.fProgressBar.layout(x, y, -1, -1);
        this.fProgressBar.move(wHint != -1 ? this.max(0, wHint - this.fProgressBar.getWidth()) : x + parent.x, 0);
        int barHeight = this.fProgressBar.getHeight();
        if (parent.y > barHeight) {
            int visualFrontHeight = barHeight - this.fProgressBar.computeTopSpacing();
            int delta = this.max(0, (parent.y - visualFrontHeight) / 2 - this.fProgressBar.computeTopSpacing());
            this.fProgressBar.move(0, delta);
        } else if (barHeight > parent.y) {
            this.fStatusLabel.move(0, barHeight - parent.y);
        }
        return new Point(this.max(wHint, this.max(this.fNameLabel.getWidth(), this.fStatusLabel.getWidth()) + 2 * resources.getSpaceWidth() + this.fProgressBar.getWidth()), this.max(hHint, parent.y, barHeight));
    }
}

