/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.editor.outliner;

import com.ibm.team.apt.internal.common.ProgressMode;
import com.ibm.team.apt.internal.common.plantype.IAttributeDefinitionDescriptor;
import com.ibm.team.apt.internal.common.plantype.IColorizeDescription;
import com.ibm.team.apt.internal.common.plantype.IColumnDescriptor;
import com.ibm.team.apt.internal.common.plantype.IFilterDescription;
import com.ibm.team.apt.internal.common.plantype.IGroupModeDescription;
import com.ibm.team.apt.internal.common.plantype.IPlanCheckDescription;
import com.ibm.team.apt.internal.common.plantype.IPlanModeDescription;
import com.ibm.team.apt.internal.common.plantype.ISortModeDescription;
import com.ibm.team.apt.internal.common.plantype.IViewModeDescription;
import com.ibm.team.apt.internal.ide.ui.common.IOutlineSettingsListener;
import com.ibm.team.apt.internal.ide.ui.common.OutlineSettingChangeEvent;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.IPlanOutlineSettings;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.PlanOutlineSettingChangeEvent;
import java.util.ArrayList;
import java.util.Arrays;

public class PlanOutlineSettingsListener
implements IOutlineSettingsListener {
    private final IPlanOutlineSettings fSettings;

    public PlanOutlineSettingsListener() {
        this(null);
    }

    public PlanOutlineSettingsListener(IPlanOutlineSettings settings) {
        this.fSettings = settings;
    }

    public void refresh(IPlanModeDescription newValue, IPlanModeDescription oldValue) {
        IColorizeDescription color;
        IColorizeDescription[] iColorizeDescriptionArray;
        ArrayList<IFilterDescription> addFilters = new ArrayList<IFilterDescription>();
        addFilters.addAll(Arrays.asList(newValue.getFilters()));
        if (oldValue != null) {
            ArrayList<IFilterDescription> removeFilters = new ArrayList<IFilterDescription>();
            removeFilters.addAll(Arrays.asList(oldValue.getFilters()));
            removeFilters.removeAll(addFilters);
            for (IFilterDescription filter : removeFilters) {
                this.handleFilterChanged(filter, false);
            }
        }
        for (IFilterDescription filter : addFilters) {
            this.handleFilterChanged(filter, true);
        }
        this.handleViewModeChanged(newValue.getViewMode());
        this.handleSortModeChanged(newValue.getSortMode());
        this.handleProgressModeChanged(newValue.getProgressMode());
        if (oldValue != null) {
            iColorizeDescriptionArray = oldValue.getColors();
            int n = iColorizeDescriptionArray.length;
            int n2 = 0;
            while (n2 < n) {
                color = iColorizeDescriptionArray[n2];
                this.colorizeConfigRemoved(color);
                ++n2;
            }
        }
        iColorizeDescriptionArray = newValue.getColors();
        int n = iColorizeDescriptionArray.length;
        int n3 = 0;
        while (n3 < n) {
            color = iColorizeDescriptionArray[n3];
            this.colorizeConfigAdded(color);
            ++n3;
        }
        if (this.fSettings != null) {
            this.showDetailsChanged(this.fSettings.getShowDetails());
        }
    }

    public void handleColumnsChanged(IAttributeDefinitionDescriptor[] columns) {
    }

    public void handleViewModeChanged(IViewModeDescription mode) {
    }

    public void handleGroupModeChanged(IGroupModeDescription mode) {
    }

    public void handleSortModeChanged(ISortModeDescription mode) {
    }

    public void handleFilterChanged(IFilterDescription filter, boolean added) {
    }

    public void handlePlanCheckChanged(IPlanCheckDescription planCheck, boolean added) {
    }

    public void colorizeEnablementChanged(IColorizeDescription config, boolean enabled) {
    }

    public void colorizeConfigAdded(IColorizeDescription config) {
    }

    public void colorizeConfigUpdated(IColorizeDescription config) {
    }

    public void colorizeConfigRemoved(IColorizeDescription config) {
    }

    public void handleProgressModeChanged(ProgressMode newValue) {
    }

    public void showDetailsChanged(boolean show) {
    }

    @Override
    public void settingChanged(OutlineSettingChangeEvent event) {
        switch ((PlanOutlineSettingChangeEvent.Property)event.getChangedProperty()) {
            case REFRESH: {
                this.refresh((IPlanModeDescription)event.getNewValue(), (IPlanModeDescription)event.getParameters()[0]);
                break;
            }
            case COLUMNS: {
                IColumnDescriptor[] newValue = (IColumnDescriptor[])event.getNewValue();
                IAttributeDefinitionDescriptor[] legancyNewValue = new IAttributeDefinitionDescriptor[newValue.length];
                int i = 0;
                while (i < legancyNewValue.length) {
                    legancyNewValue[i] = newValue[i].getAttribute();
                    ++i;
                }
                this.handleColumnsChanged(legancyNewValue);
                break;
            }
            case VIEW_MODE: {
                this.handleViewModeChanged((IViewModeDescription)event.getNewValue());
                break;
            }
            case GROUP_MODE: {
                this.handleGroupModeChanged((IGroupModeDescription)event.getNewValue());
                break;
            }
            case SORT_MODE: {
                this.handleSortModeChanged((ISortModeDescription)event.getNewValue());
                break;
            }
            case FILTER: {
                this.handleFilterChanged((IFilterDescription)event.getNewValue(), (Boolean)event.getParameters()[0]);
                break;
            }
            case PLANCHECK: {
                this.handlePlanCheckChanged((IPlanCheckDescription)event.getNewValue(), (Boolean)event.getParameters()[0]);
                break;
            }
            case COLORIZE_ADD: {
                this.colorizeConfigAdded((IColorizeDescription)event.getNewValue());
                break;
            }
            case COLORIZE_UPDATE: {
                this.colorizeConfigUpdated((IColorizeDescription)event.getNewValue());
                break;
            }
            case COLORIZE_REMOVE: {
                this.colorizeConfigRemoved((IColorizeDescription)event.getNewValue());
                break;
            }
            case COLORIZE_ENABLEMENT: {
                this.colorizeEnablementChanged((IColorizeDescription)event.getNewValue(), (Boolean)event.getParameters()[0]);
                break;
            }
            case SHOW_DETAILS: {
                this.showDetailsChanged((Boolean)event.getNewValue());
                break;
            }
            case OWNER_PROGRESS_MODE: {
                this.handleProgressModeChanged((ProgressMode)event.getNewValue());
            }
        }
    }
}

