/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.editor.outliner;

import com.ibm.team.apt.internal.client.PlanElement;
import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.client.ResolvedIterationPlan;
import com.ibm.team.apt.internal.ide.ui.common.GadgetFactory;
import com.ibm.team.apt.internal.ide.ui.common.PlanViewer;
import com.ibm.team.apt.internal.ide.ui.common.PlanViewerDragAdapter;
import com.ibm.team.apt.internal.ide.ui.common.PlanViewerDropAdapter;
import com.ibm.team.apt.internal.ide.ui.common.model.EntryUtils;
import com.ibm.team.apt.internal.ide.ui.common.structure.ColumnElement;
import com.ibm.team.apt.internal.ide.ui.common.structure.OwnerElement;
import com.ibm.team.apt.internal.ide.ui.common.structure.RowElement;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.IPlanOutlineSettings;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.IterationPlanViewModel;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.PlanEditorGadgetFactory;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.PlanItemGadget;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.PlanItemOutline;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.PlanItemOutlineItem;
import com.ibm.team.apt.internal.ide.ui.widgets.PlanElementSelectionTransfer;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.AbstractTextEditor;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GShell;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.Outline;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.OutlineItem;
import com.ibm.team.foundation.rcp.ui.dnd.URIReferenceTransfer;
import com.ibm.team.rtc.foundation.api.ui.model.IViewEntry;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPartSite;

public class PlanItemOutlineViewer
extends PlanViewer {
    private final IWorkbenchPartSite fSite;
    private boolean fIsFiringSelectionEvent = false;

    public PlanItemOutlineViewer(PlanItemOutline control, IWorkbenchPartSite site) {
        super((GadgetFactory)new PlanEditorGadgetFactory(site), control);
        this.setUseHashlookup(true);
        this.fSite = site;
        this.hookDragAndDrop();
    }

    @Override
    protected void inputChanged(Object input, Object oldInput) {
        super.inputChanged(input, oldInput);
        if (input instanceof ResolvedIterationPlan && this.getControl() instanceof PlanItemOutline) {
            ((PlanItemOutline)this.getControl()).setInput((ResolvedIterationPlan)input);
        }
    }

    public void refresh(Object element) {
        super.refresh(element);
        if (this.needsRelayout()) {
            this.getOutline().relayout();
        }
    }

    public void refresh(Object element, boolean updateLabels) {
        super.refresh(element, updateLabels);
        if (this.needsRelayout()) {
            this.getOutline().relayout();
        }
    }

    private boolean needsRelayout() {
        Object input = this.getInput();
        if (!(input instanceof IterationPlanViewModel)) {
            return false;
        }
        IPlanOutlineSettings settings = ((IterationPlanViewModel)input).getOutlineSettings();
        if (settings == null || !settings.isUsable()) {
            return false;
        }
        return settings.isTaskboardViewmode();
    }

    @Override
    public void resort(IViewEntry<?> entry) {
        this.storeEditor();
        super.resort(entry);
        this.adjustEditor();
    }

    protected void internalAdd(Widget widget, Object parentElementOrTreePath, Object[] childElements) {
        super.internalAdd(widget, parentElementOrTreePath, childElements);
        Object[] objectArray = childElements;
        int n = childElements.length;
        int n2 = 0;
        while (n2 < n) {
            Object childElement = objectArray[n2];
            if (childElement instanceof IViewEntry && (EntryUtils.isType((IViewEntry)childElement, ColumnElement.class) || EntryUtils.isType((IViewEntry)childElement, RowElement.class))) {
                this.expandToLevel(childElement, 1);
            }
            ++n2;
        }
    }

    protected void internalRefresh(Object element, boolean updateLabels) {
        Widget item;
        Object input;
        this.storeEditor();
        super.internalRefresh(element, updateLabels);
        Object object = input = element != null ? element : this.getRoot();
        if (input != null && ((item = this.findItem(input)) instanceof OutlineItem || item instanceof Outline)) {
            OutlineItem[] outlineItemArray = item instanceof OutlineItem ? ((OutlineItem)item).getItems() : ((Outline)item).getItems();
            int n = outlineItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                OutlineItem child = outlineItemArray[n2];
                IViewEntry childEntry = (IViewEntry)child.getData();
                if (EntryUtils.isType(childEntry, ColumnElement.class) || EntryUtils.isType(childEntry, RowElement.class)) {
                    this.expandToLevel(child.getData(), -1);
                }
                ++n2;
            }
        }
        this.adjustEditor();
    }

    protected void createChildren(Widget widget) {
        super.createChildren(widget);
        Item[] itemArray = this.getChildren(widget);
        int n = itemArray.length;
        int n2 = 0;
        while (n2 < n) {
            IViewEntry childEntry;
            Item child = itemArray[n2];
            if (child instanceof OutlineItem && (EntryUtils.isType(childEntry = (IViewEntry)((OutlineItem)child).getData(), ColumnElement.class) || EntryUtils.isType(childEntry, RowElement.class))) {
                this.expandToLevel(child.getData(), 1);
            }
            ++n2;
        }
    }

    @Override
    protected void setExpanded(Item item, boolean expand) {
        if (!(item instanceof OutlineItem)) {
            super.setExpanded(item, expand);
            return;
        }
        IViewEntry entry = (IViewEntry)((OutlineItem)item).getData();
        if ((EntryUtils.isType(entry, ColumnElement.class) || EntryUtils.isType(entry, RowElement.class)) && !expand) {
            return;
        }
        super.setExpanded(item, expand);
    }

    private void storeEditor() {
        PlanItemOutline planOutline = this.getPlanOutline();
        AbstractTextEditor editor = planOutline.getCurrentTextEditor();
        if (editor != null && editor.isActive()) {
            editor.storeData();
        }
    }

    private void adjustEditor() {
        ITreeContentProvider cp;
        PlanItemOutline planOutline = this.getPlanOutline();
        AbstractTextEditor editor = planOutline.getCurrentTextEditor();
        if (editor != null && editor.isActive()) {
            IViewEntry<?> entry = editor.getEntry();
            Widget widget = this.findItem(entry);
            if (widget != null) {
                if (widget instanceof PlanItemOutlineItem) {
                    planOutline.adjustTextEditor((PlanItemOutlineItem)widget);
                } else {
                    planOutline.cancelEditSession();
                }
            } else {
                planOutline.stopEditSession();
            }
        }
        if ((cp = (ITreeContentProvider)this.getContentProvider()) != null && cp.getElements(this.getInput()).length == 0) {
            this.getControl().redraw();
        }
    }

    protected void internalRemove(Object parent, Object[] elements) {
        this.stopEditSession(elements);
        super.internalRemove(parent, elements);
    }

    @Override
    protected void internalRemove(Object[] elementsOrPaths) {
        this.stopEditSession(elementsOrPaths);
        super.internalRemove(elementsOrPaths);
    }

    private PlanItemOutline getPlanOutline() {
        return (PlanItemOutline)this.getOutline();
    }

    protected Item newItem(Widget parent, int style, int index) {
        PlanItemOutlineItem result;
        if (parent instanceof Outline) {
            result = new PlanItemOutlineItem((PlanItemOutline)parent, style, index);
        } else {
            OutlineItem parentItem = (OutlineItem)parent;
            result = new PlanItemOutlineItem(parentItem, style, index);
            if (parentItem.isLayouted() && parentItem.getItemCount() == 1) {
                parentItem.getOutline().redraw(parentItem, false);
            }
        }
        return result;
    }

    protected void internalUpdate(Widget widget, Object element, String[] properties) {
        if (widget instanceof PlanItemOutlineItem) {
            boolean inEditMode = false;
            PlanItemOutline planOutline = this.getPlanOutline();
            PlanItemOutlineItem outlineItem = (PlanItemOutlineItem)widget;
            AbstractTextEditor editor = planOutline.getCurrentTextEditor();
            if (editor != null && editor.isActive()) {
                GShell content = outlineItem.getContent();
                inEditMode = content instanceof PlanItemGadget && editor.isOwner((PlanItemGadget)content);
            }
            super.internalUpdate(widget, element, properties);
            GShell newContent = outlineItem.getContent();
            if (inEditMode && newContent instanceof PlanItemGadget) {
                editor.transferOwnership((PlanItemGadget)newContent);
            }
        } else {
            super.internalUpdate(widget, element, properties);
        }
    }

    public boolean isExpandable(Object elementOrTreePath) {
        Object element;
        if (elementOrTreePath instanceof IViewEntry && ((element = ((IViewEntry)elementOrTreePath).getElement()) instanceof RowElement || element instanceof ColumnElement)) {
            return true;
        }
        if (!super.isExpandable(elementOrTreePath)) {
            return false;
        }
        Object[] filteredChildren = this.getFilteredChildren(elementOrTreePath);
        return filteredChildren.length > 0;
    }

    private void hookDragAndDrop() {
        DragSource dragSource = new DragSource((Control)this.getOutline(), 6);
        dragSource.setTransfer(new Transfer[]{LocalSelectionTransfer.getTransfer(), URIReferenceTransfer.getInstance()});
        dragSource.addDragListener((DragSourceListener)new PlanViewerDragAdapter(this){

            @Override
            protected Object convertToExternal(Object in) {
                if (in instanceof PlanItem && !((PlanItem)in).isProgressPlanItem()) {
                    return ((PlanItem)in).getWorkItemHandle();
                }
                if (in instanceof OwnerElement) {
                    return ((OwnerElement)in).getOwner();
                }
                return null;
            }
        });
        DropTarget dropTarget = new DropTarget((Control)this.getOutline(), 6);
        dropTarget.setTransfer(new Transfer[]{PlanElementSelectionTransfer.getTransfer(), LocalSelectionTransfer.getTransfer()});
        dropTarget.addDropListener((DropTargetListener)new PlanViewerDropAdapter(this, this.fSite));
    }

    protected void fireSelectionChanged(SelectionChangedEvent event) {
        try {
            this.fIsFiringSelectionEvent = true;
            super.fireSelectionChanged(event);
        }
        finally {
            this.fIsFiringSelectionEvent = false;
        }
    }

    public void setSelection(ISelection selection, boolean reveal) {
        if (!this.fIsFiringSelectionEvent) {
            super.setSelection(selection, reveal);
        }
    }

    public boolean startEditSession(IViewEntry<? extends PlanElement> element) {
        this.setSelection((ISelection)new StructuredSelection(element), true);
        OutlineItem item = this.getOutline().getLastSelectedItem();
        if (!this.equals(element, item.getData())) {
            return false;
        }
        GShell content = item.getContent();
        if (!(content instanceof PlanItemGadget)) {
            return false;
        }
        this.getOutline().startEditSession(((PlanItemGadget)content).getSummary());
        return true;
    }

    public void setTextEditorFullSelection() {
        this.getOutline().setTextEditorFullSelection();
    }

    public void stopEditSession() {
        PlanItemOutline planOutline = this.getPlanOutline();
        AbstractTextEditor editor = planOutline.getCurrentTextEditor();
        if (editor != null && editor.isActive()) {
            planOutline.stopEditSession();
        }
    }

    private void stopEditSession(Object[] elementsOrPaths) {
        PlanItemOutline planOutline = this.getPlanOutline();
        AbstractTextEditor editor = planOutline.getCurrentTextEditor();
        if (editor != null && editor.isActive() && this.contains(elementsOrPaths, editor.getEntry())) {
            planOutline.stopEditSession();
        }
    }

    private boolean contains(Object[] elementsOrPaths, IViewEntry<?> entry) {
        Object[] objectArray = elementsOrPaths;
        int n = elementsOrPaths.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object == entry) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void cutText() {
        StyledText textWidget = this.getTextWidget();
        if (textWidget == null) {
            return;
        }
        textWidget.cut();
    }

    public void copyText() {
        StyledText textWidget = this.getTextWidget();
        if (textWidget == null) {
            return;
        }
        textWidget.copy();
    }

    public void pasteText() {
        StyledText textWidget = this.getTextWidget();
        if (textWidget == null) {
            return;
        }
        textWidget.paste();
    }

    private StyledText getTextWidget() {
        AbstractTextEditor editor = this.getOutline().getCurrentTextEditor();
        if (editor == null || !editor.isActive()) {
            return null;
        }
        StyledText textWidget = editor.getControl();
        return textWidget != null && !textWidget.isDisposed() ? textWidget : null;
    }
}

