/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.editor.outliner;

import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.ide.ui.actions.LinkTypeColorizeAction;
import com.ibm.team.apt.internal.ide.ui.common.PlanOutlineResources;
import com.ibm.team.apt.internal.ide.ui.common.gadgets.AttributeDropDownAction;
import com.ibm.team.apt.internal.ide.ui.common.gadgets.GDuration;
import com.ibm.team.apt.internal.ide.ui.common.gadgets.GStatusLine;
import com.ibm.team.apt.internal.ide.ui.common.gadgets.GStatusLineItem;
import com.ibm.team.apt.internal.ide.ui.common.gadgets.PlanItemColumnFactory;
import com.ibm.team.apt.internal.ide.ui.common.structure.FieldTag;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.IColumnBasedGadget;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.IterationPlanItemNodeContent;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.Messages;
import com.ibm.team.apt.internal.ide.ui.util.GCState;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.CompositeGadget;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GButton;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GHTMLText;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GText;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.Gadget;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.OutlineResources;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.Rectangles;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.TextStyleRange;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.rtc.foundation.api.ui.model.IViewEntry;
import com.ibm.team.workitem.client.internal.WorkItemClient;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.IWorkItemType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class PlanItemNodeContent
extends IterationPlanItemNodeContent
implements IColumnBasedGadget {
    private GButton fImage;
    private GText fSummary;
    private GText fDescription;
    private GStatusLine fStatusLine;
    private GDuration fDurationItem;
    private int fSummaryColumnWidth;
    private final HashSet<String> fFields;
    private final String[] fFieldIds;
    private final IViewEntry<?> fEntry;

    public PlanItemNodeContent(CompositeGadget parent, PlanItem planItem, IViewEntry<?> outlineEntry, boolean markResolved, boolean isPlaceholder) {
        super(parent, planItem, isPlaceholder);
        this.fEntry = outlineEntry;
        PlanOutlineResources resources = this.getPlanOutlineResources();
        this.fImage = new GButton(this, resources.getWorkItemLabelProvider().getImage((Object)planItem.getWorkItem(false)), 1024);
        this.fImage.setAction((IAction)new ItemTypeDropDownAction(planItem));
        this.fSummary = new GText(this, resources.isSingleClickMode() ? 2048 : 0);
        this.fSummary.setColor(markResolved && !isPlaceholder ? resources.getItemCompletedColor() : null);
        this.fSummary.setText(planItem.getHTMLSummary().getPlainText());
        this.fSummary.setAlternateText(Messages.PlanItemNodeContent_EMPTY_SUMMARY_PLACEHOLDER);
        this.fSummary.setAlternateColor(resources.getNoContentColor());
        this.fSummary.setId("summary");
        this.fSummary.setFont(resources.getTextFonts().getNormalFont());
        this.fSummaryColumnWidth = -1;
        this.fDescription = new GHTMLText(this);
        this.fDescription.setTextStyleRanges(new TextStyleRange[]{new TextStyleRange(-1, Integer.MAX_VALUE, new TextStyle(null, markResolved ? resources.getItemCompletedColor() : null, null))});
        this.fDescription.setText(planItem.getHTMLDescription().getXMLText());
        this.fDescription.setAlternateText(Messages.PlanItemNodeContent_EMPTY_DESCRIPTION_PLACEHOLDER);
        this.fDescription.setAlternateColor(resources.getNoContentColor());
        this.fDescription.setId("description");
        this.fStatusLine = new GStatusLine(this);
        this.fFields = new HashSet();
        List fieldTag = outlineEntry.getTags(FieldTag.class);
        this.fFieldIds = new String[fieldTag.size()];
        Collections.sort(fieldTag, new Comparator<FieldTag>(){

            @Override
            public int compare(FieldTag o1, FieldTag o2) {
                return o1.getIndex() - o2.getIndex();
            }
        });
        boolean canEditStatus = !planItem.isProgressPlanItem();
        int index = 0;
        for (FieldTag field : fieldTag) {
            Gadget item = PlanItemColumnFactory.getInstance().createItem(field, planItem, outlineEntry, this.fStatusLine);
            if (item instanceof GStatusLineItem) {
                ((GStatusLineItem)item).setEnabled(canEditStatus);
            }
            String fieldId = (String)field.getValue();
            this.fFields.add(fieldId);
            this.fFieldIds[index] = (String)field.getValue();
            ++index;
        }
        if (markResolved) {
            this.fStatusLine.setColor(resources.getItemCompletedColor());
        }
    }

    @Override
    public boolean isLabelProperty(String property) {
        if (this.fFields.contains(property)) {
            return true;
        }
        return super.isLabelProperty(property);
    }

    private void setStatusLineWidths() {
        int[] hints = new int[this.fFieldIds.length];
        int i = 0;
        while (i < this.fFieldIds.length) {
            hints[i] = this.getOutline().getColumn(this.fFieldIds[i]).getWidth();
            ++i;
        }
        this.fStatusLine.setWidthHints(hints);
    }

    @Override
    public Object getElement() {
        return this.getPlanItem();
    }

    @Override
    public GText getSummary() {
        return this.fSummary;
    }

    @Override
    public GText getDescription() {
        return this.fDescription;
    }

    @Override
    public void paint(GC gc, OutlineResources resources) {
        if (!this.fEntry.getTags(LinkTypeColorizeAction.ReferenceTag.class).isEmpty()) {
            GCState state = GCState.save(gc, 266);
            Rectangle bounds = Rectangles.create(this.fSummary.getBounds());
            bounds = this.getOutline().getTransformation().toViewPort(bounds);
            int scale = 4;
            Rectangles.resize(bounds, scale, 0);
            Rectangles.move(bounds, -scale / 2, 0);
            boolean isSource = !this.fEntry.getTags(LinkTypeColorizeAction.ReferenceSourceTag.class).isEmpty();
            gc.setBackground(gc.getDevice().getSystemColor(isSource ? 5 : 7));
            gc.fillRoundRectangle(bounds.x, bounds.y, bounds.width, bounds.height, scale, scale);
            state.restore();
        }
        super.paint(gc, resources);
    }

    @Override
    public int computeMinimalWidth() {
        PlanOutlineResources resources = this.getPlanOutlineResources();
        int image = this.fImage.computeMinimalWidth();
        int summary = this.fSummary.computeMinimalWidth();
        int status = this.showDetails() ? this.fStatusLine.computeMinimalWidth() : 0;
        int description = this.showDescription() ? this.fDescription.computeMinimalWidth() : 0;
        int summaryWidth = image + resources.getIconSummarySpacing() + summary;
        return this.max(summaryWidth, status, description);
    }

    @Override
    protected Point arrangeContent(int x, int y, int wHint, int hHint) {
        int summaryMinWidth;
        int statusMinWidth;
        boolean showStatus = this.showDetails();
        boolean showDescription = this.showDescription();
        int descriptionWidth = 0;
        int statusWidth = 0;
        int startY = y;
        this.setStatusLineWidths();
        PlanOutlineResources resources = this.getPlanOutlineResources();
        this.fImage.layout(x, y, -1, -1);
        int tx = x + this.fImage.getWidth() + resources.getIconSummarySpacing();
        boolean showStatusOnNewLine = showStatus ? (statusMinWidth = this.fStatusLine.computeMinimalWidth() + resources.getStatusSpacing()) + (summaryMinWidth = this.fImage.computeMinimalWidth() + resources.getIconSummarySpacing() + this.fSummary.computeMinimalWidth()) > wHint : false;
        int tWidth = wHint;
        int maxSummaryWidth = wHint - (tx - x + (showStatus && !showStatusOnNewLine ? this.fStatusLine.computeMinimalWidth() + resources.getStatusSpacing() : 0) + resources.getStatusSpacing());
        int summaryX = tx;
        this.fSummary.layout(summaryX, y, maxSummaryWidth > 0 && this.fSummary.computeMaximumWidth() > maxSummaryWidth ? maxSummaryWidth : -1, -1);
        this.fSummary.setMaximumWidth(maxSummaryWidth);
        this.fSummaryColumnWidth = tx - x;
        tWidth -= this.getImageWhiteSpace();
        tx += this.getImageWhiteSpace();
        this.fStatusLine.setExclude(!showStatus);
        if (showStatus) {
            if (showStatusOnNewLine) {
                tx = x;
                y += this.max(this.fSummary.getHeight(), this.fImage.getHeight());
                y += 5;
            } else {
                tx += resources.getStatusSpacing();
                tx += this.fSummary.getWidth();
            }
            this.fStatusLine.layout(tx, y, tWidth, -1);
            statusWidth = this.fStatusLine.getWidth();
            this.fStatusLine.move(x + wHint - (tx + statusWidth + resources.getStatusSpacing()), 0);
        }
        y = showStatusOnNewLine ? (y += showStatus ? this.fStatusLine.getHeight() : 0) : (y += this.max(this.fImage.getHeight(), this.fSummary.getHeight(), showStatus ? this.fStatusLine.getHeight() : 0));
        if (this.fDurationItem != null) {
            this.fDurationItem.setEnabled(!this.getPlanItem().isProgressPlanItem());
        }
        this.fDescription.setExclude(!showDescription);
        if (showDescription) {
            int maxDescriptionWidth = wHint - (resources.getStatusSpacing() + (summaryX - x));
            this.fDescription.setMaximumWidth(maxDescriptionWidth);
            this.fDescription.layout(summaryX, y += resources.getDescriptionSpacing(), -1, -1);
            if (this.fDescription.getBounds().width > maxDescriptionWidth) {
                this.fDescription.layout(summaryX, y, maxDescriptionWidth, -1);
            }
            y += this.fDescription.getHeight();
            descriptionWidth = this.fDescription.getWidth();
        }
        int width = showStatusOnNewLine ? this.max(wHint, this.fImage.getWidth() + resources.getIconSummarySpacing() + this.fSummary.getWidth(), statusWidth, descriptionWidth) : this.max(wHint, this.fImage.getWidth() + resources.getIconSummarySpacing() + this.fSummary.getWidth() + statusWidth + resources.getStatusSpacing(), descriptionWidth);
        return new Point(width, y - startY);
    }

    @Override
    protected Point relayout(int x, int y, int deltaWidth, int deltaHeight, Gadget changedChild) {
        int width = this.getBounds().width;
        int height = this.getBounds().height;
        if (changedChild == this.fSummary) {
            height += deltaHeight;
            if (!this.fDescription.isExcluded()) {
                this.fDescription.move(0, deltaHeight);
            }
            if (!this.fStatusLine.isExcluded()) {
                this.fStatusLine.move(0, deltaHeight);
            }
        } else if (changedChild == this.fDescription) {
            height += deltaHeight;
            if (!this.fStatusLine.isExcluded()) {
                this.fStatusLine.move(0, deltaHeight);
            }
        }
        return new Point(width, height);
    }

    public Gadget findNextEditableGadget(Gadget child, Gadget owner, int direction) {
        if (child == this.fDescription && direction == 0x1000001) {
            return this.fSummary;
        }
        if (child == this.fSummary && direction == 0x1000002) {
            return this.fDescription;
        }
        return null;
    }

    protected boolean showDescription() {
        return this.getPlanItem().isDraftItem();
    }

    protected boolean showDetails() {
        return this.getPlanOutlineSettings().getShowDetails();
    }

    @Override
    public int getColumnCount() {
        return 1 + this.fStatusLine.getGadgetCount();
    }

    @Override
    public String getColumnId(int index) {
        if (index == 0) {
            return "xxx.internal.problem.summary";
        }
        return this.fFieldIds[index - 1];
    }

    @Override
    public int getColumnWidth(int index) {
        Assert.isLegal((index >= 0 && index < this.getColumnCount() ? 1 : 0) != 0);
        switch (index) {
            case 0: {
                return this.fSummaryColumnWidth == -1 ? this.fSummary.computeMinimalWidth() : this.fSummaryColumnWidth;
            }
        }
        return this.fStatusLine.getGadget(index - 1).computeMinimalWidth();
    }

    private class ItemTypeDropDownAction
    extends AttributeDropDownAction<IWorkItemType> {
        public ItemTypeDropDownAction(PlanItem planItem) {
            super(planItem, planItem.getPlan().getWorkItemTypeAttribute(), false);
        }

        @Override
        protected List<IWorkItemType> slowResolveValues(IProgressMonitor monitor) throws TeamRepositoryException {
            WorkItemClient wic;
            IProcessAreaHandle processArea;
            Object[] ids = null;
            if (this.getPlanItem().isNewItem() && (processArea = (wic = (WorkItemClient)PlanningClientPlugin.getWorkItemClient((ITeamRepository)this.getPlanItem().getPlan().getTeamRepository())).findProcessArea((IWorkItemHandle)this.getPlanItem().getWorkItem(false), (IProgressMonitor)new SubProgressMonitor(monitor, 1))) instanceof ITeamAreaHandle) {
                ids = wic.findCachedAvailableWorkItemTypes(processArea);
            }
            if (ids == null) {
                ids = this.getValueSet((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            wic = PlanningClientPlugin.getWorkItemClient((ITeamRepository)this.getPlanItem().getPlan().getTeamRepository());
            ArrayList<IWorkItemType> result = new ArrayList<IWorkItemType>(ids.length);
            monitor.beginTask("", ids.length);
            int i = 0;
            while (i < ids.length) {
                result.add(wic.findWorkItemType((IProjectAreaHandle)this.getPlanItem().getPlan().getProjectArea(), (String)ids[i], (IProgressMonitor)new SubProgressMonitor(monitor, 1)));
                ++i;
            }
            return result;
        }

        @Override
        protected void setValue(IWorkItemType type) {
            this.getPlanItem().setItemType(type.getIdentifier());
        }

        @Override
        protected MenuItem createMenuItem(Menu menu, IWorkItemType type) {
            MenuItem item = new MenuItem(menu, 0);
            item.setImage(PlanItemNodeContent.this.getPlanOutlineResources().getWorkItemTypeImage(type));
            item.setText(type.getDisplayName());
            return item;
        }

        @Override
        protected String getNotAvailableText() {
            return Messages.PlanItemNodeContent_NO_WORK_ITEM_TYPE_AVAILABLE;
        }
    }
}

