/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.editor.outliner;

import com.ibm.team.apt.internal.client.PlanElement;
import com.ibm.team.apt.internal.ide.ui.common.PlanOutlineResources;
import com.ibm.team.apt.internal.ide.ui.common.gadgets.GMarkerGadget;
import com.ibm.team.apt.internal.ide.ui.common.quickquery.ColorizeTag;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.IColumnBasedGadget;
import com.ibm.team.apt.internal.ide.ui.util.GCState;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.ContentOutlineItem;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GLink;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GShell;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GTreeNode;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GTreeNodeContent;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.OutlineItem;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.OutlineResources;
import java.util.List;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public abstract class PlanElementGadget<T extends PlanElement, C extends GTreeNodeContent>
extends GTreeNode<C>
implements IColumnBasedGadget {
    protected static final int PLACE_HOLDER = 4;
    private T fPlanElement;
    private Color fMarkerRowColor;

    public PlanElementGadget(ContentOutlineItem item, T planElement, List<ColorizeTag> colorTags, int style) {
        super(item, style);
        this.fPlanElement = planElement;
        this.fMarkerRowColor = null;
        ColorizeTag highestPriorityTag = null;
        for (ColorizeTag colorTag : colorTags) {
            if (highestPriorityTag != null && highestPriorityTag.getPriority() <= colorTag.getPriority()) continue;
            highestPriorityTag = colorTag;
        }
        if (highestPriorityTag != null) {
            LocalResourceManager resourceManager = this.getOutlineResources().getResourceManager();
            this.fMarkerRowColor = resourceManager.createColor(highestPriorityTag.getColor());
        }
    }

    protected int getMarkerColumnWidth() {
        return this.getOutline().getColumn("xxx.internal.problem.marker").getWidth();
    }

    protected int getIdColumnWidth() {
        return this.getOutline().getColumn("xxx.internal.problem.id").getWidth();
    }

    public T getPlanElement() {
        return this.fPlanElement;
    }

    @Override
    protected Point arrangeContent(int x, int y, int wHint, int hHint) {
        int markerColumn = this.getMarkerColumnWidth();
        int idColumn = this.getIdColumnWidth();
        Point size = super.arrangeContent(x + markerColumn, y, wHint - (markerColumn + idColumn), hHint);
        size.x += markerColumn + idColumn;
        return size;
    }

    @Override
    public void paint(GC gc, OutlineResources resources) {
        int markerColumn = this.getMarkerColumnWidth();
        PlanOutlineResources planResources = (PlanOutlineResources)resources;
        Rectangle rect = this.getTransformation().toViewPort(this.getBounds());
        int y = rect.y + rect.height - 1;
        int idOffset = this.getIdColumnWidth();
        GCState state = GCState.save(gc, 2314);
        gc.setBackground(planResources.getMarkerIdColumnColor());
        gc.fillRectangle(rect.x, rect.y, markerColumn, rect.height);
        gc.fillRectangle(rect.x + rect.width - idOffset, rect.y, idOffset, rect.height);
        if (this.fMarkerRowColor != null) {
            gc.setBackground(this.fMarkerRowColor);
            gc.setAlpha(192);
            gc.fillRectangle(rect.x, rect.y, markerColumn - 1, rect.height - 1);
            if ((this.getSelectionMode() & 1) != 1) {
                gc.setAlpha(52);
                gc.fillRectangle(rect.x + markerColumn, rect.y, rect.width - markerColumn - 1, rect.height - 1);
            }
        }
        gc.setForeground(planResources.getTableGridColor());
        gc.setLineAttributes(planResources.getTableGridStyle());
        if (this.nextIsPlanElementGadget()) {
            gc.drawLine(rect.x, y, rect.x + rect.width, y);
        }
        gc.drawLine(rect.x + markerColumn, rect.y, rect.x + markerColumn, rect.y + rect.height);
        gc.drawLine(rect.x + rect.width - (idOffset + 1), rect.y, rect.x + rect.width - (idOffset + 1), rect.y + rect.height);
        state.restore();
        super.paint(gc, resources);
    }

    protected boolean nextIsPlanElementGadget() {
        OutlineItem item = this.getOutlineItem();
        OutlineItem nextVisibleItem = this.getOutline().getNextVisibleItem(item);
        if (nextVisibleItem == null) {
            return true;
        }
        if (!(nextVisibleItem instanceof ContentOutlineItem)) {
            return false;
        }
        GShell content = ((ContentOutlineItem)nextVisibleItem).getContent();
        return content instanceof PlanElementGadget;
    }

    protected PlanOutlineResources getPlanOutlineResources() {
        return (PlanOutlineResources)this.getOutlineResources();
    }

    public abstract GMarkerGadget getMarkerGadget();

    public abstract GLink getLink();

    @Override
    public int getColumnCount() {
        return 1 + ((IColumnBasedGadget)this.getContent()).getColumnCount() + 1;
    }

    @Override
    public String getColumnId(int index) {
        if (index == 0) {
            return "xxx.internal.problem.marker";
        }
        if (index == this.getColumnCount() - 1) {
            return "xxx.internal.problem.id";
        }
        return ((IColumnBasedGadget)this.getContent()).getColumnId(index - 1);
    }

    @Override
    public int getColumnWidth(int index) {
        int count = this.getColumnCount();
        if (index == 0) {
            return 16;
        }
        if (index >= count - 1) {
            return this.getLink() != null ? 2 * this.getPlanOutlineResources().getIdSpacing() + this.getLink().computeMinimalWidth() : this.getIdColumnWidth();
        }
        return ((IColumnBasedGadget)this.getContent()).getColumnWidth(index - 1);
    }
}

