/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.editor.outliner;

import com.ibm.team.apt.internal.client.ResolvedPlan;
import com.ibm.team.apt.internal.ide.ui.common.MessageElement;
import com.ibm.team.apt.internal.ide.ui.common.PlanOutlineResources;
import com.ibm.team.apt.internal.ide.ui.common.structure.ItemMovePolicy;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.Messages;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.PlanItemOutline;
import com.ibm.team.apt.internal.ide.ui.util.ExceptionHandler;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.ContentOutlineItem;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GLabel;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GLink;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GTreeNode;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GTreeNodeContent;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.Insets;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.OutlineResources;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.Rectangles;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.rtc.foundation.api.ui.model.IViewEntry;
import com.ibm.team.rtc.foundation.api.ui.model.IViewModel;
import com.ibm.team.rtc.foundation.api.ui.model.IViewModelReadFunction;
import com.ibm.team.rtc.foundation.api.ui.model.IViewModelReader;
import com.ibm.team.workitem.common.model.IWorkItemType;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.ui.PlatformUI;

public class PlanEditorMessageGadget
extends GTreeNode<GTreeNodeContent> {
    public PlanEditorMessageGadget(ContentOutlineItem item, IViewEntry<MessageElement> messageEntry) {
        super(item, 0);
        this.setContent(new PlanEditorMessageContent(this, messageEntry));
    }

    @Override
    protected void paintSelection(GC gc, OutlineResources resources) {
    }

    public class PlanEditorMessageContent
    extends GTreeNodeContent {
        private final MessageElement fMessage;
        GLabel fMessageLabel;
        private Insets fInsets;

        public PlanEditorMessageContent(GTreeNode parent, final IViewEntry<MessageElement> messageEntry) {
            super(parent);
            this.fMessage = (MessageElement)messageEntry.getElement();
            PlanOutlineResources resources = (PlanOutlineResources)this.getOutlineResources();
            if ((this.fMessage.getOptions() & MessageElement.CREATE_LINK) != 0) {
                final ResolvedPlan plan = (ResolvedPlan)messageEntry.getModel().getInput();
                final ItemMovePolicy itemMovePolicy = ((PlanItemOutline)this.getOutline()).getSettings().getItemMovePolicy();
                this.fMessageLabel = new GLink(this, this.fMessage.getMessage(), 64);
                ((GLink)this.fMessageLabel).setAction((IAction)new Action(){

                    public void run() {
                        IViewEntry rootEntry = (IViewEntry)messageEntry.getModel().readModel(new IViewModelReadFunction<IViewEntry<?>, RuntimeException>(){

                            public IViewEntry<?> run(IViewModelReader readAccessor) throws RuntimeException {
                                return readAccessor.getRootEntry(IViewModel.Domain.Content);
                            }
                        });
                        IWorkItemType workItemType = plan.getDefaultWorkItemType();
                        if (workItemType != null) {
                            try {
                                itemMovePolicy.addItemToGroup(rootEntry, workItemType, (IRunnableContext)PlatformUI.getWorkbench().getProgressService());
                            }
                            catch (TeamRepositoryException e) {
                                ExceptionHandler.handle(e, PlanEditorMessageContent.this.getOutline().getShell(), Messages.PlanEditorMessageGadget_LABEL, Messages.PlanEditorMessageGadget_FAILED_MESSAGE);
                            }
                        }
                    }
                });
            } else {
                this.fMessageLabel = new GLabel(this, this.fMessage.getMessage(), 64);
                this.fMessageLabel.setColor(resources.getItemCompletedColor());
            }
            this.fInsets = new Insets(2, 4, 2, 4);
        }

        @Override
        public int computeMinimalWidth() {
            return this.fMessageLabel.computeMinimalWidth();
        }

        @Override
        protected Point arrangeContent(int x, int y, int wHint, int hHint) {
            this.fMessageLabel.layout(x, y, -1, -1);
            if (this.fMessageLabel.getWidth() < wHint) {
                this.fMessageLabel.move((wHint - this.fMessageLabel.getWidth()) / 2, 0);
            }
            return new Point(this.max(wHint, this.fMessageLabel.getWidth()), this.fMessageLabel.getHeight());
        }

        public void relayout() {
            Rectangle oldBounds = Rectangles.create(this.getBounds());
            this.layout(oldBounds.x, oldBounds.y, oldBounds.width, -1);
            this.getOutlineItem().getOutline().redraw(this, false);
        }

        @Override
        public Insets getInsets() {
            return this.fInsets;
        }

        @Override
        public Object getElement() {
            return this.fMessage;
        }
    }
}

