/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.editor.outliner;

import com.ibm.team.apt.api.common.planning.IProgressInformation;
import com.ibm.team.apt.internal.client.ILoadListener;
import com.ibm.team.apt.internal.client.IterationPlanSequenceManager;
import com.ibm.team.apt.internal.client.ResolvedIterationPlan;
import com.ibm.team.apt.internal.client.teamload.LoadInformation;
import com.ibm.team.apt.internal.client.teamload.LoadItem;
import com.ibm.team.apt.internal.common.Iterations;
import com.ibm.team.apt.internal.common.ProgressMode;
import com.ibm.team.apt.internal.ide.ui.common.PlanOutlineResources;
import com.ibm.team.apt.internal.ide.ui.common.PlanViewModel;
import com.ibm.team.apt.internal.ide.ui.common.gadgets.GroupGadget;
import com.ibm.team.apt.internal.ide.ui.common.gadgets.GroupNodeContent;
import com.ibm.team.apt.internal.ide.ui.common.structure.ColumnDescription;
import com.ibm.team.apt.internal.ide.ui.common.structure.OwnerElement;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.IPlanOutlineSettings;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.PlanItemOutline;
import com.ibm.team.apt.internal.ide.ui.progress.ProgressIDE;
import com.ibm.team.apt.internal.ide.ui.util.GCState;
import com.ibm.team.apt.internal.ide.ui.util.UI;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.BarGadget;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.CompositeGadget;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.ContentOutlineItem;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GContributorPhoto;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GDeferredImage;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GLoadBar;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GProgressBar;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GTreeNode;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.Gadget;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.Outline;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.OutlineResources;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IIterationHandle;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.rtc.common.scriptengine.IScriptableProxy;
import com.ibm.team.rtc.foundation.api.ui.model.IViewEntry;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;

public class OwnerGadget
extends GroupGadget {
    private ColumnDescription[] fColumns;

    public OwnerGadget(ContentOutlineItem item, IViewEntry<OwnerElement> groupEntry, Image collapsed, Image expanded) {
        super(item, collapsed, expanded, 0x1000000);
        this.setContent(new NodeContent(this, groupEntry));
    }

    public IContributor getOwner() {
        return (IContributor)this.getElement();
    }

    public GDeferredImage getImage() {
        return ((NodeContent)this.getContent()).fImage;
    }

    @Override
    protected void arrangeExpandButton() {
        if ((this.fStyle & 0x1000000) != 0) {
            int delta = this.max(0, ((Gadget)this.getContent()).getHeight() - this.getHeaderHight() - this.getExpandButton().getHeight()) / 2;
            this.getExpandButton().move(0, delta);
        }
    }

    @Override
    public Rectangle getSelectionBounds() {
        if (!this.isHeaderVisible()) {
            return super.getSelectionBounds();
        }
        Rectangle bounds = this.getBounds();
        return new Rectangle(bounds.x, bounds.y, bounds.width, bounds.height - this.getHeaderHight());
    }

    @Override
    protected void paintBackground(GC gc, OutlineResources resources) {
        GCState state = GCState.save(gc, 264);
        try {
            PlanOutlineResources planResources = (PlanOutlineResources)resources;
            Rectangle rect = this.getTransformation().toViewPort(this.getBounds());
            gc.setForeground(planResources.getGroupStroke1Color());
            gc.drawLine(rect.x, rect.y, rect.x + rect.width, rect.y);
            gc.setForeground(planResources.getGroupHighlightColor());
            gc.drawLine(rect.x, rect.y + 1, rect.x + rect.width, rect.y + 1);
            gc.setForeground(planResources.getGroupGradientStartColor());
            gc.setBackground(planResources.getGroupGradientEndColor());
            gc.fillGradientRectangle(rect.x, rect.y + 2, rect.width, rect.height - 5 - this.getHeaderHight(), true);
            int posy = rect.y + rect.height - 3 - this.getHeaderHight();
            gc.setForeground(planResources.getGroupHighlightColor());
            gc.drawLine(rect.x, posy, rect.x + rect.width, posy);
            gc.setForeground(planResources.getGroupStroke2Color());
            gc.drawLine(rect.x, ++posy, rect.x + rect.width, posy);
            gc.setForeground(planResources.getGroupStroke3Color());
            gc.drawLine(rect.x, ++posy, rect.x + rect.width, posy);
        }
        finally {
            state.restore();
        }
    }

    private boolean isHeaderVisible() {
        return this.fColumns != null && this.getOutlineItem().getExpanded();
    }

    private int getHeaderHight() {
        return ((NodeContent)this.getContent()).getColumnHeaderHeight();
    }

    private static class NodeContent
    extends GroupNodeContent {
        private final ILoadListener fListener = new ILoadListener(){

            public void loadItemChanged(LoadItem item) {
                Outline outline = this.getOutline();
                if (outline != null) {
                    UI.asyncExec((Control)outline, new Runnable(){

                        @Override
                        public void run() {
                            if (fBarGadget.isDisposed()) {
                                return;
                            }
                            fBarGadget.refresh();
                        }
                    });
                }
            }
        };
        private IContributor fOwner;
        private GDeferredImage fImage;
        private BarGadget fBarGadget;
        private LoadItem fLoadItem;
        private int fHeaderHeight;

        public NodeContent(GTreeNode parent, IViewEntry<OwnerElement> groupEntry) {
            super(parent, groupEntry, parent.getOutlineResources().getStandardLabelProvider().getText((Object)((OwnerElement)groupEntry.getElement()).getOwner()));
            LoadItem item;
            LoadInformation information;
            this.fOwner = ((OwnerElement)groupEntry.getElement()).getOwner();
            PlanOutlineResources resources = (PlanOutlineResources)this.getOutlineResources();
            this.fImage = new GContributorPhoto((CompositeGadget)this, (IContributorHandle)this.fOwner, resources.getOwnerImageFuture(parent.getOutline().getDisplay(), this.fOwner), resources);
            this.fImage.setReturnParentElement(true);
            this.fStatusLabel.setFont(resources.getGroupStatusFont());
            this.fLoadItem = null;
            ResolvedIterationPlan input = (ResolvedIterationPlan)((PlanViewModel)groupEntry.getModel()).getInput();
            IIteration iteration = input.getInterval();
            if (iteration != null && (information = input.getLoadInformation((IIterationHandle)iteration)) != null && (item = information.getLoadItem((IContributorHandle)this.fOwner)) != null) {
                this.fLoadItem = item;
            }
            if (this.getSettings().getProgressMode() == ProgressMode.LOAD) {
                if (this.fLoadItem != null) {
                    this.fLoadItem.getLoadInformation().addTeamLoadListener(this.fListener);
                    this.fBarGadget = new GLoadBar(this, this.fLoadItem);
                    this.fBarGadget.setReturnParentElement(true);
                }
            } else if (this.getSettings().getProgressMode() == ProgressMode.PROGRESS) {
                IterationPlanSequenceManager itemSequenceManager;
                IProgressInformation progressInformation = this.getProgressInformation(groupEntry);
                if (iteration != null && Iterations.hasDates((IIteration)iteration) && (itemSequenceManager = input.getItemSequenceManager((IContributorHandle)this.fOwner)) != null) {
                    long workTime = itemSequenceManager.calculateWorkTime(iteration.getStartDate(), iteration.getEndDate());
                    long remainingWorkTime = itemSequenceManager.calculateRemainingWorkTime(iteration.getEndDate());
                    progressInformation.deltaRealTimeDone(Math.max(0L, workTime - remainingWorkTime));
                    progressInformation.deltaRealTimeLeft(remainingWorkTime);
                }
                this.fBarGadget = new GProgressBar(this, ProgressIDE.newLabelProvider(((IScriptableProxy)progressInformation).getScriptEnvironment(), groupEntry), progressInformation);
                this.fBarGadget.setReturnParentElement(true);
            }
        }

        @Override
        public void dispose() {
            if (this.fLoadItem != null) {
                this.fLoadItem.getLoadInformation().removeTeamLoadListener(this.fListener);
            }
            super.dispose();
        }

        @Override
        public Object getElement() {
            return this.fOwner;
        }

        @Override
        public int computeMinimalWidth() {
            PlanOutlineResources resources = this.getPlanOutlineResources();
            return 32 + resources.getIconSummarySpacing() + super.computeMinimalWidth() + (this.fBarGadget != null ? 2 * resources.getSpaceWidth() + this.fBarGadget.computeMinimalWidth() : 0);
        }

        @Override
        protected Point arrangeContent(int x, int y, int wHint, int hHint) {
            int height;
            int width;
            Point parent = super.arrangeContent(x, y, wHint, hHint);
            this.fImage.layout(x, y, 32, 32);
            int imageIndent = this.fImage.getWidth() + ((PlanOutlineResources)this.getOutlineResources()).getIconSummarySpacing();
            this.fNameLabel.move(imageIndent, 0);
            this.fStatusLabel.move(imageIndent, 0);
            int frontHeight = parent.y;
            if (parent.y < this.fImage.getHeight()) {
                this.fStatusLabel.move(0, this.fImage.getHeight() - parent.y);
                frontHeight = this.fImage.getHeight();
            } else if (this.fImage.getHeight() < parent.y) {
                this.fImage.move(0, (parent.y - this.fImage.getHeight()) / 2);
            }
            int frontWidth = imageIndent + this.max(this.fNameLabel.getWidth(), this.fStatusLabel.getWidth());
            if (this.fBarGadget != null) {
                PlanOutlineResources resources = this.getPlanOutlineResources();
                this.fBarGadget.layout(x, y, -1, -1);
                this.fBarGadget.move(wHint != -1 ? this.max(0, wHint - this.fBarGadget.getWidth()) : x + parent.x, 0);
                int barHeight = this.fBarGadget.getHeight();
                if (frontHeight > barHeight) {
                    int visualFrontHeight = barHeight - this.fBarGadget.computeTopSpacing();
                    int delta = this.max(0, (frontHeight - visualFrontHeight) / 2 - this.fBarGadget.computeTopSpacing());
                    this.fBarGadget.move(0, delta);
                } else if (barHeight > frontHeight) {
                    this.fImage.move(0, (barHeight - frontHeight) / 2);
                    this.fStatusLabel.move(0, barHeight - frontHeight);
                }
                width = this.max(wHint, frontWidth + 2 * resources.getSpaceWidth() + this.fBarGadget.getWidth());
                height = this.max(hHint, frontHeight, barHeight);
            } else {
                width = this.max(wHint, frontWidth);
                height = this.max(hHint, frontHeight);
            }
            return new Point(width, height);
        }

        public int getColumnHeaderHeight() {
            return this.fHeaderHeight;
        }

        private IPlanOutlineSettings getSettings() {
            return ((PlanItemOutline)this.getOutline()).getSettings();
        }
    }
}

