/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.editor.outliner;

import com.ibm.team.apt.internal.common.plantype.IFilterDescription;
import com.ibm.team.apt.internal.ide.ui.common.IOutlineSettingsListener;
import com.ibm.team.apt.internal.ide.ui.common.model.EntryFilter;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.IPlanOutlineSettings;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.OutlineFilterDescriptor;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.PlanOutlineSettingsListener;
import com.ibm.team.rtc.foundation.api.ui.model.IViewEntry;
import com.ibm.team.rtc.foundation.api.ui.model.IViewModelReader;
import java.util.ArrayList;
import java.util.List;

public class OutlineViewerFilter
extends EntryFilter {
    private List<OutlineFilterDescriptor> fActiveFilters;
    private final IPlanOutlineSettings fSettings;
    private final IOutlineSettingsListener fSettingsListener = new PlanOutlineSettingsListener(){

        @Override
        public void handleFilterChanged(IFilterDescription filter, boolean added) {
        }
    };

    public OutlineViewerFilter(IPlanOutlineSettings planOutlineSettings) {
        this.fActiveFilters = new ArrayList<OutlineFilterDescriptor>();
        this.fSettings = planOutlineSettings;
        this.fSettings.addSettingsChangeListener(this.fSettingsListener);
    }

    public void dispose() {
        this.fSettings.removeSettingsChangeListener(this.fSettingsListener);
    }

    @Override
    public boolean isFilterProperty(IViewEntry<?> entry, String property) {
        int i = 0;
        while (i < this.fActiveFilters.size()) {
            OutlineFilterDescriptor filter = this.fActiveFilters.get(i);
            if (filter.isFilterProperty(entry, property)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean select(IViewEntry<?> entry, IViewModelReader readAccessor) {
        boolean isTagSelected = true;
        for (OutlineFilterDescriptor filter : this.fActiveFilters) {
            if (!filter.isFilterType(OutlineFilterDescriptor.FilterType.TAGS)) continue;
            isTagSelected = false;
            break;
        }
        int i = 0;
        while (!isTagSelected && i < this.fActiveFilters.size()) {
            OutlineFilterDescriptor filter = this.fActiveFilters.get(i);
            if (filter.isFilterType(OutlineFilterDescriptor.FilterType.TAGS)) {
                isTagSelected = filter.select(entry, readAccessor);
            }
            ++i;
        }
        if (isTagSelected) {
            OutlineFilterDescriptor filter;
            boolean filtersPassed = true;
            int i2 = 0;
            while (filtersPassed && i2 < this.fActiveFilters.size()) {
                filter = this.fActiveFilters.get(i2);
                if (filter.isFilterType(OutlineFilterDescriptor.FilterType.REGULAR) && !filter.isFilterType(OutlineFilterDescriptor.FilterType.POST)) {
                    filtersPassed &= filter.select(entry, readAccessor);
                }
                ++i2;
            }
            i2 = 0;
            while (filtersPassed && i2 < this.fActiveFilters.size()) {
                filter = this.fActiveFilters.get(i2);
                if (filter.isFilterType(OutlineFilterDescriptor.FilterType.POST)) {
                    filtersPassed &= filter.select(entry, readAccessor);
                }
                ++i2;
            }
            return filtersPassed;
        }
        return false;
    }
}

