/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.editor.outliner;

import com.ibm.icu.text.MessageFormat;
import com.ibm.team.apt.internal.client.OutOfOfficeItem;
import com.ibm.team.apt.internal.ide.ui.common.PlanOutlineResources;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.IColumnBasedGadget;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.IPlanOutlineSettings;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.Messages;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.OutOfOfficeGadget;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.PlanItemOutline;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GImage;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GText;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GTreeNodeContent;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.TextStyleRange;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.TextStyle;

public class OutOfOfficeNodeContent
extends GTreeNodeContent
implements IColumnBasedGadget {
    private OutOfOfficeItem fAbsence;
    private GImage fTypeImage;
    private GText fSummary;
    private GText fDetails;

    public OutOfOfficeNodeContent(OutOfOfficeGadget parent, OutOfOfficeItem absence) {
        super(parent);
        this.fAbsence = absence;
        PlanOutlineResources resources = this.getOutlineResources();
        this.fTypeImage = new GImage(this, resources.getOutOfOfficeImage());
        Color foreground = this.fAbsence.isResolved() ? resources.getItemCompletedColor() : resources.getSummaryColor();
        Font summaryFont = resources.getTextFonts().getNormalFont();
        String summary = absence.getHTMLSummary().getPlainText();
        if (summary.trim().length() == 0) {
            summary = Messages.OutOfOfficeNodeContent_SUMMARY;
        }
        this.fSummary = new GText(this, 0);
        this.fSummary.setTextStyleRanges(new TextStyleRange[]{new TextStyleRange(0, summary.length(), new TextStyle(summaryFont, foreground, null))});
        this.fSummary.setText(summary);
        String absenceDetails = MessageFormat.format((String)Messages.OutOfOfficeNodeContent_DETAILS, (Object[])new Object[]{this.fAbsence.getStart(), this.fAbsence.getEnd()});
        this.fDetails = new GText(this, 0);
        this.fDetails.setTextStyleRanges(new TextStyleRange[]{new TextStyleRange(0, absenceDetails.length(), new TextStyle(null, foreground, null))});
        this.fDetails.setText(absenceDetails.toString());
    }

    @Override
    public Object getElement() {
        return this.fAbsence;
    }

    @Override
    public int computeMinimalWidth() {
        PlanOutlineResources resources = this.getOutlineResources();
        int image = this.fTypeImage.computeMinimalWidth();
        int summary = this.fSummary.computeMinimalWidth();
        int details = this.showDetails() ? this.fDetails.computeMinimalWidth() : 0;
        return this.max(image + resources.getIconSummarySpacing() + summary, details);
    }

    @Override
    protected Point arrangeContent(int x, int y, int wHint, int hHint) {
        int detailsWidth = 0;
        int startY = y;
        PlanOutlineResources resources = this.getOutlineResources();
        this.fTypeImage.layout(x, y, -1, -1);
        int tx = x + this.fTypeImage.getWidth() + resources.getIconSummarySpacing();
        int maxSummaryWidth = wHint - tx;
        if (this.fSummary.computeMaximumWidth() > maxSummaryWidth) {
            this.fSummary.layout(tx, y, maxSummaryWidth, -1);
        } else {
            this.fSummary.layout(tx, y, -1, -1);
        }
        this.fSummary.setMaximumWidth(maxSummaryWidth);
        boolean showDetails = this.showDetails();
        this.fDetails.setExclude(!showDetails);
        y += this.max(this.fTypeImage.getHeight(), this.fSummary.getHeight());
        if (showDetails) {
            this.fDetails.layout(x + this.getImageWhiteSpace(), y += resources.getDescriptionSpacing(), wHint - this.getImageWhiteSpace(), -1);
            y += this.fDetails.getHeight();
            detailsWidth = this.fDetails.getWidth();
        }
        int width = this.max(wHint, this.fTypeImage.getWidth() + resources.getIconSummarySpacing() + this.fSummary.getWidth(), detailsWidth + this.getImageWhiteSpace());
        return new Point(width, y - startY);
    }

    @Override
    public PlanOutlineResources getOutlineResources() {
        return (PlanOutlineResources)super.getOutlineResources();
    }

    private IPlanOutlineSettings getPlanOutlineSettings() {
        return ((PlanItemOutline)this.getOutline()).getSettings();
    }

    private int getImageWhiteSpace() {
        return 2;
    }

    @Override
    public int getColumnCount() {
        return 1;
    }

    @Override
    public String getColumnId(int index) {
        Assert.isLegal((index == 0 ? 1 : 0) != 0);
        return "xxx.internal.problem.summary";
    }

    @Override
    public int getColumnWidth(int index) {
        Assert.isLegal((index == 0 ? 1 : 0) != 0);
        return this.fSummary.computeMaximumWidth();
    }

    private boolean showDetails() {
        return true;
    }
}

