/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.editor.outliner;

import com.ibm.team.apt.internal.client.ICorePlanItemFilter;
import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.client.ResolvedIterationPlan;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.client.WorkItemChangeEvent;
import com.ibm.team.workitem.common.model.ChangeDetails;
import com.ibm.team.workitem.common.model.IWorkItem;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class NotMineFilter
implements ICorePlanItemFilter {
    public boolean isCoreItem(PlanItem item) {
        IContributor owner = item.getOwner();
        IContributor currentUser = ((ResolvedIterationPlan)item.getPlan()).getTeamRepository().loggedInContributor();
        return this.matches((IContributorHandle)currentUser, (IContributorHandle)owner);
    }

    public boolean wasCoreItem(PlanItem item, WorkItemChangeEvent event) {
        ChangeDetails ownerChange = (ChangeDetails)event.getAttributeChangeDetails(IWorkItem.OWNER_PROPERTY);
        IContributor currentUser = ((ResolvedIterationPlan)item.getPlan()).getTeamRepository().loggedInContributor();
        return this.matches((IContributorHandle)currentUser, (IContributorHandle)(ownerChange != null ? ownerChange.getOldValue() : item.getOwner()));
    }

    private boolean matches(IContributorHandle currentUser, IContributorHandle owner) {
        if (currentUser == null || owner == null) {
            return false;
        }
        return currentUser.getItemId().equals((Object)owner.getItemId());
    }

    public void adopt(IWorkItem item) {
        IContributor currentUser = ((ITeamRepository)item.getOrigin()).loggedInContributor();
        item.setOwner((IContributorHandle)currentUser);
    }

    public List<String> getUnrelevantWorkItemReasons(PlanItem item, IProgressMonitor monitor) {
        ITeamRepository teamRepository = item.getPlan().getTeamRepository();
        IContributor owner = item.getOwner();
        IContributor currentUser = teamRepository.loggedInContributor();
        if (currentUser == null || owner == null || !currentUser.getItemId().equals((Object)owner.getItemId())) {
            return Collections.singletonList(NLS.bind((String)Messages.NotMineFilter_BELONGS_TO_OTHER_OWNER, (Object)owner.getName(), (Object[])new Object[0]));
        }
        return Collections.EMPTY_LIST;
    }
}

