/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.editor.outliner;

import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.common.Timespan;
import com.ibm.team.apt.internal.ide.ui.common.model.EntryUtils;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.Messages;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.OutlineFilterDescriptor;
import com.ibm.team.rtc.foundation.api.ui.model.IViewEntry;
import com.ibm.team.rtc.foundation.api.ui.model.IViewModelReader;
import java.util.Calendar;

public class NotCurrentWork
extends OutlineFilterDescriptor {
    private static final String ID = "FILTER_NOT_CURRENT_WORK";

    public NotCurrentWork() {
        super(ID, Messages.NotCurrentWork_LABEL, Messages.NotCurrentWork_DESCRIPTION);
    }

    @Override
    public boolean select(IViewEntry<?> entry, IViewModelReader readAccessor) {
        if (!EntryUtils.isType(entry, PlanItem.class)) {
            return true;
        }
        PlanItem item = (PlanItem)entry.getElement();
        Calendar startDate = Calendar.getInstance();
        startDate.setTime(item.getPlan().getReferenceTime());
        startDate.set(11, 0);
        startDate.set(12, 0);
        startDate.set(13, 0);
        startDate.set(14, 0);
        startDate.add(3, -1);
        Calendar endDate = (Calendar)startDate.clone();
        endDate.add(3, 2);
        Timespan scheduledTime = item.getScheduledTime();
        return scheduledTime != null && scheduledTime.getEnd().getTime() > startDate.getTimeInMillis() && scheduledTime.getStart().getTime() < endDate.getTimeInMillis();
    }

    @Override
    public boolean isFilterType(OutlineFilterDescriptor.FilterType filterType) {
        return filterType == OutlineFilterDescriptor.FilterType.REGULAR;
    }

    @Override
    public boolean isFilterProperty(IViewEntry<?> entry, String property) {
        return PlanItem.SCHEDULED_TIME.getId().equals(property);
    }
}

