/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.editor.outliner;

import com.ibm.team.apt.internal.client.IPlanElementVisitor;
import com.ibm.team.apt.internal.client.IPlanningAttribute;
import com.ibm.team.apt.internal.client.IterationPlanItem;
import com.ibm.team.apt.internal.client.PlanElement;
import com.ibm.team.apt.internal.client.ResolvedIterationPlan;
import com.ibm.team.apt.internal.client.ResolvedPlan;
import com.ibm.team.apt.internal.ide.ui.common.model.EntryUtils;
import com.ibm.team.apt.internal.ide.ui.common.structure.FolderElement;
import com.ibm.team.apt.internal.ide.ui.common.structure.GroupElement;
import com.ibm.team.apt.internal.ide.ui.common.structure.JavaScriptItemMovePolicy;
import com.ibm.team.apt.internal.ide.ui.scripting.interfaces.GroupProviderProxy;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.rtc.common.scriptengine.IScriptEnvironment;
import com.ibm.team.rtc.foundation.api.ui.model.IViewEntry;
import com.ibm.team.rtc.foundation.api.ui.model.IViewEntryVisitor;
import com.ibm.team.rtc.foundation.api.ui.model.IViewModel;
import com.ibm.team.rtc.foundation.api.ui.model.IViewModelFunction;
import com.ibm.team.rtc.foundation.api.ui.model.IViewModelNavigator;
import com.ibm.team.rtc.foundation.api.ui.model.IViewModelReadFunction;
import com.ibm.team.rtc.foundation.api.ui.model.IViewModelReader;
import com.ibm.team.rtc.foundation.api.ui.model.IViewModelUpdateFunction;
import com.ibm.team.rtc.foundation.api.ui.model.IViewModelUpdater;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class MyFolderItemMovePolicy
extends JavaScriptItemMovePolicy {
    private FolderGroupProvider fFolderGroupProvider;

    public MyFolderItemMovePolicy(IScriptEnvironment scriptEnvironment) {
        super(scriptEnvironment);
    }

    @Override
    public void setGroupProvider(GroupProviderProxy groupProvider) {
        super.setGroupProvider(groupProvider);
        this.fFolderGroupProvider = groupProvider.createSpecificProxy(FolderGroupProvider.class);
    }

    public void addFolderBelow(final IViewEntry<FolderElement> siblingEntry, final String name) {
        final IViewModel model = siblingEntry.getModel();
        model.updateModel((IViewModelUpdateFunction)new IViewModelUpdateFunction<Void, RuntimeException>(){

            public Void run(IViewModelUpdater updateAccessor) throws RuntimeException {
                IViewModelNavigator n = updateAccessor.getEntryNavigator(false);
                FolderElement parent = (FolderElement)EntryUtils.element(n.parentEntryOfType(n.parentEntry(siblingEntry), FolderElement.class));
                final IViewEntry<FolderElement> newFolderEntry = MyFolderItemMovePolicy.this.fFolderGroupProvider.__createFolderEntry(UUID.generate().getUuidValue(), name, -1, parent != null ? parent.getId() : null, updateAccessor);
                List siblingEntries = n.siblingEntries(siblingEntry);
                updateAccessor.move(newFolderEntry, siblingEntries.indexOf(siblingEntry) + 1);
                updateAccessor.executeAfterUpdate(new IViewModelFunction(){

                    public void run() {
                        model.revealEntry(newFolderEntry);
                        model.setSelected(newFolderEntry, true);
                    }
                });
                ((ResolvedIterationPlan)MyFolderItemMovePolicy.this.getPlan(siblingEntry)).setAuxiliaryDataChanged();
                return null;
            }
        });
    }

    public void deleteFolder(final IViewEntry<FolderElement> entry, FolderElement bugsFolder) {
        final HashSet removed = new HashSet();
        final HashSet entriesToRemove = new HashSet();
        final IViewModel model = entry.getModel();
        final IViewEntry toSelect = (IViewEntry)model.readModel(new IViewModelReadFunction<IViewEntry<?>, RuntimeException>(){

            public IViewEntry<?> run(IViewModelReader readAccessor) throws RuntimeException {
                readAccessor.accept(new IViewEntryVisitor(){

                    public boolean visit(IViewEntry<?> entry) {
                        if (entry.getElement() instanceof FolderElement) {
                            entriesToRemove.add(EntryUtils.cast(entry, FolderElement.class));
                            removed.add(((FolderElement)entry.getElement()).getId());
                            return true;
                        }
                        return false;
                    }
                }, entry);
                IViewModelNavigator n = readAccessor.getEntryNavigator(true);
                IViewEntry result = n.successorEntry(entry);
                if (result == null) {
                    result = n.predecessorEntry(entry);
                }
                if (result == null && (result = n.parentEntry(entry)) != null && !EntryUtils.isType(result, FolderElement.class)) {
                    result = null;
                }
                return result;
            }
        });
        final IPlanningAttribute folderAttribute = this.fFolderGroupProvider.__getFolderAttribute();
        ResolvedIterationPlan plan = (ResolvedIterationPlan)this.getPlan(entry);
        final String bugFolderId = bugsFolder.getId();
        try {
            plan.connectDeltaBuilder();
            plan.accept(new IPlanElementVisitor(){

                public boolean visit(PlanElement element) {
                    IterationPlanItem item;
                    if (element instanceof IterationPlanItem && removed.contains(folderAttribute.getValue((Object)(item = (IterationPlanItem)element)))) {
                        folderAttribute.setValue((Object)item, (Object)bugFolderId);
                    }
                    return true;
                }
            });
            plan.setAuxiliaryDataChanged();
        }
        finally {
            plan.disconnectDeltaBuilder();
        }
        model.updateModel((IViewModelUpdateFunction)new IViewModelUpdateFunction<Void, RuntimeException>(){

            public Void run(IViewModelUpdater updateAccessor) throws RuntimeException {
                for (IViewEntry toRemove : entriesToRemove) {
                    updateAccessor.removeEntry(toRemove);
                }
                if (toSelect != null) {
                    updateAccessor.executeAfterUpdate(new IViewModelFunction(){

                        public void run() {
                            model.revealEntry(toSelect);
                            model.setSelected(toSelect, true);
                        }
                    });
                }
                return null;
            }
        });
    }

    public void renameFolder(final IViewEntry<FolderElement> toRename, String newName) {
        this.fFolderGroupProvider.__renameFolder(((FolderElement)toRename.getElement()).getId(), newName);
        toRename.getModel().updateModel((IViewModelUpdateFunction)new IViewModelUpdateFunction<Void, RuntimeException>(){

            public Void run(IViewModelUpdater updateAccessor) throws RuntimeException {
                updateAccessor.update(toRename, new String[]{"label"});
                return null;
            }
        });
    }

    public void adopt(final IViewEntry<FolderElement> folder, final Collection<IViewEntry<IterationPlanItem>> entries) {
        final IPlanningAttribute folderAttribute = this.fFolderGroupProvider.__getFolderAttribute();
        final FolderElement gfe = (FolderElement)folder.getElement();
        ResolvedPlan plan = this.getPlan(folder);
        try {
            plan.connectDeltaBuilder();
            for (IViewEntry<IterationPlanItem> outlineEntry : entries) {
                IterationPlanItem toChange = (IterationPlanItem)outlineEntry.getElement();
                final String currentFolder = (String)folderAttribute.getValue((Object)toChange);
                toChange.accept(new IPlanElementVisitor(){

                    public boolean visit(PlanElement element) {
                        if (element instanceof IterationPlanItem && currentFolder.equals(folderAttribute.getValue((Object)element))) {
                            gfe.adopt(element, (IViewEntry<? extends GroupElement>)folder, (IProgressMonitor)new NullProgressMonitor());
                        }
                        return true;
                    }
                });
            }
        }
        finally {
            plan.disconnectDeltaBuilder();
        }
        final IViewModel model = folder.getModel();
        model.updateModel((IViewModelUpdateFunction)new IViewModelUpdateFunction<Void, RuntimeException>(){

            public Void run(IViewModelUpdater updateAccessor) throws RuntimeException {
                IViewModelNavigator n = updateAccessor.getEntryNavigator(true);
                List children = n.childEntries(folder);
                final ArrayList<IViewEntry> toSelect = new ArrayList<IViewEntry>();
                for (IViewEntry adpoted : entries) {
                    for (IViewEntry child : children) {
                        if (adpoted.getElement() != child.getElement()) continue;
                        toSelect.add(child);
                    }
                }
                if (!toSelect.isEmpty()) {
                    updateAccessor.executeAfterUpdate(new IViewModelFunction(){

                        public void run() {
                            model.revealEntry((IViewEntry)toSelect.get(0));
                            model.setSelectedEntries(toSelect);
                        }
                    });
                }
                return null;
            }
        });
        ((ResolvedIterationPlan)plan).setAuxiliaryDataChanged();
    }

    public static interface FolderGroupProvider {
        public IPlanningAttribute __getFolderAttribute();

        public IViewEntry<FolderElement> __createFolderEntry(String var1, String var2, int var3, String var4, IViewModelUpdater var5);

        public FolderElement __getBugsFolder();

        public void __renameFolder(String var1, String var2);

        public void __deleteFolder(String var1);
    }
}

