/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.editor.outliner;

import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.client.ResolvedIterationPlan;
import com.ibm.team.apt.internal.ide.ui.actions.OpenUserAction;
import com.ibm.team.apt.internal.ide.ui.common.PlanCanvas;
import com.ibm.team.apt.internal.ide.ui.common.PlanViewModel;
import com.ibm.team.apt.internal.ide.ui.common.model.EntryUtils;
import com.ibm.team.apt.internal.ide.ui.common.model.OutlineModel;
import com.ibm.team.apt.internal.ide.ui.common.structure.OwnerElement;
import com.ibm.team.apt.internal.ide.ui.editor.PlanItemActionGroup;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.IPlanOutlineSettings;
import com.ibm.team.foundation.rcp.ui.util.FoundationUIUtils;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.rtc.foundation.api.ui.model.IViewEntry;
import com.ibm.team.rtc.foundation.api.ui.model.IViewModelFunction;
import com.ibm.team.rtc.foundation.api.ui.model.IViewModelUpdateFunction;
import com.ibm.team.rtc.foundation.api.ui.model.IViewModelUpdater;
import java.util.List;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;

public class IterationPlanViewModel
extends PlanViewModel {
    private PlanItemActionGroup fActionGroup;
    private ListenerList fSortListeners = new ListenerList();

    public IterationPlanViewModel(IPlanOutlineSettings settings) {
        super(settings);
    }

    public ResolvedIterationPlan getInput() {
        return (ResolvedIterationPlan)super.getInput();
    }

    @Override
    public void setInput(Object newInput) {
        ResolvedIterationPlan oldInput = this.getInput();
        super.setInput(newInput);
        if (this.fActionGroup != null) {
            this.fActionGroup.inputChanged(oldInput, newInput);
        }
    }

    public Action getAction(String id) {
        return this.fActionGroup.getAction(id);
    }

    public Action[] getActions() {
        return this.fActionGroup.getActions();
    }

    public void addSortListener(SortListener sortListener) {
        this.fSortListeners.add((Object)sortListener);
    }

    public void removeSortListener(SortListener sortListener) {
        this.fSortListeners.remove((Object)sortListener);
    }

    public void dispose() {
        this.setInput(null);
        this.fActionGroup.dispose();
        this.fActionGroup = null;
    }

    @Override
    public IPlanOutlineSettings getOutlineSettings() {
        return (IPlanOutlineSettings)super.getOutlineSettings();
    }

    public void hookContextMenu(final IWorkbenchPartSite site) {
        this.fActionGroup = new PlanItemActionGroup((IWorkbenchSite)site, this);
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        PlanCanvas outline = this.getViewer().getOutline();
        IMenuListener menuListener = new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                IViewEntry firstEntry;
                IContributor owner;
                IterationPlanViewModel.this.fActionGroup.fillContextMenu(manager);
                manager.add((IContributionItem)new Separator("jazz.open.group"));
                manager.add((IContributionItem)new Separator());
                manager.add((IContributionItem)new Separator("additions"));
                manager.add((IContributionItem)new Separator());
                manager.add((IContributionItem)new Separator("jazz.properties.group"));
                List<IViewEntry<?>> selectedEntries = IterationPlanViewModel.this.getSelectedEntries();
                if (selectedEntries.size() == 1 && (owner = IterationPlanViewModel.this.getOwner(firstEntry = (IViewEntry)selectedEntries.iterator().next())) != null) {
                    MenuManager ownerMenu = new MenuManager(owner.getName());
                    ISelectionProvider selectionProvider = new ISelectionProvider(){

                        public void setSelection(ISelection selection) {
                        }

                        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
                        }

                        public ISelection getSelection() {
                            return new StructuredSelection((Object)owner);
                        }

                        public void addSelectionChangedListener(ISelectionChangedListener listener) {
                        }
                    };
                    FoundationUIUtils.contributeObjectActions((IWorkbenchPart)site.getPart(), (IMenuManager)ownerMenu, (ISelectionProvider)selectionProvider);
                    manager.appendToGroup("additions", (IContributionItem)ownerMenu);
                    if (EntryUtils.isType(firstEntry, OwnerElement.class)) {
                        OpenUserAction action = new OpenUserAction(site.getPage(), owner, "com.ibm.team.apt.resource.contributor.absences");
                        manager.appendToGroup("jazz.open.group", (IAction)action);
                    }
                }
            }
        };
        menuMgr.addMenuListener(menuListener);
        outline.hookContextMenu(menuListener);
        Menu menu = menuMgr.createContextMenu((Control)outline);
        outline.setMenu(menu);
    }

    private IContributor getOwner(IViewEntry<?> entry) {
        IContributor result = null;
        Object element = entry.getElement();
        if (element instanceof PlanItem) {
            PlanItem planItem = (PlanItem)element;
            result = planItem.getOwner();
        } else if (element instanceof OwnerElement) {
            OwnerElement ownerElement = (OwnerElement)element;
            result = ownerElement.getOwner();
        }
        if (result != null && result.sameItemId((IItemHandle)this.getInput().getNullOwner())) {
            return null;
        }
        return result;
    }

    @Override
    protected void resort() {
        this.updateModel(new IViewModelUpdateFunction<Void, RuntimeException>(){

            public Void run(IViewModelUpdater modifier) {
                IterationPlanViewModel.super.resort();
                modifier.executeAfterUpdate(new IViewModelFunction(){

                    public void run() {
                        IterationPlanViewModel.this.fireSortingChanged(true);
                    }
                });
                return null;
            }
        });
    }

    private void fireSortingChanged(final boolean isSorted) {
        Object[] listeners;
        Object[] objectArray = listeners = this.fSortListeners.getListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            final Object listener = objectArray[n2];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    ((SortListener)listener).sortingChanged(isSorted);
                }

                public void handleException(Throwable e) {
                }
            });
            ++n2;
        }
    }

    @Override
    protected OutlineModel.ModelUpdateAccessor createUpdateAccessor() {
        return new MoveAwareModelUpdateAccessor();
    }

    private class MoveAwareModelUpdateAccessor
    extends OutlineModel.ModelUpdateAccessor {
        private MoveAwareModelUpdateAccessor() {
            super(IterationPlanViewModel.this);
        }

        @Override
        public void move(IViewEntry<?> entry, int index) {
            super.move(entry, index);
            this.executeAfterUpdate(new IViewModelFunction(){

                public void run() {
                    IterationPlanViewModel.this.fireSortingChanged(false);
                }
            });
        }
    }

    public static interface SortListener {
        public void sortingChanged(boolean var1);
    }
}

