/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.editor.outliner;

import com.ibm.team.apt.api.common.planning.IProgressInformation;
import com.ibm.team.apt.api.common.planning.IProgressLabelProvider;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.Messages;
import com.ibm.team.apt.internal.ide.ui.progress.ProgressBarDrawingStrategy;
import com.ibm.team.apt.internal.ide.ui.util.HtmlStyle;
import com.ibm.team.apt.internal.ide.ui.util.UI;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.BarPainters;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.BarResources;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.TextStyleRange;
import com.ibm.team.jface.DoubleBufferPainter;
import com.ibm.team.jface.tooltip.TooltipSupport;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public final class IterationPlanProgressBar
extends Canvas {
    private BarResources fResources = new BarResources((Control)this);
    private ProgressBarDrawingStrategy fDrawingStrategy = new ProgressBarDrawingStrategy(this.fResources);
    private TextLayout fTextLayout;
    private int fXPadding;
    private IProgressLabelProvider fLabelProvider;
    private IProgressInformation fInput;
    private boolean fFocus;

    public IterationPlanProgressBar(Composite parent, int style, final int horizontalAlignment) {
        super(parent, style | 0x40000);
        this.fTextLayout = new TextLayout((Device)parent.getDisplay());
        this.fXPadding = UI.height(this.getFont()) / 4;
        new DoubleBufferPainter(this){

            public void doPaint(PaintEvent e) {
                if (IterationPlanProgressBar.this.fLabelProvider == null || IterationPlanProgressBar.this.fInput == null) {
                    return;
                }
                e.gc.setAdvanced(true);
                Rectangle clientArea = IterationPlanProgressBar.this.getClientArea();
                IterationPlanProgressBar.this.fTextLayout.setAscent(-1);
                IterationPlanProgressBar.this.fTextLayout.setDescent(-1);
                IterationPlanProgressBar.this.fTextLayout.setWidth(-1);
                IterationPlanProgressBar.this.fTextLayout.setText("");
                IterationPlanProgressBar.this.fTextLayout.setAlignment(16384);
                IterationPlanProgressBar.this.fTextLayout.setFont(e.gc.getFont());
                HtmlStyle formattedProgress = HtmlStyle.parse(IterationPlanProgressBar.this.fLabelProvider.getProgressText(IterationPlanProgressBar.this.fInput), IterationPlanProgressBar.this.fResources.getStyles());
                IterationPlanProgressBar.this.fTextLayout.setText(formattedProgress.getTextValue());
                Rectangle extentHourLabel = IterationPlanProgressBar.this.fTextLayout.getBounds();
                HtmlStyle formattedQuality = HtmlStyle.parse(IterationPlanProgressBar.this.fLabelProvider.getQualityText(IterationPlanProgressBar.this.fInput), IterationPlanProgressBar.this.fResources.getStyles());
                IterationPlanProgressBar.this.fTextLayout.setText(formattedQuality.getTextValue());
                Rectangle extentQualityLabel = IterationPlanProgressBar.this.fTextLayout.getBounds();
                int barWidth = 0;
                String message = IterationPlanProgressBar.this.fLabelProvider.getMessage(IterationPlanProgressBar.this.fInput);
                if ((horizontalAlignment & 0x20000) != 0) {
                    int xOffset = 0;
                    int totalXPadding = 0;
                    if (message != null) {
                        totalXPadding = 2 * IterationPlanProgressBar.this.fXPadding;
                        barWidth = xOffset = e.gc.stringExtent((String)message).x * 2;
                    } else {
                        totalXPadding = 6 * IterationPlanProgressBar.this.fXPadding;
                        barWidth = IterationPlanProgressBar.this.fResources.getMessageFontMetrics().getAverageCharWidth() * 22;
                        xOffset = barWidth * 2;
                    }
                    xOffset += totalXPadding;
                    xOffset = clientArea.width - xOffset;
                    xOffset = Math.max(0, xOffset);
                    clientArea.x += xOffset;
                    clientArea.width -= xOffset;
                }
                if (message != null) {
                    Rectangle bounds = this.divide(clientArea, new int[]{-1}, IterationPlanProgressBar.this.fXPadding)[0];
                    if (clientArea.width > barWidth) {
                        int delta = clientArea.width - barWidth;
                        clientArea.x += delta;
                        clientArea.width -= delta;
                    }
                    IterationPlanProgressBar.this.fDrawingStrategy.paint(e.gc, bounds);
                } else if ((float)(extentQualityLabel.width + extentHourLabel.width) > (float)(clientArea.width - 6 * IterationPlanProgressBar.this.fXPadding) * 0.5f) {
                    if (clientArea.width > barWidth) {
                        int delta = clientArea.width - barWidth;
                        clientArea.x += delta;
                        clientArea.width -= delta;
                    }
                    IterationPlanProgressBar.this.fDrawingStrategy.paint(e.gc, clientArea);
                } else {
                    TextStyleRange[] styleRanges;
                    Rectangle[] rectangles = this.divide(clientArea, new int[]{extentHourLabel.width, -1, extentQualityLabel.width}, IterationPlanProgressBar.this.fXPadding);
                    IterationPlanProgressBar.this.fTextLayout.setText(formattedProgress.getTextValue());
                    TextStyleRange[] textStyleRangeArray = styleRanges = formattedProgress.getStyleRanges();
                    int n = styleRanges.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TextStyleRange range = textStyleRangeArray[n2];
                        range.addTo(IterationPlanProgressBar.this.fTextLayout);
                        ++n2;
                    }
                    Point point = BarPainters.align(rectangles[0], extentHourLabel.width, extentHourLabel.height, BarPainters.Alignment.Center, new BarPainters.Alignment[0]);
                    IterationPlanProgressBar.this.fTextLayout.draw(e.gc, point.x, point.y);
                    IterationPlanProgressBar.this.fDrawingStrategy.paint(e.gc, rectangles[1]);
                    point = BarPainters.align(rectangles[2], extentQualityLabel.width, extentQualityLabel.height, BarPainters.Alignment.Center, new BarPainters.Alignment[0]);
                    e.gc.drawString(formattedQuality.getTextValue(), point.x, point.y, true);
                }
                if (IterationPlanProgressBar.this.fFocus) {
                    e.gc.drawFocus(clientArea.x, clientArea.y, clientArea.width, clientArea.height);
                }
            }

            private Rectangle[] divide(Rectangle bounds, int[] widths, int xPadding) {
                int n;
                int width;
                Rectangle[] result = new Rectangle[widths.length];
                int remainingWidth = bounds.width;
                int nDefaultWidth = 0;
                int i = 0;
                while (i < widths.length) {
                    width = widths[i];
                    remainingWidth -= 2 * xPadding;
                    if (width != -1) {
                        remainingWidth -= Math.max(0, width);
                    } else {
                        ++nDefaultWidth;
                    }
                    result[i] = new Rectangle(-1, bounds.y, width, bounds.height);
                    ++i;
                }
                if (nDefaultWidth > 0) {
                    Rectangle[] rectangleArray = result;
                    n = result.length;
                    width = 0;
                    while (width < n) {
                        Rectangle rect = rectangleArray[width];
                        if (rect.width == -1) {
                            rect.width = remainingWidth / nDefaultWidth;
                        }
                        ++width;
                    }
                }
                int currentX = bounds.x;
                Rectangle[] rectangleArray = result;
                int n2 = result.length;
                n = 0;
                while (n < n2) {
                    Rectangle rect = rectangleArray[n];
                    rect.x = currentX += xPadding;
                    currentX += rect.width + xPadding;
                    ++n;
                }
                return result;
            }
        };
        new TooltipSupport((Control)this, true, false){

            public Object getElement(Control control, int x, int y) {
                return IterationPlanProgressBar.this.fInput;
            }
        };
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                IterationPlanProgressBar.this.fTextLayout.dispose();
            }
        });
        this.addKeyListener((KeyListener)new KeyAdapter(){});
        this.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                IterationPlanProgressBar.this.fFocus = true;
                IterationPlanProgressBar.this.redraw();
            }

            public void focusLost(FocusEvent e) {
                IterationPlanProgressBar.this.fFocus = false;
                IterationPlanProgressBar.this.redraw();
            }
        });
        this.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                switch (e.detail) {
                    case 2: 
                    case 4: 
                    case 8: 
                    case 16: 
                    case 256: 
                    case 512: {
                        e.doit = true;
                    }
                }
            }
        });
        this.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                if (IterationPlanProgressBar.this.fLabelProvider != null && IterationPlanProgressBar.this.fInput != null) {
                    String message = IterationPlanProgressBar.this.fLabelProvider.getMessage(IterationPlanProgressBar.this.fInput);
                    if (message != null) {
                        e.result = message;
                    } else {
                        HtmlStyle progress = HtmlStyle.parse(IterationPlanProgressBar.this.fLabelProvider.getProgressText(IterationPlanProgressBar.this.fInput), IterationPlanProgressBar.this.fResources.getStyles());
                        e.result = Messages.bind((String)Messages.IterationPlanProgressBar_ACCESSIBLE_PROGRESS_LABEL, (Object)progress.getTextValue());
                    }
                } else {
                    e.result = Messages.IterationPlanProgressBar_ACCESSIBLE_DEFAULT;
                }
            }
        });
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        int width = wHint;
        int height = this.computeMinimalHeight();
        if (this.fLabelProvider != null && this.fInput != null) {
            boolean msg = this.fLabelProvider.getMessage(this.fInput) != null;
            boolean proj = this.fLabelProvider.getDeltaDirection(this.fInput) != 0.0;
            width = 0;
            if (msg) {
                this.fTextLayout.setText(this.fLabelProvider.getMessage(this.fInput));
                width = Math.max(this.fTextLayout.getBounds().width, height * 12);
            } else if (proj) {
                this.fTextLayout.setText(this.fLabelProvider.getProgressText(this.fInput));
                width += this.fTextLayout.getBounds().width;
                this.fTextLayout.setText(this.fLabelProvider.getQualityText(this.fInput));
                width += this.fTextLayout.getBounds().width;
                width *= 2;
                width += 6 * this.fXPadding;
            } else {
                this.fTextLayout.setText(this.fLabelProvider.getQualityText(this.fInput));
                width += this.fTextLayout.getBounds().width;
                width *= 2;
                width += 4 * this.fXPadding;
            }
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        return new Point(width, height);
    }

    public int computeMinimalHeight() {
        return this.fDrawingStrategy.computeMinimalHeight();
    }

    public int computeTrimHeight(int height) {
        return this.fDrawingStrategy.computeTrimHeight(height);
    }

    public void setProgressInformation(IProgressInformation progressInformation) {
        this.fInput = progressInformation;
        this.fDrawingStrategy.setInput(progressInformation);
        this.layout();
        this.redraw();
        this.update();
    }

    public void setLabelProvider(IProgressLabelProvider labelProvider) {
        this.fLabelProvider = labelProvider;
        this.fDrawingStrategy.setLabelProvider(labelProvider);
        this.layout();
        this.redraw();
        this.update();
    }
}

