/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.editor.outliner;

import com.ibm.team.apt.internal.client.teamload.AbstractLoadItem;
import com.ibm.team.apt.internal.client.teamload.LoadItems;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.Messages;
import com.ibm.team.apt.internal.ide.ui.util.UI;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.BarPainters;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.BarResources;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.LoadBarPainter;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.TextStyleRange;
import com.ibm.team.jface.DoubleBufferPainter;
import com.ibm.team.jface.tooltip.TooltipSupport;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public final class IterationPlanLoadBar
extends Canvas {
    private BarResources fResources = new BarResources((Control)this);
    private LoadBarPainter fBarPainter = new LoadBarPainter(this.fResources);
    private TextLayout fTextLayout;
    private int fXPadding;
    private AbstractLoadItem fInput;
    private boolean fFocus;

    public IterationPlanLoadBar(Composite parent, int style, final int horizontalAlignment) {
        super(parent, style | 0x40000);
        this.fTextLayout = new TextLayout((Device)parent.getDisplay());
        this.fXPadding = UI.height(this.getFont()) / 4;
        new DoubleBufferPainter(this){

            public void doPaint(PaintEvent e) {
                String message;
                if (IterationPlanLoadBar.this.fInput == null) {
                    return;
                }
                e.gc.setAdvanced(true);
                Rectangle clientArea = IterationPlanLoadBar.this.getClientArea();
                IterationPlanLoadBar.this.fTextLayout.setAscent(-1);
                IterationPlanLoadBar.this.fTextLayout.setDescent(-1);
                IterationPlanLoadBar.this.fTextLayout.setWidth(-1);
                IterationPlanLoadBar.this.fTextLayout.setText("");
                IterationPlanLoadBar.this.fTextLayout.setAlignment(16384);
                IterationPlanLoadBar.this.fTextLayout.setFont(e.gc.getFont());
                String textHours = LoadItems.getTextHoursShort((AbstractLoadItem)IterationPlanLoadBar.this.fInput);
                IterationPlanLoadBar.this.fTextLayout.setText(textHours);
                Rectangle extentHourLabel = IterationPlanLoadBar.this.fTextLayout.getBounds();
                String textEstimate = LoadItems.getTextEstimateShort((AbstractLoadItem)IterationPlanLoadBar.this.fInput);
                IterationPlanLoadBar.this.fTextLayout.setText(textEstimate);
                Rectangle extentQualityLabel = IterationPlanLoadBar.this.fTextLayout.getBounds();
                int barWidth = 0;
                String string = message = LoadItems.getMessage((AbstractLoadItem)IterationPlanLoadBar.this.fInput) != null ? LoadItems.getMessage((AbstractLoadItem)IterationPlanLoadBar.this.fInput).getMessage() : null;
                if ((horizontalAlignment & 0x20000) != 0) {
                    int xOffset = 0;
                    int totalXPadding = 0;
                    if (message != null) {
                        totalXPadding = 2 * IterationPlanLoadBar.this.fXPadding;
                        barWidth = xOffset = e.gc.stringExtent((String)message).x * 2;
                    } else {
                        totalXPadding = 6 * IterationPlanLoadBar.this.fXPadding;
                        barWidth = IterationPlanLoadBar.this.fResources.getMessageFontMetrics().getAverageCharWidth() * 22;
                        xOffset = barWidth * 2;
                    }
                    xOffset += totalXPadding;
                    xOffset = clientArea.width - xOffset;
                    xOffset = Math.max(0, xOffset);
                    clientArea.x += xOffset;
                    clientArea.width -= xOffset;
                }
                if (message != null) {
                    Rectangle bounds = this.divide(clientArea, new int[]{-1}, IterationPlanLoadBar.this.fXPadding)[0];
                    if (clientArea.width > barWidth) {
                        int delta = clientArea.width - barWidth;
                        clientArea.x += delta;
                        clientArea.width -= delta;
                    }
                    IterationPlanLoadBar.this.fBarPainter.paint(e.gc, bounds, IterationPlanLoadBar.this.fInput);
                } else if ((float)(extentQualityLabel.width + extentHourLabel.width) > (float)(clientArea.width - 6 * IterationPlanLoadBar.this.fXPadding) * 0.5f) {
                    if (clientArea.width > barWidth) {
                        int delta = clientArea.width - barWidth;
                        clientArea.x += delta;
                        clientArea.width -= delta;
                    }
                    IterationPlanLoadBar.this.fBarPainter.paint(e.gc, clientArea, IterationPlanLoadBar.this.fInput);
                } else {
                    Rectangle[] rectangles = this.divide(clientArea, new int[]{extentHourLabel.width, -1, extentQualityLabel.width}, IterationPlanLoadBar.this.fXPadding);
                    IterationPlanLoadBar.this.fTextLayout.setText(textHours);
                    TextStyleRange[] styleRanges = this.getTextStyleRanges(textHours);
                    if (styleRanges != null) {
                        TextStyleRange[] textStyleRangeArray = styleRanges;
                        int n = styleRanges.length;
                        int n2 = 0;
                        while (n2 < n) {
                            TextStyleRange range = textStyleRangeArray[n2];
                            range.addTo(IterationPlanLoadBar.this.fTextLayout);
                            ++n2;
                        }
                    }
                    Point point = BarPainters.align(rectangles[0], extentHourLabel.width, extentHourLabel.height, BarPainters.Alignment.Center, new BarPainters.Alignment[0]);
                    IterationPlanLoadBar.this.fTextLayout.draw(e.gc, point.x, point.y);
                    IterationPlanLoadBar.this.fBarPainter.paint(e.gc, rectangles[1], IterationPlanLoadBar.this.fInput);
                    point = BarPainters.align(rectangles[2], extentQualityLabel.width, extentQualityLabel.height, BarPainters.Alignment.Center, new BarPainters.Alignment[0]);
                    e.gc.drawString(textEstimate, point.x, point.y, true);
                }
                if (IterationPlanLoadBar.this.fFocus) {
                    e.gc.drawFocus(clientArea.x, clientArea.y, clientArea.width, clientArea.height);
                }
            }

            private Rectangle[] divide(Rectangle bounds, int[] widths, int xPadding) {
                int n;
                int width;
                Rectangle[] result = new Rectangle[widths.length];
                int remainingWidth = bounds.width;
                int nDefaultWidth = 0;
                int i = 0;
                while (i < widths.length) {
                    width = widths[i];
                    remainingWidth -= 2 * xPadding;
                    if (width != -1) {
                        remainingWidth -= Math.max(0, width);
                    } else {
                        ++nDefaultWidth;
                    }
                    result[i] = new Rectangle(-1, bounds.y, width, bounds.height);
                    ++i;
                }
                if (nDefaultWidth > 0) {
                    Rectangle[] rectangleArray = result;
                    n = result.length;
                    width = 0;
                    while (width < n) {
                        Rectangle rect = rectangleArray[width];
                        if (rect.width == -1) {
                            rect.width = remainingWidth / nDefaultWidth;
                        }
                        ++width;
                    }
                }
                int currentX = bounds.x;
                Rectangle[] rectangleArray = result;
                int n2 = result.length;
                n = 0;
                while (n < n2) {
                    Rectangle rect = rectangleArray[n];
                    rect.x = currentX += xPadding;
                    currentX += rect.width + xPadding;
                    ++n;
                }
                return result;
            }

            private TextStyleRange[] getTextStyleRanges(String textHours) {
                int s1 = textHours.lastIndexOf(124);
                int e1 = textHours.lastIndexOf(104);
                if (e1 == -1) {
                    e1 = textHours.length();
                }
                if (s1 != -1) {
                    Color textColor = LoadItems.isOverbooked((AbstractLoadItem)IterationPlanLoadBar.this.fInput) ? IterationPlanLoadBar.this.fBarPainter.getBarResources().getRed() : IterationPlanLoadBar.this.fBarPainter.getBarResources().getGreen();
                    TextStyleRange[] ranges = new TextStyleRange[]{new TextStyleRange(s1 + 1, Math.max(0, e1 - s1 - 2), new TextStyle(null, textColor, null))};
                    return ranges;
                }
                return null;
            }
        };
        new TooltipSupport((Control)this, true, false){

            public Object getElement(Control control, int x, int y) {
                return IterationPlanLoadBar.this.fInput;
            }
        };
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                IterationPlanLoadBar.this.fTextLayout.dispose();
            }
        });
        this.addKeyListener((KeyListener)new KeyAdapter(){});
        this.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                IterationPlanLoadBar.this.fFocus = true;
                IterationPlanLoadBar.this.redraw();
            }

            public void focusLost(FocusEvent e) {
                IterationPlanLoadBar.this.fFocus = false;
                IterationPlanLoadBar.this.redraw();
            }
        });
        this.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                switch (e.detail) {
                    case 2: 
                    case 4: 
                    case 8: 
                    case 16: 
                    case 256: 
                    case 512: {
                        e.doit = true;
                    }
                }
            }
        });
        this.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = IterationPlanLoadBar.this.fInput != null ? LoadItems.getTextHours((AbstractLoadItem)IterationPlanLoadBar.this.fInput) : Messages.IterationPlanLoadBar_ACCESSIBLE_DEFAULT;
            }
        });
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        int width = wHint;
        int height = this.computeMinimalHeight();
        if (this.fInput != null) {
            boolean msg = LoadItems.getMessage((AbstractLoadItem)this.fInput) != null;
            width = 0;
            if (msg) {
                this.fTextLayout.setText(LoadItems.getMessage((AbstractLoadItem)this.fInput).getMessage());
                width = Math.max(this.fTextLayout.getBounds().width, height * 12);
            } else {
                this.fTextLayout.setText(LoadItems.getTextHours((AbstractLoadItem)this.fInput));
                width += this.fTextLayout.getBounds().width;
                this.fTextLayout.setText(LoadItems.getTextEstimate((AbstractLoadItem)this.fInput));
                width += this.fTextLayout.getBounds().width;
                width *= 2;
                width += 6 * this.fXPadding;
            }
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        return new Point(width, height);
    }

    public void setInput(AbstractLoadItem input) {
        this.fInput = input;
        this.redraw();
    }

    public int computeMinimalHeight() {
        return this.fBarPainter.computeMinimalHeight();
    }

    public int computeTrimHeight(int height) {
        return this.fBarPainter.computeTrimHeight(height);
    }
}

