/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.editor.outliner;

import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.ide.ui.common.PlanOutlineResources;
import com.ibm.team.apt.internal.ide.ui.common.gadgets.GFadeableTreeNodeContent;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.IColumnBasedGadget;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.IPlanOutlineSettings;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.PlanItemOutline;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.CompositeGadget;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GText;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.OutlineResources;
import java.util.Arrays;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public abstract class IterationPlanItemNodeContent
extends GFadeableTreeNodeContent
implements IColumnBasedGadget {
    private static final String[] LABEL_PROPERTIES = new String[]{PlanItem.DIRTY.getId(), PlanItem.ITEM_TYPE.getId(), PlanItem.SUMMARY.getId(), PlanItem.ID.getId(), PlanItem.DESCRIPTION.getId(), PlanItem.AUXILIARY_ITEM.getId(), PlanItem.DRAFT_ITEM.getId(), PlanItem.STATE.getId(), PlanItem.CHILDREN.getId(), PlanItem.PLANCHECK_REPORT.getId(), PlanItem.STATE.getId(), PlanItem.WORKFLOW_ACTION.getId()};
    private PlanItem fPlanItem;
    private boolean fIsPlaceholder;

    static {
        Arrays.sort(LABEL_PROPERTIES);
    }

    protected IterationPlanItemNodeContent(CompositeGadget parent, PlanItem planItem, boolean isPlaceholder) {
        super(parent);
        this.fPlanItem = planItem;
        this.fIsPlaceholder = isPlaceholder;
    }

    public abstract GText getSummary();

    public abstract GText getDescription();

    @Override
    public Object getElement() {
        return this.fPlanItem;
    }

    protected PlanItem getPlanItem() {
        return this.fPlanItem;
    }

    @Override
    protected int getAlphaValue() {
        return this.fIsPlaceholder ? 125 : 255;
    }

    @Override
    protected Color getBackgroundColor() {
        return this.getOutline().getBackground();
    }

    public boolean isPlaceholder() {
        return this.fIsPlaceholder;
    }

    @Override
    public boolean isLabelProperty(String property) {
        return Arrays.binarySearch(LABEL_PROPERTIES, property) >= 0;
    }

    @Override
    public void paint(GC gc, OutlineResources resources) {
        super.paint(gc, resources);
        if (this.getOutlineResources().debugLayout) {
            Rectangle bounds = this.getTransformation().toViewPort(this.fBounds);
            gc.drawRectangle(bounds.x, bounds.y, bounds.width - 1, bounds.height - 1);
        }
    }

    protected PlanOutlineResources getPlanOutlineResources() {
        return (PlanOutlineResources)this.getOutlineResources();
    }

    protected IPlanOutlineSettings getPlanOutlineSettings() {
        return ((PlanItemOutline)this.getOutline()).getSettings();
    }

    protected int getImageWhiteSpace() {
        return 2;
    }
}

