/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.editor.outliner;

import com.ibm.team.apt.internal.client.IPlanElementDelta;
import com.ibm.team.apt.internal.client.IScheduleItem;
import com.ibm.team.apt.internal.client.IterationPlanSequenceManager;
import com.ibm.team.apt.internal.client.PlanElement;
import com.ibm.team.apt.internal.client.ResolvedIterationPlan;
import com.ibm.team.apt.internal.client.ResolvedPlan;
import com.ibm.team.apt.internal.common.ProgressMode;
import com.ibm.team.apt.internal.common.Timespan;
import com.ibm.team.apt.internal.common.util.ItemCollection;
import com.ibm.team.apt.internal.ide.ui.common.PlanViewModel;
import com.ibm.team.apt.internal.ide.ui.common.structure.AbstractJavaPlanModelTransformer;
import com.ibm.team.apt.internal.ide.ui.common.structure.CommonGroupBySequenceDescription;
import com.ibm.team.apt.internal.ide.ui.common.structure.GroupByDescription;
import com.ibm.team.apt.internal.ide.ui.common.structure.GroupElement;
import com.ibm.team.apt.internal.ide.ui.common.structure.OwnerElement;
import com.ibm.team.apt.internal.ide.ui.common.structure.OwnerElementProgressUpdater;
import com.ibm.team.apt.internal.ide.ui.common.structure.PlanModelSequenceTransformer;
import com.ibm.team.apt.internal.ide.ui.common.structure.PlanModelTransformer;
import com.ibm.team.apt.internal.ide.ui.common.structure.ProgressModeSettingListener;
import com.ibm.team.apt.internal.ide.ui.common.structure.ProgressUpdater;
import com.ibm.team.apt.internal.ide.ui.common.structure.StaticTimeSpanFactory;
import com.ibm.team.apt.internal.ide.ui.common.structure.TimeElement;
import com.ibm.team.apt.internal.ide.ui.common.structure.TimeSpanDefinition;
import com.ibm.team.apt.internal.ide.ui.common.structure.TimeSpanFactory;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.IPlanOutlineSettings;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.Messages;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.rtc.foundation.api.ui.model.IViewEntry;
import com.ibm.team.rtc.foundation.api.ui.model.IViewModel;
import com.ibm.team.rtc.foundation.api.ui.model.IViewModelReadFunction;
import com.ibm.team.rtc.foundation.api.ui.model.IViewModelReader;
import com.ibm.team.rtc.foundation.api.ui.model.IViewModelUpdater;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Assert;

public class GroupByTeamSequenceDescription
extends CommonGroupBySequenceDescription {
    private static final GroupByDescription.PlanItemField[] PLAN_ITEM_FIELDS = new GroupByDescription.PlanItemField[]{GroupByDescription.PlanItemField.PRIORITY, GroupByDescription.PlanItemField.PROGRESS};

    public GroupByTeamSequenceDescription() {
        super(Messages.GroupByTeamSequenceDescription_LABEL);
    }

    @Override
    protected PlanModelTransformer createModelTransformer(TimeSpanFactory timeSpanFactory) {
        TimeSpanDefinition[] timeSpans = new TimeSpanDefinition[]{new TimeSpanDefinition.TimeSpanLaterToday(), new TimeSpanDefinition.TimeSpanLaterThisWeek(), new TimeSpanDefinition.TimeSpanFuture(), new TimeSpanDefinition.TimeSpanPast()};
        return new TeamScheduleGroupingTransformer(new StaticTimeSpanFactory(timeSpans, timeSpans[3], timeSpans[0]));
    }

    @Override
    public GroupByDescription.PlanItemField[] getPlanItemFields() {
        return PLAN_ITEM_FIELDS;
    }

    private class TeamScheduleGroupingTransformer
    extends PlanModelSequenceTransformer {
        private ProgressUpdater<OwnerElement> fProgressUpdater;
        private ProgressModeSettingListener fSettingsListener;
        private ItemCollection<IContributor> fTeamMembers;

        public TeamScheduleGroupingTransformer(TimeSpanFactory timeSpanFactory) {
            super(timeSpanFactory, Arrays.asList(IScheduleItem.OWNER, IScheduleItem.SCHEDULED_TIME, IScheduleItem.RESOLVED, IScheduleItem.SEQUENCE_VALUE));
            this.fProgressUpdater = new OwnerElementProgressUpdater(this);
            this.fSettingsListener = new ProgressModeSettingListener(this);
        }

        @Override
        public void inputChanged(IViewModel newModel, Object newInput) {
            PlanViewModel oldModel = this.getViewModel();
            if (oldModel != null) {
                ((IPlanOutlineSettings)oldModel.getOutlineSettings()).removeSettingsChangeListener(this.fSettingsListener);
            }
            if (newModel != null) {
                ((IPlanOutlineSettings)((PlanViewModel)newModel).getOutlineSettings()).addSettingsChangeListener(this.fSettingsListener);
            }
            super.inputChanged(newModel, newInput);
        }

        @Override
        protected void onBeginRefresh() {
            ResolvedIterationPlan plan = (ResolvedIterationPlan)this.getPlan();
            this.fTeamMembers = plan.getMemberContributors();
            super.onBeginRefresh();
        }

        @Override
        protected Collection<GroupElement[]> getDefaultGroups() {
            ResolvedIterationPlan plan = (ResolvedIterationPlan)this.getPlan();
            ArrayList<GroupElement[]> result = new ArrayList<GroupElement[]>(this.fTeamMembers.size());
            for (IContributor owner : this.fTeamMembers) {
                result.add(new OwnerElement[]{new OwnerElement((ResolvedPlan)plan, owner)});
            }
            result.add(new OwnerElement[]{new OwnerElement((ResolvedPlan)plan, this.getPlan().getNullOwner())});
            return result;
        }

        @Override
        protected Collection<GroupElement[]> getGroups(List<AbstractJavaPlanModelTransformer.ElementInfo> elementInfoPath) {
            Assert.isTrue((elementInfoPath.size() >= 1 ? 1 : 0) != 0);
            ResolvedIterationPlan plan = (ResolvedIterationPlan)this.getPlan();
            Object[] structureValues = elementInfoPath.get(0).getStructureValues();
            IContributor owner = (IContributor)structureValues[0];
            Timespan scheduledTime = (Timespan)structureValues[1];
            boolean isResolved = (Boolean)structureValues[2];
            GroupElement[] groupPath = null;
            groupPath = plan.getNullOwner().sameItemId((IItemHandle)owner) || !this.fTeamMembers.contains((Object)owner) ? new GroupElement[]{new OwnerElement((ResolvedPlan)plan, owner)} : new GroupElement[]{new OwnerElement((ResolvedPlan)plan, owner), new TimeElement(owner, this.findTimeSpan(scheduledTime, isResolved))};
            return Collections.singleton(groupPath);
        }

        protected Collection<PlanElement> getAllPlanElements() {
            ArrayList<PlanElement> result = new ArrayList<PlanElement>(super.getAllPlanElements());
            for (IContributor contributor : this.fTeamMembers) {
                IterationPlanSequenceManager sequenceManager = ((ResolvedIterationPlan)this.getPlan()).getItemSequenceManager((IContributorHandle)contributor);
                Assert.isNotNull((Object)sequenceManager);
                for (IScheduleItem fixScheduledItem : sequenceManager.getAbsences()) {
                    if (!(fixScheduledItem instanceof PlanElement)) continue;
                    result.add((PlanElement)fixScheduledItem);
                }
            }
            return result;
        }

        @Override
        public List<IViewEntry<?>> getElementsToExpandInitially() {
            return (List)this.getViewModel().readModel(new IViewModelReadFunction<List<IViewEntry<?>>, RuntimeException>(){

                public List<IViewEntry<?>> run(IViewModelReader reader) {
                    IViewEntry rootEntry = reader.getRootEntry(IViewModel.Domain.Content);
                    if (rootEntry == null) {
                        return Collections.EMPTY_LIST;
                    }
                    ItemCollection teamMembers = ((ResolvedIterationPlan)TeamScheduleGroupingTransformer.this.getPlan()).getMemberContributors();
                    ArrayList result = new ArrayList();
                    block0: for (IViewEntry ownerEntry : reader.getChildren(rootEntry)) {
                        if (!teamMembers.contains((Object)((OwnerElement)ownerEntry.getElement()).getOwner())) continue;
                        result.add(ownerEntry);
                        for (IViewEntry timespanEntry : reader.getChildren(ownerEntry)) {
                            TimeSpanDefinition timeSpan;
                            if (!timespanEntry.isVisible() || !(timeSpan = ((TimeElement)timespanEntry.getElement()).getTimeSpan()).getEndTime().after(TeamScheduleGroupingTransformer.this.getPlan().getReferenceTime()) && timeSpan != TimeSpanDefinition.UNSCHEDULED) continue;
                            result.add(timespanEntry);
                            continue block0;
                        }
                    }
                    return result;
                }
            });
        }

        @Override
        protected void doElementChanged(IPlanElementDelta delta, IViewModelUpdater updateAccessor) {
            if (this.getSettings().getProgressMode() == ProgressMode.LOAD) {
                return;
            }
            this.fProgressUpdater.processElementChanged(delta, updateAccessor);
        }

        @Override
        protected void doElementAdded(IPlanElementDelta delta, IViewModelUpdater updateAccessor) {
            if (this.getSettings().getProgressMode() == ProgressMode.LOAD) {
                return;
            }
            this.fProgressUpdater.processElementAdded(delta, updateAccessor);
        }

        @Override
        protected void doElementRemoved(IPlanElementDelta delta, IViewModelUpdater updateAccessor) {
            if (this.getSettings().getProgressMode() == ProgressMode.LOAD) {
                return;
            }
            this.fProgressUpdater.processElementRemoved(delta, updateAccessor);
        }

        @Override
        protected void doElementMoved(IPlanElementDelta removeDelta, IPlanElementDelta addDelta, IViewModelUpdater updateAccessor) {
            if (this.getSettings().getProgressMode() == ProgressMode.LOAD) {
                return;
            }
            this.fProgressUpdater.processElementMoved(removeDelta, addDelta, updateAccessor);
        }

        private IPlanOutlineSettings getSettings() {
            return (IPlanOutlineSettings)this.getViewModel().getOutlineSettings();
        }
    }
}

