/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.editor.outliner;

import com.ibm.team.apt.internal.client.IScheduleItem;
import com.ibm.team.apt.internal.client.IterationPlanSequenceManager;
import com.ibm.team.apt.internal.client.PlanElement;
import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.client.ResolvedIterationPlan;
import com.ibm.team.apt.internal.common.Timespan;
import com.ibm.team.apt.internal.common.util.ItemHashSet;
import com.ibm.team.apt.internal.ide.ui.common.structure.AbstractJavaPlanModelTransformer;
import com.ibm.team.apt.internal.ide.ui.common.structure.CommonGroupBySequenceDescription;
import com.ibm.team.apt.internal.ide.ui.common.structure.GroupElement;
import com.ibm.team.apt.internal.ide.ui.common.structure.PlanModelSequenceTransformer;
import com.ibm.team.apt.internal.ide.ui.common.structure.PlanModelTransformer;
import com.ibm.team.apt.internal.ide.ui.common.structure.TimeElement;
import com.ibm.team.apt.internal.ide.ui.common.structure.TimeSpanDefinition;
import com.ibm.team.apt.internal.ide.ui.common.structure.TimeSpanFactory;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.Messages;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.rtc.foundation.api.ui.model.IViewEntry;
import com.ibm.team.rtc.foundation.api.ui.model.IViewModel;
import com.ibm.team.rtc.foundation.api.ui.model.IViewModelReadFunction;
import com.ibm.team.rtc.foundation.api.ui.model.IViewModelReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Assert;

public class GroupByPersonalSequenceDescription
extends CommonGroupBySequenceDescription {
    public GroupByPersonalSequenceDescription() {
        super(Messages.GroupByPersonalSequenceDescription_LABEL);
    }

    @Override
    protected PlanModelTransformer createModelTransformer(TimeSpanFactory timeSpanFactory) {
        return new PersonalScheduleGroupingTransformer(timeSpanFactory);
    }

    private class PersonalScheduleGroupingTransformer
    extends PlanModelSequenceTransformer {
        public PersonalScheduleGroupingTransformer(TimeSpanFactory timeSpanFactory) {
            super(timeSpanFactory, Arrays.asList(IScheduleItem.SCHEDULED_TIME, IScheduleItem.RESOLVED, IScheduleItem.SEQUENCE_VALUE));
        }

        @Override
        protected Collection<GroupElement[]> getGroups(List<AbstractJavaPlanModelTransformer.ElementInfo> elementInfoPath) {
            Assert.isTrue((elementInfoPath.size() >= 1 ? 1 : 0) != 0);
            Object[] structureValues = elementInfoPath.get(0).getStructureValues();
            Timespan scheduledTime = (Timespan)structureValues[0];
            boolean isResolved = (Boolean)structureValues[1];
            return Collections.singleton(new GroupElement[]{new TimeElement(this.getPlanOwner(), this.findTimeSpan(scheduledTime, isResolved))});
        }

        protected Collection<PlanElement> getAllPlanElements() {
            ArrayList<PlanElement> result = new ArrayList<PlanElement>(super.getAllPlanElements());
            ItemHashSet allOwners = new ItemHashSet();
            for (PlanElement planElement : result) {
                PlanItem planItem;
                if (!(planElement instanceof PlanItem) || (planItem = (PlanItem)planElement).isAuxiliaryPlanItem()) continue;
                allOwners.add((Object)planItem.getOwner());
            }
            for (IContributor contributor : allOwners) {
                IterationPlanSequenceManager sequenceManager = ((ResolvedIterationPlan)this.getPlan()).getItemSequenceManager((IContributorHandle)contributor);
                if (sequenceManager == null) continue;
                for (IScheduleItem fixScheduledItem : sequenceManager.getAbsences()) {
                    if (!(fixScheduledItem instanceof PlanElement)) continue;
                    result.add((PlanElement)fixScheduledItem);
                }
            }
            return result;
        }

        @Override
        public List<IViewEntry<?>> getElementsToExpandInitially() {
            return (List)this.getViewModel().readModel(new IViewModelReadFunction<List<IViewEntry<?>>, RuntimeException>(){

                public List<IViewEntry<?>> run(IViewModelReader reader) {
                    IViewEntry rootEntry = reader.getRootEntry(IViewModel.Domain.Content);
                    if (rootEntry == null) {
                        return Collections.EMPTY_LIST;
                    }
                    ArrayList result = new ArrayList();
                    for (IViewEntry timespanEntry : reader.getChildren(rootEntry)) {
                        TimeSpanDefinition timeSpan;
                        if (!timespanEntry.isVisible() || !(timeSpan = ((TimeElement)timespanEntry.getElement()).getTimeSpan()).getEndTime().after(PersonalScheduleGroupingTransformer.this.getPlan().getReferenceTime()) && timeSpan != TimeSpanDefinition.UNSCHEDULED) continue;
                        result.add(timespanEntry);
                    }
                    return result;
                }
            });
        }

        private IContributor getPlanOwner() {
            IContributor currentUser = this.getPlan().getTeamRepository().loggedInContributor();
            Assert.isNotNull((Object)currentUser);
            return currentUser;
        }
    }
}

