/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.editor.outliner;

import com.ibm.team.apt.internal.ide.ui.PlanningUIPlugin;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.IUsageChangeListener;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.preference.IPreferenceStore;

public class FilterUsageStatistics {
    private static final String FILTER_USAGE_PREFERENCE = "filterUsage";
    private ListenerList fUsageChangeListeners = new ListenerList();
    private LinkedList<String> fFilterRanking = new LinkedList();

    public FilterUsageStatistics() {
        this.loadUsageList(PlanningUIPlugin.getDefault().getPreferenceStore());
    }

    public void dispose() {
        this.storeUsageList(PlanningUIPlugin.getDefault().getPreferenceStore());
    }

    public void addUsageChangeListener(IUsageChangeListener listener) {
        this.fUsageChangeListeners.add((Object)listener);
    }

    public void removeUsageChangeListener(IUsageChangeListener listener) {
        this.fUsageChangeListeners.remove((Object)listener);
    }

    public String[] getFilterHotlist(int listLength, Set<String> availableFilters, Collection<String> defaultFiltersIds) {
        HashSet<String> result = new HashSet<String>(listLength);
        Iterator filterIterator = this.fFilterRanking.iterator();
        while (result.size() < listLength && filterIterator.hasNext()) {
            String filterId = (String)filterIterator.next();
            if (!availableFilters.contains(filterId)) continue;
            result.add(filterId);
        }
        Iterator<String> defaultFilterIterator = defaultFiltersIds.iterator();
        while (result.size() < listLength && defaultFilterIterator.hasNext()) {
            String defaultFilterId = defaultFilterIterator.next();
            if (result.contains(defaultFilterId)) continue;
            result.add(defaultFilterId);
        }
        return result.toArray(new String[result.size()]);
    }

    public synchronized void clearUsage() {
        this.fFilterRanking.clear();
    }

    public synchronized void registerFilterActivated(String filterId) {
        String firstElement = this.fFilterRanking.peek();
        if (filterId.equals(firstElement)) {
            return;
        }
        this.fFilterRanking.remove(filterId);
        this.fFilterRanking.addFirst(filterId);
        this.fireRankingChangedEvent();
    }

    private void loadUsageList(IPreferenceStore preferenceStore) {
        String filterUsageString = preferenceStore.getString(FILTER_USAGE_PREFERENCE);
        if (filterUsageString != null) {
            String[] filterUsageArray;
            String[] stringArray = filterUsageArray = filterUsageString.split(",");
            int n = filterUsageArray.length;
            int n2 = 0;
            while (n2 < n) {
                String filterUsage = stringArray[n2];
                String[] usageDetails = filterUsage.split(":");
                if (usageDetails.length > 0) {
                    this.fFilterRanking.add(usageDetails[0]);
                }
                ++n2;
            }
        }
    }

    private void storeUsageList(IPreferenceStore preferenceStore) {
        StringBuilder filterUsage = new StringBuilder();
        for (String filterId : this.fFilterRanking) {
            if (filterUsage.length() > 0) {
                filterUsage.append(',');
            }
            filterUsage.append(filterId);
        }
        preferenceStore.setValue(FILTER_USAGE_PREFERENCE, filterUsage.toString());
    }

    private void fireRankingChangedEvent() {
        Object[] listeners = this.fUsageChangeListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IUsageChangeListener)listeners[i]).filterRankingChanged();
            ++i;
        }
    }
}

