/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.editor;

import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.client.wiki.Attachments;
import com.ibm.team.apt.internal.common.wiki.IWikiPageAttachment;
import com.ibm.team.apt.internal.ide.ui.PlanningUIPlugin;
import com.ibm.team.apt.internal.ide.ui.editor.Messages;
import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.repository.client.IContentManager;
import com.ibm.team.repository.common.IItemHandle;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.URI;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;

public class WikiPageAttachmentStore {
    private ListenerList fListener = new ListenerList(1);
    private static WikiPageAttachmentStore fInstance;

    private WikiPageAttachmentStore() {
    }

    public void addWikiPageAttachmentListener(IWikiPageAttachmentResolveListener listener) {
        this.fListener.add((Object)listener);
    }

    public void removeWikiPageAttachmentListener(IWikiPageAttachmentResolveListener listener) {
        this.fListener.remove((Object)listener);
    }

    protected void fireWikiPageAttachmentResolved(IWikiPageAttachment attachment) {
        Object[] listeners;
        Object[] objectArray = listeners = this.fListener.getListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            ((IWikiPageAttachmentResolveListener)object).wikiPageAttachmentResolved(attachment);
            ++n2;
        }
    }

    public void registerWikiPageAttachment(IWikiPageAttachment attachment) {
        if (WikiPageAttachmentStore.shouldDownload(attachment) && !WikiPageAttachmentStore.isDownloaded(attachment)) {
            new WikiPageContentResolver(attachment).schedule();
        }
    }

    public static synchronized WikiPageAttachmentStore getInstance() {
        if (fInstance == null) {
            fInstance = new WikiPageAttachmentStore();
        }
        return fInstance;
    }

    public static URI getFileUri(IWikiPageAttachment attachment) {
        IPath path = WikiPageAttachmentStore.getFilePath(attachment);
        return new File(path.toOSString()).toURI();
    }

    public static boolean shouldDownload(IWikiPageAttachment attachment) {
        String type = attachment.getContent().getContentType();
        return Attachments.IMAGE_CONTENT_TYPES.contains(type);
    }

    public static boolean isDownloaded(IWikiPageAttachment attachment) {
        File file = new File(WikiPageAttachmentStore.getFilePath(attachment).toOSString());
        return file.exists();
    }

    private static IPath getFilePath(IWikiPageAttachment attachment) {
        StringBuilder appendix = new StringBuilder();
        appendix.append(attachment.getItemId().getUuidValue());
        appendix.append('_');
        appendix.append(attachment.getName());
        return JazzResources.getFilePathFromConfigArea((String)PlanningUIPlugin.getPluginId(), (String)appendix.toString());
    }

    public static interface IWikiPageAttachmentResolveListener {
        public void wikiPageAttachmentResolved(IWikiPageAttachment var1);
    }

    private class WikiPageContentResolver
    extends FoundationJob {
        private final IWikiPageAttachment fAttachment;

        public WikiPageContentResolver(IWikiPageAttachment attachment) {
            super(Messages.WikiPageAttachmentStore_JOB_PAGE_ATTACHEMENT_RESOLVER);
            Assert.isNotNull((Object)attachment);
            this.fAttachment = attachment;
            this.setSystem(true);
            this.setPriority(30);
        }

        protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
            IContentManager manager = PlanningClientPlugin.getTeamRepository((IItemHandle)this.fAttachment).contentManager();
            File file = new File(WikiPageAttachmentStore.getFilePath(this.fAttachment).toOSString());
            try (FileOutputStream outStream = new FileOutputStream(file);){
                manager.retrieveContent(this.fAttachment.getContent(), (OutputStream)outStream, monitor);
            }
            WikiPageAttachmentStore.this.fireWikiPageAttachmentResolved(this.fAttachment);
            return Status.OK_STATUS;
        }
    }
}

