/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.editor;

import com.ibm.team.apt.common.IIterationPlanRecord;
import com.ibm.team.apt.internal.client.IterationPlanData;
import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.client.util.IDeferredResolver;
import com.ibm.team.apt.internal.client.wiki.Attachments;
import com.ibm.team.apt.internal.client.wiki.IResolvedWikiPageListener;
import com.ibm.team.apt.internal.client.wiki.ResolvedWikiPage;
import com.ibm.team.apt.internal.client.wiki.ResolvedWikiPageAttachment;
import com.ibm.team.apt.internal.client.wiki.WikiClient;
import com.ibm.team.apt.internal.client.wiki.WikiLinks;
import com.ibm.team.apt.internal.client.wiki.WikiManager;
import com.ibm.team.apt.internal.common.Message;
import com.ibm.team.apt.internal.common.Severity;
import com.ibm.team.apt.internal.common.util.Html;
import com.ibm.team.apt.internal.common.util.ItemArrayList;
import com.ibm.team.apt.internal.common.wiki.IWikiPageAttachment;
import com.ibm.team.apt.internal.common.wiki.IWikiPageAttachmentService;
import com.ibm.team.apt.internal.ide.core.util.TeamFuture;
import com.ibm.team.apt.internal.ide.core.util.TeamFutureAdapter;
import com.ibm.team.apt.internal.ide.core.util.TeamFutureEvent;
import com.ibm.team.apt.internal.ide.ui.PlanningUIPlugin;
import com.ibm.team.apt.internal.ide.ui.actions.IActionProvider;
import com.ibm.team.apt.internal.ide.ui.editor.AttachmentsViewer;
import com.ibm.team.apt.internal.ide.ui.editor.ClientReferenceDetector;
import com.ibm.team.apt.internal.ide.ui.editor.DeferredVariableResolver;
import com.ibm.team.apt.internal.ide.ui.editor.IInformationMessageProvider;
import com.ibm.team.apt.internal.ide.ui.editor.InformationMessageProvider;
import com.ibm.team.apt.internal.ide.ui.editor.IterationPlanEditor;
import com.ibm.team.apt.internal.ide.ui.editor.Messages;
import com.ibm.team.apt.internal.ide.ui.editor.PlanEditorPage;
import com.ibm.team.apt.internal.ide.ui.editor.StyledWikiDocument;
import com.ibm.team.apt.internal.ide.ui.editor.WikiPageAttachmentStore;
import com.ibm.team.apt.internal.ide.ui.editor.wiki.ScriptExecutor;
import com.ibm.team.apt.internal.ide.ui.editor.wiki.WikiActionGroup;
import com.ibm.team.apt.internal.ide.ui.editor.wiki.WikiDocument;
import com.ibm.team.apt.internal.ide.ui.editor.wiki.WikiPageActionGroup;
import com.ibm.team.apt.internal.ide.ui.editor.wiki.WikiPartitionScanner;
import com.ibm.team.apt.internal.ide.ui.editor.wiki.WikiViewer;
import com.ibm.team.apt.internal.ide.ui.editor.wiki.WorkItemActionGroup;
import com.ibm.team.apt.internal.ide.ui.editor.wiki.actions.AddAttachmentAction;
import com.ibm.team.apt.internal.ide.ui.editor.wiki.actions.DownloadAttachmentAction;
import com.ibm.team.apt.internal.ide.ui.editor.wiki.actions.RemoveAttachmentAction;
import com.ibm.team.apt.internal.ide.ui.util.JS;
import com.ibm.team.apt.internal.ide.ui.util.UI;
import com.ibm.team.apt.internal.ide.ui.util.UITeamFutureAdapter;
import com.ibm.team.apt.internal.ide.ui.widgets.AnimatedLoadingLabel;
import com.ibm.team.apt.internal.ide.ui.widgets.InformationViewer;
import com.ibm.team.foundation.common.URIReference;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.contentassist.ContentAssistContextProvider;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.contentassist.TeamContextProvider;
import com.ibm.team.foundation.rcp.core.hyperlinks.Hyperlinks;
import com.ibm.team.foundation.rcp.core.hyperlinks.StandardContextProvider;
import com.ibm.team.jface.itemview.MarkupUtil;
import com.ibm.team.jface.tooltip.BrowserTooltipSupport;
import com.ibm.team.jface.tooltip.TooltipSupport;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.ui.editor.TeamFormPage;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.common.internal.wiki.transformer.IItemReferenceDetector;
import com.ibm.team.workitem.common.internal.wiki.transformer.IVariableResolver;
import com.ibm.team.workitem.common.internal.wiki.transformer.Token;
import com.ibm.team.workitem.common.internal.wiki.transformer.Transformer;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemType;
import com.ibm.team.workitem.ide.ui.internal.editor.TeamSashForm;
import com.ibm.team.workitem.rcp.ui.internal.IProjectAreaContextProvider;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.help.HelpSystem;
import org.eclipse.help.IContext;
import org.eclipse.help.IContextProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolTip;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.keys.IBindingService;

public class WikiFormPage2
extends TeamFormPage
implements IActionProvider {
    final IResolvedWikiPageListener fWikiPageListener = new IResolvedWikiPageListener(){

        public void dirtyStateChanged(final boolean oldValue, final boolean newValue) {
            Control control = WikiFormPage2.this.getPartControl();
            if (control == null) {
                return;
            }
            UI.asyncExec(control, new Runnable(){

                @Override
                public void run() {
                    String name = WikiFormPage2.this.getPartName();
                    if (newValue) {
                        WikiFormPage2.this.setPartName("*" + name);
                    } else if (oldValue) {
                        WikiFormPage2.this.setPartName(name.substring(1));
                    }
                }
            });
        }

        public void attachmentAdded(ResolvedWikiPageAttachment attachment) {
            WikiFormPage2.this.fTableViewer.setInput((Object)WikiFormPage2.this.getInput().getAttachments());
        }

        public void attachmentRemoved(ResolvedWikiPageAttachment attachment) {
            WikiFormPage2.this.fTableViewer.setInput((Object)WikiFormPage2.this.getInput().getAttachments());
        }
    };
    private final ISelectionChangedListener fSelectionListener = new ISelectionChangedListener(){
        private Display fDisplay;

        public void selectionChanged(SelectionChangedEvent event) {
            if (this.fDisplay == null) {
                this.fDisplay = WikiFormPage2.this.getSite().getShell().getDisplay();
            }
            this.fDisplay.asyncExec(new Runnable(){

                @Override
                public void run() {
                    WikiFormPage2.this.updateSelectionDependantActions();
                }
            });
        }
    };
    private final ITextListener fTextListener = new ITextListener(){
        private Display fDisplay;

        public void textChanged(TextEvent event) {
            if (this.fDisplay == null) {
                this.fDisplay = WikiFormPage2.this.getSite().getShell().getDisplay();
            }
            this.fDisplay.asyncExec(new Runnable(){

                @Override
                public void run() {
                    WikiFormPage2.this.updateContentDependentActions();
                }
            });
        }
    };
    private IPropertyChangeListener fFontChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            Object data;
            String property = event.getProperty();
            if ("com.ibm.team.apt.ide.ui.iterationPlanEditor.wiki.font".equals(property) && (data = event.getNewValue()) instanceof FontData[]) {
                Font font = WikiFormPage2.this.fWikiViewer.getResources().createFont(FontDescriptor.createFrom((FontData[])((FontData[])data)));
                WikiFormPage2.this.fWikiViewer.getTextWidget().setFont(font);
            }
        }
    };
    private LocationListener fLocationListener = new LocationAdapter(){

        public void changing(LocationEvent event) {
            String query;
            int index;
            URI uri;
            if (event.location.startsWith(WikiFormPage2.JS_INVALID_LOC_EVENT)) {
                return;
            }
            if (WikiFormPage2.ABOUT_BLANK.equals(event.location)) {
                return;
            }
            if (WikiFormPage2.EDIT_CMD.equals(event.location)) {
                IterationPlanEditor planEditor = (IterationPlanEditor)WikiFormPage2.this.getEditor();
                Action action = planEditor.getAction("com.ibm.team.apt.action.pages.editPage");
                if (action != null && action.isEnabled()) {
                    WikiFormPage2.this.startEdit();
                    planEditor.updateHeaderToolBar();
                }
                event.doit = false;
                return;
            }
            try {
                uri = new URI(event.location);
            }
            catch (URISyntaxException e) {
                return;
            }
            boolean download = false;
            if (uri.getPath() != null && uri.getPath().contains(IWikiPageAttachmentService.class.getName()) && (index = (query = uri.getQuery()).lastIndexOf("itemId")) != -1) {
                String uuid = query.substring(index + 1 + "itemId".length(), query.length());
                new DownloadAttachmentAction(WikiFormPage2.this).runFromUUID(uuid);
                download = true;
                event.doit = false;
            }
            if (!download) {
                Hyperlinks.open((URI)uri, (com.ibm.team.foundation.rcp.core.hyperlinks.ContextProvider)WikiFormPage2.this.fContextProvider);
                event.doit = false;
            }
        }
    };
    private KeyListener fKeyListener = new KeyListener(){

        private void handleKeyEvent(KeyEvent e) {
            if (WikiFormPage2.this.getEditMode()) {
                return;
            }
            int type = Character.getType(e.character);
            if (type == 15) {
                return;
            }
            IPreferenceStore preferenceStore = PlanningUIPlugin.getDefault().getPreferenceStore();
            if (preferenceStore.getBoolean(WikiFormPage2.PREF_AUTO_EDIT_OFF)) {
                return;
            }
            if (!preferenceStore.getBoolean(WikiFormPage2.PREF_AUTO_EDIT_TOGGLE_MSG)) {
                MessageDialogWithToggle dialog = MessageDialogWithToggle.openYesNoQuestion((Shell)WikiFormPage2.this.getSite().getShell(), (String)Messages.WikiFormPage2_AUTO_EDIT_TITLE, (String)Messages.WikiFormPage2_AUTO_EDIT_MSG, (String)Messages.WikiFormPage2_AUTI_EDIT_TOGGLE_MSG, (boolean)true, (IPreferenceStore)preferenceStore, (String)WikiFormPage2.PREF_AUTO_EDIT_TOGGLE_MSG);
                if (dialog.getToggleState()) {
                    preferenceStore.putValue(WikiFormPage2.PREF_AUTO_EDIT_OFF, String.valueOf(dialog.getReturnCode() == 3));
                    preferenceStore.putValue(WikiFormPage2.PREF_AUTO_EDIT_TOGGLE_MSG, String.valueOf(true));
                }
                if (dialog.getReturnCode() == 3) {
                    return;
                }
            }
            String insert = String.valueOf(e.character);
            StyledText text = WikiFormPage2.this.fWikiViewer.getTextWidget();
            int offset = text.getCaretOffset();
            text.insert(insert);
            text.setCaretOffset(offset + 1);
            WikiFormPage2.this.startEdit();
            ((IterationPlanEditor)WikiFormPage2.this.getEditor()).updateHeaderToolBar();
            final ToolTip tooltip = new ToolTip(text.getShell(), 4096);
            Point point = text.getLocationAtOffset(offset + 1);
            point = text.getDisplay().map((Control)text, null, point);
            point.y += text.getLineHeight(offset + 1);
            tooltip.setLocation(point);
            tooltip.setAutoHide(true);
            tooltip.setMessage(NLS.bind((String)Messages.WikiFormPage2_AUTO_EDIT_INSERTED_CHAR, (Object)insert, (Object[])new Object[0]));
            text.getDisplay().timerExec(1000, new Runnable(){

                @Override
                public void run() {
                    tooltip.dispose();
                }
            });
            tooltip.setVisible(true);
        }

        public void keyPressed(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
            this.handleKeyEvent(e);
        }
    };
    private static final String PREF_AUTO_EDIT_OFF = "com.ibm.team.apt.internal.ide.ui.editor.WikiFormPage2.AUTO_EDIT";
    private static final String PREF_AUTO_EDIT_TOGGLE_MSG = "com.ibm.team.apt.internal.ide.ui.editor.WikiFormPage2.AUTO_EDIT_TOGGLE_MSG";
    private static final String SHOW_HINT = "com.ibm.team.apt.internal.ide.ui.editor.WikiFormPage2.SHOW_HINT";
    private static final String ABOUT_BLANK = "about:blank";
    private static final String EDIT_CMD = "jazz://startEdit/";
    private static final String JS_INVALID_LOC_EVENT = "javascript:";
    private StackLayout fLayout;
    private AnimatedLoadingLabel fLoadingLabel;
    private Browser fBrowser;
    private ScriptExecutor fScriptExecutor;
    private Composite fWikiComposite;
    private WikiViewer fWikiViewer;
    private Sash fSash;
    private Section fAttachmentsSection;
    private TableViewer fTableViewer;
    private boolean fEditMode;
    private WorkItemActionGroup fActionGroup;
    private StandardContextProvider fContextProvider = new StandardContextProvider(null);
    private InformationMessageProvider fInformationProvider;
    private IContextProvider fHelpContextProvider;
    private InternalWikiDocument fDocument;
    private IDocumentPartitioner fDocumentPartition;
    private InternalDocumentListener fDocumentListener;
    private Transformer fTransformer = new Transformer();
    private WikiPageAttachmentResolveListener fAttachmentsListener;

    public WikiFormPage2(FormEditor editor, String id, String title, boolean edit) {
        super(editor, id, title);
        this.fDocumentPartition = new FastPartitioner((IPartitionTokenScanner)new WikiPartitionScanner(), WikiPartitionScanner.Partitions.TYPES);
        this.fDocumentListener = new InternalDocumentListener();
        this.fEditMode = edit;
        this.fContextProvider.setUIContext((Object)editor.getSite());
    }

    public void setPartName(String partName) {
        super.setPartName(partName);
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        IterationPlanEditor planEditor = (IterationPlanEditor)this.getEditor();
        Menu cTabFolderMenu = planEditor.getTabFolderMenu();
        PlanEditorPage.removeCTabFolderMenu(cTabFolderMenu, parent.getChildren());
    }

    protected void createFormContent(IManagedForm form) {
        Composite body = form.getForm().getBody();
        GridLayoutFactory.fillDefaults().applyTo(body);
        final Composite parent = new Composite(body, 0);
        parent.setBackground(body.getBackground());
        GridDataFactory.fillDefaults().hint(1, 1).grab(true, true).applyTo((Control)parent);
        this.fLayout = new StackLayout();
        parent.setLayout((Layout)this.fLayout);
        this.createLoadingLabel(parent);
        this.createBrowser(parent);
        this.createViewer(parent);
        this.fActionGroup = new WikiPageActionGroup(this);
        this.fActionGroup.initActions();
        this.hookListeners();
        this.wikiDropSupport();
        this.hookContextMenu();
        this.updateStackLayout();
        TeamFuture<ResolvedWikiPage> future = new TeamFuture<ResolvedWikiPage>(){

            protected ResolvedWikiPage resolve(IProgressMonitor monitor) throws TeamRepositoryException {
                IterationPlanData iterationPlanData = ((IterationPlanEditor)WikiFormPage2.this.getEditor()).getIterationPlanData();
                IIterationPlanRecord owner = iterationPlanData.getPlanRecord();
                ITeamRepository repository = iterationPlanData.getTeamRepository();
                String wikiId = WikiFormPage2.this.getId();
                try {
                    WikiManager manager = WikiClient.getWikiManager((ITeamRepository)repository);
                    ResolvedWikiPage page = manager.findResolvedPageUsingOwner((IItemHandle)owner, wikiId, monitor);
                    return page;
                }
                catch (IOException e) {
                    throw new TeamRepositoryException((Throwable)e);
                }
            }
        };
        future.addListener(UITeamFutureAdapter.create(parent.getDisplay(), new TeamFutureAdapter<ResolvedWikiPage>((TeamFuture)future){
            private final /* synthetic */ TeamFuture val$future;
            {
                this.val$future = teamFuture;
            }

            public void resolvingDone(TeamFutureEvent<ResolvedWikiPage> event) {
                if (!parent.isDisposed()) {
                    WikiFormPage2.this.setInput((ResolvedWikiPage)this.val$future.getResult());
                }
            }
        }));
        this.setFocus();
    }

    private void createLoadingLabel(Composite parent) {
        this.fLoadingLabel = new AnimatedLoadingLabel(parent, 0);
        this.fLayout.topControl = this.fLoadingLabel;
        this.fLoadingLabel.setFont(JFaceResources.getHeaderFont());
        this.fLoadingLabel.start(0);
    }

    protected void createViewer(Composite parent) {
        TeamSashForm sash = new TeamSashForm(parent, 512);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)sash);
        sash.SPACING = 0;
        FormToolkit toolkit = this.getEditor().getToolkit();
        Composite composite = toolkit.createComposite((Composite)sash);
        GridLayoutFactory.fillDefaults().applyTo(composite);
        this.fWikiViewer = new WikiViewer(composite, null, 832, (ContentAssistContextProvider)new ContextProvider());
        try {
            this.fWikiViewer.getTextEditor().init(this.getEditorSite(), null);
        }
        catch (PartInitException partInitException) {
            // empty catch block
        }
        Font font = JFaceResources.getFont((String)"com.ibm.team.apt.ide.ui.iterationPlanEditor.wiki.font");
        this.fWikiViewer.getTextWidget().setFont(font);
        GridDataFactory.fillDefaults().hint(-1, this.fWikiViewer.getTextWidget().getLineHeight() * 3).grab(true, true).applyTo(this.fWikiViewer.getControl());
        JFaceResources.getFontRegistry().addListener(this.fFontChangeListener);
        this.fAttachmentsSection = toolkit.createSection((Composite)sash, 418);
        this.fAttachmentsSection.setText(Messages.WikiFormPage2_ATTACHMENT_SECTION_LABEL);
        this.fAttachmentsSection.setDescription(Messages.WikiFormPage2_ATTACHMENT_SECTION_DESCRIPTION);
        this.fAttachmentsSection.setTitleBarBackground(parent.getBackground());
        this.fAttachmentsSection.setTitleBarGradientBackground(parent.getBackground());
        this.fAttachmentsSection.setTitleBarBorderColor(parent.getBackground());
        composite = toolkit.createComposite((Composite)this.fAttachmentsSection);
        GridLayoutFactory.fillDefaults().applyTo(composite);
        final Table table = toolkit.createTable(composite, 68098);
        this.fTableViewer = new AttachmentsViewer(table);
        GridDataFactory.fillDefaults().grab(true, true).hint(-1, table.getHeaderHeight() + table.getItemHeight() * 2).applyTo(this.fTableViewer.getControl());
        this.fAttachmentsSection.setClient((Control)composite);
        new TooltipSupport((Control)table, true, false){

            public Object getElement(Control control, int x, int y) {
                TableItem item = table.getItem(new Point(x, y));
                if (item != null) {
                    return item.getData();
                }
                return null;
            }
        };
        this.tableDropSupport();
        this.createSectionToolbar(toolkit);
        this.createSectionContextMenu(this.fAttachmentsSection, table);
        sash.setWeights(new int[]{50, -1});
        this.fWikiComposite = sash;
    }

    private void tableDropSupport() {
        ViewerDropAdapter dropAdapter = new ViewerDropAdapter((Viewer)this.fTableViewer){

            public void dragEnter(DropTargetEvent event) {
                event.detail = 1;
                super.dragEnter(event);
            }

            public void dragOperationChanged(DropTargetEvent event) {
                event.detail = 1;
                super.dragOperationChanged(event);
            }

            public boolean performDrop(Object data) {
                if (data instanceof String[]) {
                    final List<String> list = Arrays.asList((String[])data);
                    new AddAttachmentAction(WikiFormPage2.this, WikiFormPage2.this.fAttachmentsSection){

                        public void runFromDnd() {
                            this.createAttachments(WikiFormPage2.this.getInput(), list);
                        }
                    }.runFromDnd();
                    return true;
                }
                return false;
            }

            public boolean validateDrop(Object target, int operation, TransferData transferData) {
                Object nativeToJava;
                if (operation != 1) {
                    return false;
                }
                FileTransfer transfer = FileTransfer.getInstance();
                return transfer.isSupportedType(transferData) && ((nativeToJava = transfer.nativeToJava(transferData)) == null || nativeToJava instanceof String[]);
            }
        };
        this.fTableViewer.addDropSupport(1, new Transfer[]{FileTransfer.getInstance()}, (DropTargetListener)dropAdapter);
    }

    private void createSectionContextMenu(Section section, Table table) {
        MenuManager menu = new MenuManager();
        menu.add((IAction)new AddAttachmentAction(this, section));
        menu.add((IAction)new DownloadAttachmentAction(this));
        menu.add((IAction)new RemoveAttachmentAction(this, section));
        table.setMenu(menu.createContextMenu((Control)table));
    }

    private void createSectionToolbar(FormToolkit toolkit) {
        Composite textClient = new Composite((Composite)this.fAttachmentsSection, 0);
        textClient.setBackground(null);
        GridLayoutFactory.swtDefaults().numColumns(2).equalWidth(false).margins(0, 0).applyTo(textClient);
        Label filler = new Label(textClient, 0);
        filler.setBackground(null);
        filler.setForeground(this.fAttachmentsSection.getTitleBarForeground());
        GridDataFactory.swtDefaults().align(4, 4).grab(true, false).span(1, 1).applyTo((Control)filler);
        ToolBarManager manager = new ToolBarManager(0x800000);
        manager.add((IAction)new AddAttachmentAction(this, this.fAttachmentsSection));
        manager.add((IAction)new RemoveAttachmentAction(this, this.fAttachmentsSection));
        ToolBar toolBar = manager.createControl(textClient);
        toolkit.adapt((Composite)toolBar);
        toolBar.setBackground(null);
        GridDataFactory.swtDefaults().align(131072, 128).grab(false, false).span(1, 1).applyTo((Control)toolBar);
        this.fAttachmentsSection.setTextClient((Control)textClient);
    }

    protected void createBrowser(Composite parent) {
        this.fBrowser = new Browser(parent, 0);
        this.fScriptExecutor = new ScriptExecutor(this.fBrowser);
        this.fAttachmentsListener = new WikiPageAttachmentResolveListener();
        WikiPageAttachmentStore.getInstance().addWikiPageAttachmentListener(this.fAttachmentsListener);
        this.fBrowser.addLocationListener(this.fLocationListener);
        this.fBrowser.addStatusTextListener(Bug46316.STATUS_LISTENER(this.getEditor()));
        new BrowserTooltipSupport(this.fBrowser, true, false);
    }

    private void hookListeners() {
        Assert.isNotNull((Object)((Object)this.fWikiViewer));
        this.fWikiViewer.getSelectionProvider().addSelectionChangedListener(this.fSelectionListener);
        this.fWikiViewer.addTextListener(this.fTextListener);
    }

    private void hookContextMenu() {
        MenuManager manager = new MenuManager();
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                WikiFormPage2.this.fActionGroup.fillContextMenu(manager);
            }
        });
        Menu menu = manager.createContextMenu(this.fWikiViewer.getControl());
        this.fWikiViewer.getControl().setMenu(menu);
    }

    private void wikiDropSupport() {
        ViewerDropAdapter dropAdapter = new ViewerDropAdapter((Viewer)this.fWikiViewer){
            private boolean fLink;
            {
                this.fLink = true;
            }

            public void dragEnter(DropTargetEvent event) {
                this.doDragChanged(event);
            }

            public void dragOperationChanged(DropTargetEvent event) {
                this.doDragChanged(event);
            }

            private void doDragChanged(DropTargetEvent event) {
                event.detail = (event.operations & 1) != 0 ? 1 : ((event.operations & 4) != 0 ? 4 : 16);
            }

            public boolean validateDrop(Object target, int operation, TransferData transferType) {
                IStructuredSelection selection = (IStructuredSelection)LocalSelectionTransfer.getTransfer().getSelection();
                if (selection != null) {
                    Object[] elements;
                    Object[] objectArray = elements = selection.toArray();
                    int n = elements.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object element = objectArray[n2];
                        if (Hyperlinks.handles((Object)element)) {
                            return true;
                        }
                        if (element instanceof ResolvedWikiPageAttachment) {
                            return true;
                        }
                        ++n2;
                    }
                }
                return false;
            }

            public boolean performDrop(Object data) {
                Object[] elements;
                if (!(data instanceof IStructuredSelection)) {
                    return false;
                }
                IStructuredSelection selection = (IStructuredSelection)data;
                if (selection.isEmpty()) {
                    return false;
                }
                StyledText widget = WikiFormPage2.this.fWikiViewer.getTextWidget();
                if (widget == null || widget.isDisposed()) {
                    return false;
                }
                Object[] objectArray = elements = selection.toArray();
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    if (element instanceof ResolvedWikiPageAttachment) {
                        String asWiki = Attachments.asWiki((ResolvedWikiPageAttachment)((ResolvedWikiPageAttachment)element));
                        widget.insert(asWiki);
                    } else if (element instanceof IWorkItem) {
                        IWorkItem item = (IWorkItem)element;
                        List<String> properties = this.fLink ? Arrays.asList(IWorkItem.PROJECT_AREA_PROPERTY, IWorkItem.ID_PROPERTY, IWorkItem.TYPE_PROPERTY, IWorkItem.SUMMARY_PROPERTY) : Arrays.asList(IWorkItem.PROJECT_AREA_PROPERTY, IWorkItem.ID_PROPERTY, IWorkItem.TYPE_PROPERTY);
                        item = this.blockingPropertiesEnsure(item, properties);
                        IWorkItemType workItemType = this.blockingGetWorkItemType(item);
                        String link = this.fLink ? WikiLinks.link((IWorkItem)item, (IWorkItemType)workItemType) : WikiLinks.staticLink((IWorkItem)item, (IWorkItemType)workItemType);
                        widget.insert(link);
                    } else {
                        URIReference reference = this.blockingURICreate(element);
                        if (reference == null) {
                            return false;
                        }
                        URI uri = reference.getURI();
                        if (element instanceof IItemHandle) {
                            Location location = Location.itemLocation((IItemHandle)((IItemHandle)element), null);
                            uri = location.toRelativeUri();
                        }
                        String link = WikiLinks.link((Object)uri.toASCIIString(), (Object)reference.getName());
                        widget.insert(link);
                    }
                    ++n2;
                }
                return true;
            }

            private URIReference blockingURICreate(final Object object) {
                try {
                    return ((IterationPlanEditor)WikiFormPage2.this.getEditor()).blockingResolve(new IDeferredResolver<URIReference>(){

                        public URIReference resolve(IProgressMonitor monitor) throws TeamRepositoryException {
                            return Hyperlinks.create((Object)object, (IProgressMonitor)monitor);
                        }
                    });
                }
                catch (TeamRepositoryException e) {
                    return null;
                }
            }

            private IWorkItemType blockingGetWorkItemType(final IWorkItem workItem) {
                try {
                    return ((IterationPlanEditor)WikiFormPage2.this.getEditor()).blockingResolve(new IDeferredResolver<IWorkItemType>(){

                        public IWorkItemType resolve(IProgressMonitor monitor) throws TeamRepositoryException {
                            IWorkItemClient client = PlanningClientPlugin.getWorkItemClient((IItemHandle)workItem);
                            String identifier = workItem.getWorkItemType();
                            IWorkItemType type = client.findCachedWorkItemType(workItem.getProjectArea(), identifier);
                            if (type == null) {
                                type = client.findWorkItemType(workItem.getProjectArea(), identifier, monitor);
                            }
                            return type;
                        }
                    });
                }
                catch (TeamRepositoryException e) {
                    return null;
                }
            }

            private <T extends IItem> T blockingUpgrade(final T item, final List properties) {
                try {
                    return (T)((IItem)((IterationPlanEditor)WikiFormPage2.this.getEditor()).blockingResolve(new IDeferredResolver<T>(){

                        public T resolve(IProgressMonitor monitor) throws TeamRepositoryException {
                            IItemManager manager = PlanningClientPlugin.getTeamRepository((IItemHandle)item).itemManager();
                            IItem resolved = manager.fetchPartialItem((IItemHandle)item, 0, (Collection)properties, monitor);
                            return resolved;
                        }
                    }));
                }
                catch (TeamRepositoryException e) {
                    return null;
                }
            }

            private <T extends IItem> T blockingPropertiesEnsure(T item, List<String> properties) {
                ArrayList<String> list = new ArrayList<String>(properties);
                Iterator<String> iter = list.iterator();
                while (iter.hasNext()) {
                    if (!item.isPropertySet(iter.next())) continue;
                    iter.remove();
                }
                if (!properties.isEmpty()) {
                    item = this.blockingUpgrade(item, list);
                }
                return item;
            }
        };
        DropTarget target = new DropTarget(this.fWikiViewer.getControl(), 21);
        target.setTransfer(new Transfer[]{LocalSelectionTransfer.getTransfer()});
        target.addDropListener((DropTargetListener)dropAdapter);
    }

    protected void updateStackLayout() {
        Assert.isNotNull((Object)((Object)this.fWikiViewer));
        Assert.isNotNull((Object)this.fBrowser);
        this.fLayout.topControl = this.getInput() == null ? this.fLoadingLabel : (this.fEditMode ? this.fWikiComposite : this.fBrowser);
        ((IterationPlanEditor)this.getEditor()).setBusy((IFormPage)this, this.fLayout.topControl == this.fLoadingLabel);
        Composite parent = this.getManagedForm().getForm().getBody();
        parent.layout(new Control[]{this.fLayout.topControl});
        this.setFocus();
    }

    public void setFocus() {
        if (this.fEditMode) {
            if (this.fWikiViewer != null && !this.fWikiViewer.getControl().isDisposed()) {
                this.fWikiViewer.getControl().setFocus();
            }
        } else if (this.fBrowser != null && !this.fBrowser.isDisposed()) {
            this.fBrowser.setFocus();
        }
    }

    public void dispose() {
        super.dispose();
        if (this.fWikiViewer != null) {
            this.fWikiViewer.getSelectionProvider().removeSelectionChangedListener(this.fSelectionListener);
            this.fWikiViewer.removeTextListener(this.fTextListener);
            IUndoManager undoManager = this.fWikiViewer.getUndoManager();
            if (undoManager != null) {
                undoManager.disconnect();
            }
            JFaceResources.getFontRegistry().removeListener(this.fFontChangeListener);
        }
        if (this.fDocument != null) {
            this.fDocumentPartition.disconnect();
            this.fDocument.setDocumentPartitioner(null);
            this.fDocument.getPage().removeListener(this.fWikiPageListener);
        }
        if (this.fAttachmentsListener != null) {
            WikiPageAttachmentStore.getInstance().removeWikiPageAttachmentListener(this.fAttachmentsListener);
        }
    }

    public WikiViewer getViewer() {
        return this.fWikiViewer;
    }

    public ResolvedWikiPage getWikiPage() {
        if (this.fDocument == null) {
            return null;
        }
        return this.fDocument.getPage();
    }

    public void setInput(ResolvedWikiPage page) {
        this.update(page);
        IterationPlanData data = ((IterationPlanEditor)this.getEditor()).getIterationPlanData();
        data.addResolvedWikiPage(page);
        if (this.getEditMode()) {
            this.startEdit();
        } else {
            this.stopEdit();
        }
    }

    void update(ResolvedWikiPage page) {
        if (this.fDocument != null) {
            this.fDocumentPartition.disconnect();
            this.fDocument.setDocumentPartitioner(WikiPartitionScanner.Partitions.WIKI_PARTITING, null);
            this.fDocument.getPage().removeListener(this.fWikiPageListener);
            this.fWikiViewer.getUndoManager().disconnect();
            this.fDocument.removeDocumentListener(this.fDocumentListener);
        }
        this.fDocument = new InternalWikiDocument(page, this.fTransformer);
        this.fDocument.setDocumentPartitioner(WikiPartitionScanner.Partitions.WIKI_PARTITING, this.fDocumentPartition);
        this.fDocument.getPage().addListener(this.fWikiPageListener);
        this.fDocumentPartition.connect((IDocument)this.fDocument);
        this.fWikiViewer.setDocument((IDocument)this.fDocument, (IAnnotationModel)new AnnotationModel());
        this.fWikiViewer.getUndoManager().connect((ITextViewer)this.fWikiViewer);
        this.fDocument.addDocumentListener(this.fDocumentListener);
        this.fTableViewer.setInput((Object)page.getAttachments());
        UI.hookHelpListener((Control)this.getManagedForm().getForm(), WikiFormPage2.getHelpContextId(page));
    }

    private static String getHelpContextId(ResolvedWikiPage page) {
        if ("overview".equals(page.getWikiName())) {
            return "com.ibm.team.apt.ide.ui.page_overview";
        }
        return "com.ibm.team.apt.ide.ui.page_iterationPlan";
    }

    public WikiDocument getInput2() {
        return this.fDocument;
    }

    public ResolvedWikiPage getInput() {
        if (this.fDocument == null) {
            return null;
        }
        return this.fDocument.getPage();
    }

    public void aboutToSave() {
        if (this.fDocument == null) {
            return;
        }
        this.fDocument.writeToWikiPage();
    }

    public void startEdit() {
        this.fEditMode = true;
        this.fActionGroup.setContext(WikiActionGroup.EDIT);
        this.fActionGroup.updateActions();
        this.updateStackLayout();
        this.fDocumentListener.reset();
        this.presentEditingHint();
    }

    private void presentEditingHint() {
        final IPreferenceStore preferences = PlanningUIPlugin.getDefault().getPreferenceStore();
        if (preferences == null || !preferences.getBoolean(SHOW_HINT) || this.getInput2().getLength() == 0) {
            final String helpLink = String.valueOf(WikiFormPage2.class.getName()) + "help";
            String keyBinding = null;
            IBindingService service = (IBindingService)this.getSite().getService(IBindingService.class);
            if (service != null) {
                keyBinding = service.getBestActiveBindingFormattedFor("org.eclipse.ui.edit.text.contentAssist.proposals");
            }
            if (this.fInformationProvider == null) {
                this.fInformationProvider = new InformationMessageProvider((IFormPage)this, ((IterationPlanEditor)this.getEditor()).getInformationViewer());
                this.fInformationProvider.addInformationMessageListener(new InformationViewer.IInformationMessageListener(){

                    @Override
                    public void clicked(Object element, String text) {
                        ResolvedWikiPage page;
                        if (helpLink.equals(text) && (page = WikiFormPage2.this.getInput()) != null) {
                            String contextId = WikiFormPage2.getHelpContextId(page);
                            WikiFormPage2.this.getSite().getWorkbenchWindow().getWorkbench().getHelpSystem().displayHelp(contextId);
                        }
                    }

                    @Override
                    public void closed(Object element) {
                        if (preferences != null) {
                            preferences.putValue(WikiFormPage2.SHOW_HINT, String.valueOf(true));
                        }
                    }
                });
            }
            Message message = keyBinding != null ? new Message(NLS.bind((String)Messages.WikiFormPage2_HINT_EDIT_PAGES, (Object)keyBinding, (Object[])new Object[]{helpLink}), Severity.INFO) : new Message(NLS.bind((String)Messages.WikiFormPage2_HINT_EDIT_PAGES_NO_SHORT_CUT, (Object)helpLink, (Object[])new Object[0]), Severity.INFO);
            this.fInformationProvider.addMessage(message);
        }
    }

    public void stopEdit() {
        this.fEditMode = false;
        this.fActionGroup.setContext(WikiActionGroup.VIEW);
        this.fActionGroup.updateActions();
        if (this.fDocumentListener.hasChanges() || this.fLayout.topControl == this.fLoadingLabel) {
            final Display display = this.fBrowser.getDisplay();
            BusyIndicator.showWhile((Display)display, (Runnable)new Runnable(){

                @Override
                public void run() {
                    final boolean hasContent = WikiFormPage2.this.fDocument.getLength() > 0;
                    final StringBuilder xhtml = new StringBuilder(hasContent ? WikiFormPage2.this.fDocument.transform() : NLS.bind((String)"<span style=\"color: rgb(128, 128, 128);\">&lt;{0} (<a href=\"{1}\">{2}</a>)&gt;</span>", (Object)Messages.WikiFormPage2_DEFAULT_PAGE_CONTENT, (Object[])new Object[]{WikiFormPage2.EDIT_CMD, Messages.WikiFormPage2_START_EDIT_TEXT}));
                    display.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!hasContent) {
                                FontData data = JFaceResources.getFont((String)"com.ibm.team.apt.ide.ui.iterationPlanEditor.wiki.font").getFontData()[0];
                                StringBuilder css = new StringBuilder(256);
                                css.append("body { " + MarkupUtil.getFont((String)data.getName(), (int)data.getHeight(), (int)data.getStyle()) + " }");
                                int index = xhtml.indexOf("<head>");
                                if (index > 0) {
                                    String string = "<style type=\"text/css\">";
                                    xhtml.insert(index += 6, "<style type=\"text/css\">");
                                    xhtml.insert(index += "<style type=\"text/css\">".length(), css);
                                    xhtml.insert(index += css.length(), "</style>");
                                } else {
                                    index = 0;
                                    String string = "<head><style type=\"text/css\">";
                                    xhtml.insert(index, "<head><style type=\"text/css\">");
                                    xhtml.insert(index += "<head><style type=\"text/css\">".length(), css);
                                    xhtml.insert(index += css.length(), "</style></head>");
                                }
                            }
                            WikiFormPage2.this.fBrowser.setText(xhtml.toString());
                        }
                    });
                    WikiFormPage2.this.fScriptExecutor.schedule();
                }
            });
        }
        this.updateStackLayout();
        if (this.fInformationProvider != null) {
            this.fInformationProvider.clear();
        }
    }

    public Object getAdapter(Class adapter) {
        if (IInformationMessageProvider.class.isAssignableFrom(adapter)) {
            return this.fInformationProvider;
        }
        if (IContextProvider.class.isAssignableFrom(adapter)) {
            if (this.fHelpContextProvider == null) {
                this.fHelpContextProvider = new WikiPageContextProvider();
            }
            return this.fHelpContextProvider;
        }
        return super.getAdapter(adapter);
    }

    Browser getBrowser() {
        return this.fBrowser;
    }

    public TableViewer getAttachmentsViewer() {
        return this.fTableViewer;
    }

    public boolean getEditMode() {
        return this.fEditMode;
    }

    @Override
    public Action getAction(String id) {
        if (this.fActionGroup != null) {
            return this.fActionGroup.getAction(id);
        }
        return null;
    }

    private void updateContentDependentActions() {
        this.fActionGroup.updateActions(ActionFactory.FIND.getId(), "org.eclipse.ui.edit.findNext", "org.eclipse.ui.edit.findPrevious", ActionFactory.SELECT_ALL.getId(), "org.eclipse.ui.edit.text.contentAssist.proposals");
    }

    private void updateSelectionDependantActions() {
        this.fActionGroup.updateActions(ActionFactory.COPY.getId(), ActionFactory.CUT.getId(), "com.ibm.team.apt.actions.iterationPlan.wiki.createWorkItem");
    }

    private static final class Bug46316 {
        public static final String STATUS = "jazz://wiki/save";
        public static final Html.Attribute LOAD_KEYS = new Html.Attribute("onload", "keys()");
        public static final String KEYS = "function initPage(){if(navigator.appVersion.indexOf(\"MSIE\") < 0){return;}document.onkeyup = handleKeyUp;document.onkeydown= handleKeyDown;var isCtrl;function handleKeyDown(){var keyCode = event.keyCode;switch(keyCode){case 17:isCtrl= true;break;case 83:if(isCtrl){window.status= 'jazz://wiki/save';window.status= 'done';}break;}}function handleKeyUp(){var keyCode = event.keyCode;switch(keyCode){case 17:isCtrl= false;break;}}}\n";

        private Bug46316() {
        }

        public static StatusTextListener STATUS_LISTENER(final FormEditor editor) {
            return new StatusTextListener(){

                public void changed(StatusTextEvent event) {
                    if (Bug46316.STATUS.equals(event.text) && editor.isDirty()) {
                        editor.doSave((IProgressMonitor)new NullProgressMonitor());
                    }
                }
            };
        }
    }

    private class ContextProvider
    extends TeamContextProvider
    implements IProjectAreaContextProvider {
        private ContextProvider() {
        }

        public ITeamRepository getTeamRepository() {
            ResolvedWikiPage input = WikiFormPage2.this.getInput();
            return PlanningClientPlugin.getTeamRepository((IItemHandle)input.getWikiPage());
        }

        public IProjectAreaHandle getProjectArea() {
            return WikiFormPage2.this.getInput().getProjectArea();
        }
    }

    private class InternalDocumentListener
    implements IDocumentListener {
        private boolean fChanges = false;

        private InternalDocumentListener() {
        }

        public void reset() {
            this.fChanges = false;
        }

        public boolean hasChanges() {
            return this.fChanges;
        }

        public void documentChanged(DocumentEvent event) {
            this.fChanges = true;
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
        }
    }

    private class InternalWikiDocument
    extends StyledWikiDocument {
        private DeferredVariableResolver fVariableResolver;

        public InternalWikiDocument(ResolvedWikiPage page, Transformer transformer) {
            super(page, transformer);
            ITeamRepository repository = PlanningClientPlugin.getTeamRepository((IItemHandle)page.getWikiPage());
            IItemManager itemManager = repository.itemManager();
            transformer.setItemReferenceDetector((IItemReferenceDetector)new ClientReferenceDetector(page));
            this.fVariableResolver = new DeferredVariableResolver(DeferredVariableResolver.Mode.CollectedDispatch, itemManager, WikiFormPage2.this.fScriptExecutor);
            transformer.setVariableResolver((IVariableResolver)this.fVariableResolver);
            if ("1.0".equals(this.getPage().getWikiPage().getVersion())) {
                StringBuilder buffer = new StringBuilder();
                buffer.append(Token.XHTML_START.wiki);
                buffer.append(this.getPage().getContent2());
                buffer.append(Token.XHTML_END.wiki);
                this.internalSet(buffer.toString());
            }
        }

        @Override
        protected void insertScripts(StringBuilder buffer) {
            Html.append((CharSequence)buffer, (CharSequence)"function initPage(){if(navigator.appVersion.indexOf(\"MSIE\") < 0){return;}document.onkeyup = handleKeyUp;document.onkeydown= handleKeyDown;var isCtrl;function handleKeyDown(){var keyCode = event.keyCode;switch(keyCode){case 17:isCtrl= true;break;case 83:if(isCtrl){window.status= 'jazz://wiki/save';window.status= 'done';}break;}}function handleKeyUp(){var keyCode = event.keyCode;switch(keyCode){case 17:isCtrl= false;break;}}}\n");
        }

        @Override
        public String transform(int offset, int length) throws BadLocationException {
            String result = super.transform(offset, length);
            if (result == null) {
                return null;
            }
            this.fVariableResolver.resolve();
            return this.getStyledDocument(result);
        }

        private void writeToWikiPage() {
            if (!this.getPage().isDirty()) {
                return;
            }
            this.getPage().setContent2(this.get());
        }
    }

    private class WikiPageAttachmentResolveListener
    implements WikiPageAttachmentStore.IWikiPageAttachmentResolveListener {
        private StringBuilder fScript = new StringBuilder();

        private WikiPageAttachmentResolveListener() {
        }

        @Override
        public void wikiPageAttachmentResolved(IWikiPageAttachment attachment) {
            ResolvedWikiPage input = WikiFormPage2.this.getInput();
            if (input == null) {
                return;
            }
            ItemArrayList list = new ItemArrayList((Collection)Attachments.getAttachments((List)input.getAttachments()));
            if (!list.contains((Object)attachment)) {
                return;
            }
            URI uri = WikiPageAttachmentStore.getFileUri(attachment);
            String script = this.script(attachment, uri);
            WikiFormPage2.this.fScriptExecutor.post(script);
        }

        protected String script(IWikiPageAttachment attachment, URI uri) {
            this.fScript.setLength(0);
            this.fScript.append("updateImage(");
            this.fScript.append('\'');
            this.fScript.append(attachment.getItemId().getUuidValue());
            this.fScript.append('\'');
            this.fScript.append(',');
            this.fScript.append('\'');
            this.fScript.append(JS.escape(uri.toASCIIString()));
            this.fScript.append('\'');
            this.fScript.append(");");
            return this.fScript.toString();
        }
    }

    private class WikiPageContextProvider
    implements IContextProvider {
        private WikiPageContextProvider() {
        }

        public IContext getContext(Object target) {
            ResolvedWikiPage input = WikiFormPage2.this.getInput();
            if (input != null) {
                String contextId = WikiFormPage2.getHelpContextId(input);
                return HelpSystem.getContext((String)contextId);
            }
            return null;
        }

        public int getContextChangeMask() {
            return 0;
        }

        public String getSearchExpression(Object target) {
            return null;
        }
    }
}

