/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.editor;

import com.ibm.icu.text.Collator;
import com.ibm.team.apt.internal.common.plantype.IParameter;
import com.ibm.team.apt.internal.common.plantype.IViewModeDescription;
import com.ibm.team.apt.internal.common.process.ConfigurationElementFactory;
import com.ibm.team.apt.internal.ide.ui.ImagePool;
import com.ibm.team.apt.internal.ide.ui.PlanningUIPlugin;
import com.ibm.team.apt.internal.ide.ui.editor.Messages;
import com.ibm.team.apt.internal.ide.ui.jface.CheckboxListViewer;
import com.ibm.team.apt.internal.ide.ui.jface.ConfigurationUIProvider;
import com.ibm.team.apt.internal.ide.ui.util.UI;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.CollatorCache;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.client.internal.util.ClientUtils;
import com.ibm.team.workitem.common.internal.workflow.WorkflowManager;
import com.ibm.team.workitem.common.model.IWorkItemType;
import com.ibm.team.workitem.common.workflow.IWorkflowInfo;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class TaskboardConfigurationUI
implements ConfigurationUIProvider.IConfigurationUI {
    private static final String TASKBOARD_WORKFLOW_ID_PARAMETER_KEY = "TASKBOARD_WORKFLOW_ID";
    private final IProjectArea fProjectArea;
    private IViewModeDescription fViewMode;
    private CheckboxListViewer.ImageDrawingStrategy fDrawingStrategy;

    public TaskboardConfigurationUI(IProjectArea projectArea) {
        this.fProjectArea = projectArea;
    }

    public void setViewMode(IViewModeDescription viewMode) {
        this.fViewMode = viewMode;
    }

    IViewModeDescription getViewMode() {
        return this.fViewMode;
    }

    @Override
    public CheckboxListViewer.IDrawingStrategy getDrawingStrategy(Object element) {
        if (this.fDrawingStrategy == null) {
            this.fDrawingStrategy = new CheckboxListViewer.ImageDrawingStrategy(ImagePool.EDIT_DISABLED, ImagePool.EDIT_ENABLED);
        }
        return this.fDrawingStrategy;
    }

    @Override
    public String getText(Object element) {
        return null;
    }

    @Override
    public void configure(Object element, Shell shell) {
        final IWorkflowInfo[][] workflowInfos = new IWorkflowInfo[1][];
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(Messages.TaskboardConfigurationUI_WorkflowResolvingProgressMessage, -1);
                    try {
                        try {
                            workflowInfos[0] = TaskboardConfigurationUI.this.getWorkflows(monitor);
                        }
                        catch (TeamRepositoryException e) {
                            PlanningUIPlugin.log(e);
                            monitor.done();
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            PlanningUIPlugin.log(e);
        }
        catch (InterruptedException e) {
            PlanningUIPlugin.log(e);
        }
        if (workflowInfos[0] == null) {
            return;
        }
        TaskboardConfigurationDialog dialog = new TaskboardConfigurationDialog(shell, this.fViewMode, workflowInfos[0]);
        if (dialog.open() == 0) {
            IWorkflowInfo selectedWorkflow = dialog.getSelectedWorkflow();
            IParameter[] parameters = this.fViewMode.getParameters();
            if (selectedWorkflow == null) {
                int index = TaskboardConfigurationUI.getParameterIndex(TASKBOARD_WORKFLOW_ID_PARAMETER_KEY, parameters);
                if (index >= 0) {
                    if (parameters.length == 1) {
                        parameters = new IParameter[]{};
                    } else {
                        IParameter[] parameters2 = new IParameter[parameters.length - 1];
                        int n = 0;
                        int i = 0;
                        while (i < parameters.length) {
                            if (i != index) {
                                parameters2[n] = parameters[i];
                                ++n;
                            }
                            ++i;
                        }
                    }
                }
            } else {
                int index = TaskboardConfigurationUI.getParameterIndex(TASKBOARD_WORKFLOW_ID_PARAMETER_KEY, parameters);
                if (index >= 0) {
                    parameters[index].setValue(selectedWorkflow.getIdentifier());
                } else {
                    IParameter[] parameters2 = new IParameter[parameters.length + 1];
                    System.arraycopy(parameters, 0, parameters2, 0, parameters.length);
                    parameters2[parameters.length] = TaskboardConfigurationUI.taskboardParameter(selectedWorkflow.getIdentifier());
                    parameters = parameters2;
                }
            }
            this.fViewMode.setParameters(parameters);
        }
    }

    private IWorkflowInfo[] getWorkflows(IProgressMonitor monitor) throws TeamRepositoryException {
        IWorkItemClient workItemClient = (IWorkItemClient)ClientUtils.getClientLibrary((IItemHandle)this.fProjectArea, IWorkItemClient.class);
        HashSet<String> typeCategories = new HashSet<String>();
        List workItemTypes = workItemClient.findWorkItemTypes((IProjectAreaHandle)this.fProjectArea, monitor);
        for (IWorkItemType workItemType : workItemTypes) {
            typeCategories.add(workItemType.getCategory());
        }
        WorkflowManager workflowManager = (WorkflowManager)workItemClient.getWorkflowManager();
        HashSet<String> workflowIds = new HashSet<String>();
        for (String typeCategory : typeCategories) {
            String newWorkflowId = workflowManager.getWorkflowIdForCategory((IProjectAreaHandle)this.fProjectArea, typeCategory, false, monitor);
            workflowIds.add(newWorkflowId);
        }
        ArrayList<IWorkflowInfo> workflowInfos = new ArrayList<IWorkflowInfo>();
        for (String workflowId : workflowIds) {
            IWorkflowInfo workflow;
            if (workflowId == null || (workflow = workflowManager.getWorkflowInfo((IProjectAreaHandle)this.fProjectArea, workflowId, true, monitor)) == null) continue;
            workflowInfos.add(workflow);
        }
        IWorkflowInfo[] result = workflowInfos.toArray(new IWorkflowInfo[workflowInfos.size()]);
        Arrays.sort(result, new Comparator<IWorkflowInfo>(){
            Collator collator = CollatorCache.getInstance();

            @Override
            public int compare(IWorkflowInfo o1, IWorkflowInfo o2) {
                return this.collator.compare(o1.getName(), o2.getName());
            }
        });
        return result;
    }

    private static int getParameterIndex(String key, IParameter[] parameters) {
        int i = 0;
        while (i < parameters.length) {
            if (key.equals(parameters[i].getKey())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static IParameter taskboardParameter(String value) {
        IParameter parameter = (IParameter)ConfigurationElementFactory.emptyInstance(IParameter.class);
        parameter.setKey(TASKBOARD_WORKFLOW_ID_PARAMETER_KEY);
        parameter.setValue(value);
        return parameter;
    }

    private static final class TaskboardConfigurationDialog
    extends Dialog {
        private final IWorkflowInfo[] fWorkflowInfos;
        private final IViewModeDescription fViewMode;
        private IWorkflowInfo fSelectedWorkflow;

        protected TaskboardConfigurationDialog(Shell parentShell, IViewModeDescription viewMode, IWorkflowInfo[] workflowInfos) {
            super(parentShell);
            this.fViewMode = viewMode;
            this.fWorkflowInfos = workflowInfos;
            this.setShellStyle(67696);
        }

        public IWorkflowInfo getSelectedWorkflow() {
            return this.fSelectedWorkflow;
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            newShell.setText(Messages.TaskboardConfigurationUI_DialogTitle);
        }

        protected Control createDialogArea(Composite parent) {
            Composite result = new Composite(parent, 0);
            result.setLayoutData((Object)new GridData(4, 4, true, true));
            result.setLayout((Layout)new GridLayout(1, false));
            Group columnsConfiguration = new Group(result, 0);
            columnsConfiguration.setLayoutData((Object)new GridData(4, 4, true, false));
            columnsConfiguration.setLayout((Layout)new GridLayout(1, false));
            columnsConfiguration.setText(Messages.TaskboardConfigurationUI_ColumsGroup_Title);
            Button stateGroupButton = new Button((Composite)columnsConfiguration, 16);
            stateGroupButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
            stateGroupButton.setText(Messages.TaskboardConfigurationUI_ColumnsGroup_StateGroupOption);
            Button workflow = new Button((Composite)columnsConfiguration, 16);
            workflow.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
            workflow.setText(Messages.TaskboardConfigurationUI_ColumnsGroup_AllStatesOption);
            Composite workflowSelector = new Composite((Composite)columnsConfiguration, 0);
            GridData layoutData = new GridData(4, 4, true, true);
            layoutData.horizontalIndent = 15;
            workflowSelector.setLayoutData((Object)layoutData);
            GridLayout layout = new GridLayout(2, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            workflowSelector.setLayout((Layout)layout);
            final Label comboLabel = new Label(workflowSelector, 0);
            comboLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
            comboLabel.setText(Messages.TaskboardConfigurationUI_ColumnsGroup_WorkflowDropDownLabel);
            final Combo combo = new Combo(workflowSelector, 12);
            layoutData = new GridData(4, 0x1000000, true, false);
            layoutData.widthHint = this.convertWidthInCharsToPixels(40);
            combo.setLayoutData((Object)layoutData);
            String[] workflows = new String[this.fWorkflowInfos.length];
            int i = 0;
            while (i < this.fWorkflowInfos.length) {
                workflows[i] = this.fWorkflowInfos[i].getName();
                ++i;
            }
            combo.setItems(workflows);
            IParameter[] parameters = this.fViewMode.getParameters();
            int index = TaskboardConfigurationUI.getParameterIndex(TaskboardConfigurationUI.TASKBOARD_WORKFLOW_ID_PARAMETER_KEY, this.fViewMode.getParameters());
            if (index < 0) {
                stateGroupButton.setSelection(true);
                workflow.setSelection(false);
                combo.select(0);
                this.fSelectedWorkflow = null;
            } else {
                stateGroupButton.setSelection(false);
                workflow.setSelection(true);
                int workflowIndex = this.getWorfklowIndex(parameters[index].getValue());
                if (workflowIndex < 0) {
                    combo.select(0);
                    this.fSelectedWorkflow = null;
                } else {
                    combo.select(workflowIndex);
                    this.fSelectedWorkflow = this.fWorkflowInfos[workflowIndex];
                }
            }
            combo.setEnabled(index >= 0);
            comboLabel.setEnabled(index >= 0);
            stateGroupButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    fSelectedWorkflow = null;
                    combo.setEnabled(false);
                    comboLabel.setEnabled(false);
                }
            });
            workflow.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    fSelectedWorkflow = fWorkflowInfos[combo.getSelectionIndex()];
                    combo.setEnabled(true);
                    comboLabel.setEnabled(true);
                }
            });
            combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    fSelectedWorkflow = fWorkflowInfos[combo.getSelectionIndex()];
                }
            });
            UI.hookHelpListener((Control)result, "com.ibm.team.apt.ide.ui.dialog_taskboard_config");
            return result;
        }

        private int getWorfklowIndex(String workflowId) {
            int i = 0;
            while (i < this.fWorkflowInfos.length) {
                if (workflowId.equals(this.fWorkflowInfos[i].getIdentifier())) {
                    return i;
                }
                ++i;
            }
            return -1;
        }
    }
}

