/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.editor;

import com.ibm.team.apt.internal.client.wiki.ResolvedWikiPage;
import com.ibm.team.apt.internal.common.util.Html;
import com.ibm.team.apt.internal.ide.core.common.StyleSheetResources;
import com.ibm.team.apt.internal.ide.ui.editor.wiki.WikiDocument;
import com.ibm.team.workitem.common.internal.wiki.transformer.Transformer;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.forms.FormColors;

public class StyledWikiDocument
extends WikiDocument {
    public static final Html.Attribute INIT_ATTR = new Html.Attribute("onload", "initPage()");
    private static final String PLAN_EDITOR_FONT_FAMILY = "$planEditorFontFamily$";
    private static final String PLAN_EDITOR_FONT_SIZE = "$planEditorFontSize$";
    private static final String PLAN_EDITOR_HEADING_COLOR = "$planEditorHeadingColor$";
    private static final String PLAN_EDITOR_KEY_LINE_COLOR = "$planEditorKeyLineColor$";
    private static final String PAGE_NAME = "${PAGE_NAME}";
    private static final String PAGE_CONTENT = "${PAGE_CONTENT}";
    private static final String PAGE_STYLE = "${PAGE_STYLE}";
    private final boolean IS_MAC = "carbon".equals(SWT.getPlatform()) || "cocoa".equals(SWT.getPlatform());
    private final IPath STYLE_SHEET_LOCATION = new Path("resources/planNotes/");
    private StringBuilder fPageTemplate = new StringBuilder();
    private final ResolvedWikiPage fPage;
    private boolean fIgnoreChanges = false;

    public StyledWikiDocument(ResolvedWikiPage page, Transformer transformer) {
        super(page.getContent2(), transformer, page.isAllowsEmbeddedHtml() ? Transformer.ALL_OPTIONS : Transformer.SAFE_OPTIONS);
        this.fPage = page;
        this.initPageTemplate();
        this.addDocumentListener(new IDocumentListener(){

            public void documentChanged(DocumentEvent event) {
                if (!StyledWikiDocument.this.fIgnoreChanges) {
                    StyledWikiDocument.this.fPage.markAsDirty();
                }
            }

            public void documentAboutToBeChanged(DocumentEvent event) {
            }
        });
    }

    public ResolvedWikiPage getPage() {
        return this.fPage;
    }

    protected void internalSet(String content) {
        this.fIgnoreChanges = true;
        this.set(content);
        this.fIgnoreChanges = false;
    }

    private void initPageTemplate() {
        Html.HTML.open((CharSequence)this.fPageTemplate, new Html.Attribute[0]);
        Html.HEAD.open((CharSequence)this.fPageTemplate, new Html.Attribute[0]);
        Html.TITLE.open((CharSequence)this.fPageTemplate, new Html.Attribute[0]);
        Html.append((CharSequence)this.fPageTemplate, (CharSequence)PAGE_NAME);
        Html.TITLE.close((CharSequence)this.fPageTemplate);
        Html.META.open((CharSequence)this.fPageTemplate, new Html.Attribute[]{new Html.Attribute("http-equiv", "content-type"), new Html.Attribute("content", "text/html; charset=UTF-8")});
        Html.META.close((CharSequence)this.fPageTemplate);
        Html.STYLE.open((CharSequence)this.fPageTemplate, new Html.Attribute[]{new Html.Attribute("type", "text/css"), new Html.Attribute("media", "all")});
        this.insertSyles(this.fPageTemplate);
        Html.append((CharSequence)this.fPageTemplate, (CharSequence)PAGE_STYLE);
        Html.STYLE.close((CharSequence)this.fPageTemplate);
        Html.SCRIPT.open((CharSequence)this.fPageTemplate, new Html.Attribute[]{new Html.Attribute("type", "text/javascript")});
        this.insertScripts(this.fPageTemplate);
        Html.append((CharSequence)this.fPageTemplate, (CharSequence)"function replaceAll(id, text){var i= 0;for(i=0; i<id.length; i++){ var n= document.getElementById(id[i]); while (n.hasChildNodes()) { n.removeChild(n.firstChild) }; n.appendChild(document.createTextNode(text[i]));}}\n");
        Html.append((CharSequence)this.fPageTemplate, (CharSequence)"function updateImage(id, value){document.getElementById(id).src= value;}\n");
        Html.SCRIPT.close((CharSequence)this.fPageTemplate);
        Html.HEAD.close((CharSequence)this.fPageTemplate);
        Html.BODY.open((CharSequence)this.fPageTemplate, new Html.Attribute[]{INIT_ATTR});
        Html.append((CharSequence)this.fPageTemplate, (CharSequence)PAGE_CONTENT);
        Html.BODY.close((CharSequence)this.fPageTemplate);
        Html.HTML.close((CharSequence)this.fPageTemplate);
    }

    protected void insertScripts(StringBuilder template) {
    }

    protected void insertSyles(StringBuilder template) {
    }

    public String getStyledDocument(String bodyContent) {
        StringBuilder buffer = new StringBuilder(this.fPageTemplate.toString());
        this.replace(buffer, PAGE_NAME, this.getPage().getWikiName());
        this.replace(buffer, PAGE_STYLE, this.replaceVariables(StyleSheetResources.getStyleSheet((IPath)this.STYLE_SHEET_LOCATION)));
        this.replace(buffer, PAGE_CONTENT, bodyContent);
        return buffer.toString();
    }

    private String replaceVariables(String styleInformation) {
        Font font = JFaceResources.getFont((String)"com.ibm.team.apt.ide.ui.iterationPlanEditor.wiki.font");
        Display display = Display.getDefault();
        RGB selectionColor = display.getSystemColor(26).getRGB();
        RGB keyLineColor = FormColors.blend((RGB)selectionColor, (RGB)new RGB(255, 255, 255), (int)30);
        boolean useSelectionColor = (selectionColor.equals((Object)display.getSystemColor(1).getRGB()) || !selectionColor.equals((Object)display.getSystemColor(2).getRGB())) && FormColors.testTwoPrimaryColors((RGB)selectionColor, (int)0, (int)120);
        RGB headingsColor = useSelectionColor ? selectionColor : FormColors.blend((RGB)selectionColor, (RGB)display.getSystemColor(24).getRGB(), (int)50);
        StringBuilder buffer = new StringBuilder(styleInformation);
        this.replace(buffer, PLAN_EDITOR_FONT_FAMILY, font.getFontData()[0].getName());
        this.replace(buffer, PLAN_EDITOR_FONT_SIZE, String.valueOf(font.getFontData()[0].getHeight()) + (this.IS_MAC ? "px" : "pt"));
        this.replace(buffer, PLAN_EDITOR_HEADING_COLOR, this.getColorValue(headingsColor));
        this.replace(buffer, PLAN_EDITOR_KEY_LINE_COLOR, this.getColorValue(keyLineColor));
        return buffer.toString();
    }

    private String getColorValue(RGB color) {
        return String.format("#%06x", 65536 * color.red + 256 * color.green + color.blue);
    }

    private void replace(StringBuilder buffer, String toReplace, String replacement) {
        int index = 0;
        int length = toReplace.length();
        while ((index = buffer.indexOf(toReplace, index)) != -1) {
            buffer.replace(index, index + length, replacement);
        }
    }
}

