/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.editor;

import com.ibm.team.apt.api.common.planning.IProgressInformation;
import com.ibm.team.apt.api.common.planning.IProgressItemAccessor;
import com.ibm.team.apt.internal.client.IPlanAttributeDelta;
import com.ibm.team.apt.internal.client.IPlanElementChangeEvent;
import com.ibm.team.apt.internal.client.IPlanElementDelta;
import com.ibm.team.apt.internal.client.IPlanElementDeltaVisitor;
import com.ibm.team.apt.internal.client.IPlanElementListener;
import com.ibm.team.apt.internal.client.IPlanningAttribute;
import com.ibm.team.apt.internal.client.IPlanningAttributeIdentifier;
import com.ibm.team.apt.internal.client.IterationPlanData;
import com.ibm.team.apt.internal.client.IterationPlanDataListener;
import com.ibm.team.apt.internal.client.PlanElement;
import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.client.PlanningAttributeIdentifier;
import com.ibm.team.apt.internal.client.ResolvedIterationPlan;
import com.ibm.team.apt.internal.client.progress.ProgressClient;
import com.ibm.team.apt.internal.common.JSUtils;
import com.ibm.team.apt.internal.common.WorkItemEstimator;
import com.ibm.team.apt.internal.common.duration.IComplexityAttribute;
import com.ibm.team.apt.internal.common.duration.PlanDuration;
import com.ibm.team.apt.internal.ide.ui.editor.IterationPlanEditor;
import com.ibm.team.apt.internal.ide.ui.progress.ProgressIDE;
import com.ibm.team.rtc.common.scriptengine.IScriptEnvironment;
import com.ibm.team.rtc.common.scriptengine.IScriptRunnable;
import com.ibm.team.rtc.common.scriptengine.IScriptableProxy;
import com.ibm.team.rtc.common.scriptengine.ScriptUtilities;
import com.ibm.team.workitem.common.model.Identifier;
import com.ibm.team.workitem.common.workflow.IWorkflowInfo;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

class ProgressInformationUpdater {
    private IPlanElementDeltaVisitor fPlanDeltaVisitor = new IPlanElementDeltaVisitor(){

        public boolean visit(final IPlanElementDelta delta) {
            IProgressInformation progressInformation = ProgressInformationUpdater.this.fPlanEditor.getProgressInformation();
            if (progressInformation == null) {
                return false;
            }
            PlanElement element = delta.getPlanElement();
            if (!(element instanceof PlanItem)) {
                return true;
            }
            PlanItem planItem = (PlanItem)element;
            PlanElementDeltaAccessor newStateAccessor = new PlanElementDeltaAccessor(planItem, true);
            PlanElementDeltaAccessor oldStateAccessor = new PlanElementDeltaAccessor(planItem, false);
            if (!ProgressInformationUpdater.this.fAffectsProgress && !newStateAccessor.affectedBy(delta)) {
                return true;
            }
            boolean complexityAttributeDefined = ProgressInformationUpdater.this.fComplexityAttribute != null;
            final IScriptEnvironment environment = ((IScriptableProxy)progressInformation).getScriptEnvironment();
            IProgressInformation newStateProgressInformation = (IProgressInformation)ScriptUtilities.newInstance((IScriptEnvironment)environment, IProgressInformation.class, (String)"com.ibm.team.apt.shared.client.internal.progress.ProgressInformation", (Object[])new Object[0]);
            final Scriptable newStateComputer = ProgressIDE.newProgressComputer(environment, (ResolvedIterationPlan)planItem.getPlan(), complexityAttributeDefined, newStateAccessor, newStateProgressInformation);
            IProgressInformation oldStateProgressInformation = (IProgressInformation)ScriptUtilities.newInstance((IScriptEnvironment)environment, IProgressInformation.class, (String)"com.ibm.team.apt.shared.client.internal.progress.ProgressInformation", (Object[])new Object[0]);
            final Scriptable oldStateComputer = ProgressIDE.newProgressComputer(environment, (ResolvedIterationPlan)planItem.getPlan(), complexityAttributeDefined, oldStateAccessor, oldStateProgressInformation);
            environment.execute((IScriptRunnable)new IScriptRunnable<Void, RuntimeException>(){

                public Void run(Context cx, Scriptable scope) throws RuntimeException {
                    JSUtils.callMethod((IScriptEnvironment)environment, (Context)cx, (Scriptable)newStateComputer, (String)"compute", (Object[])new Object[]{delta});
                    JSUtils.callMethod((IScriptEnvironment)environment, (Context)cx, (Scriptable)oldStateComputer, (String)"compute", (Object[])new Object[]{delta});
                    return null;
                }
            });
            ProgressClient.subtract((IProgressInformation)progressInformation, (IProgressInformation)oldStateProgressInformation);
            ProgressClient.add((IProgressInformation)progressInformation, (IProgressInformation)newStateProgressInformation);
            ProgressInformationUpdater.this.fAffectsProgress = true;
            return true;
        }
    };
    private IPlanElementListener fPlanElementListener = new IPlanElementListener(){

        public void planElementChanged(IPlanElementChangeEvent event) {
            ProgressInformationUpdater.this.handlePlanItemChange(event);
        }
    };
    private IterationPlanDataListener fPlanDataListener = new IterationPlanDataListener(){

        public void iterationPlanResolved(ResolvedIterationPlan plan) {
            ProgressInformationUpdater.this.fIterationPlanData.removeListener((IterationPlanDataListener)this);
            plan.addListener(ProgressInformationUpdater.this.fPlanElementListener);
        }
    };
    private IterationPlanEditor fPlanEditor;
    private IterationPlanData fIterationPlanData;
    private IComplexityAttribute fComplexityAttribute;
    private Object fMutex = new Object();
    private boolean fAffectsProgress;

    public ProgressInformationUpdater(IterationPlanEditor planEditor) {
        this.fPlanEditor = planEditor;
        this.fIterationPlanData = planEditor.getIterationPlanData();
        this.fComplexityAttribute = this.fIterationPlanData.getComplexityAttribute();
        if (this.fIterationPlanData.getIterationPlan() != null) {
            this.fIterationPlanData.getIterationPlan().addListener(this.fPlanElementListener);
        } else {
            this.fIterationPlanData.addListener(this.fPlanDataListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handlePlanItemChange(IPlanElementChangeEvent event) {
        Object object = this.fMutex;
        synchronized (object) {
            this.fAffectsProgress = false;
            event.getDelta().accept(this.fPlanDeltaVisitor);
            if (this.fAffectsProgress) {
                this.fPlanEditor.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ProgressInformationUpdater.this.fPlanEditor.updateHeaderStatus();
                    }
                });
            }
        }
    }

    public void dispose() {
        this.fIterationPlanData.removeListener(this.fPlanDataListener);
        if (this.fIterationPlanData.getIterationPlan() != null) {
            this.fIterationPlanData.getIterationPlan().removeListener(this.fPlanElementListener);
        }
        this.fPlanElementListener = null;
        this.fIterationPlanData = null;
        this.fPlanEditor = null;
    }

    private final class PlanElementDeltaAccessor
    implements IProgressItemAccessor<IPlanElementDelta> {
        private final List<IPlanningAttributeIdentifier> fgAttributes = Arrays.asList(PlanItem.AUXILIARY_ITEM, PlanItem.STATE, PlanItem.ITEM_TYPE, PlanItem.DURATION);
        private final PlanItem fPlanItem;
        private final boolean fNewValues;
        private IPlanningAttribute<PlanItem, ?> fCAttribute;

        private PlanElementDeltaAccessor(PlanItem planItem, boolean newValues) {
            this.fPlanItem = planItem;
            this.fNewValues = newValues;
            IComplexityAttribute complexityAttribute = ProgressInformationUpdater.this.fIterationPlanData.getComplexityAttribute();
            if (complexityAttribute != null) {
                this.fCAttribute = this.fPlanItem.getPlan().findAttribute(PlanningAttributeIdentifier.create((String)complexityAttribute.getAttributeId()));
            }
        }

        public boolean affectedBy(IPlanElementDelta delta) {
            IPlanAttributeDelta[] attributeDeltas;
            IPlanAttributeDelta[] iPlanAttributeDeltaArray = attributeDeltas = delta.getAttributeDeltas();
            int n = attributeDeltas.length;
            int n2 = 0;
            while (n2 < n) {
                IPlanAttributeDelta attributeDelta = iPlanAttributeDeltaArray[n2];
                if (this.fCAttribute != null && this.fCAttribute.equals((Object)attributeDelta.getAttribute())) {
                    return true;
                }
                if (this.fgAttributes.contains(attributeDelta.getAttribute())) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        private <T> T getValue(IPlanAttributeDelta delta) {
            return (T)(this.fNewValues ? delta.getNewValue() : delta.getOldValue());
        }

        public IPlanElementDelta[] getChildren(IPlanElementDelta entry) {
            return new IPlanElementDelta[0];
        }

        public boolean isPlanItem(IPlanElementDelta entry) {
            return true;
        }

        public boolean isPrimaryElement(IPlanElementDelta entry) {
            return true;
        }

        public boolean isAuxiliaryPlanItem(IPlanElementDelta entry) {
            IPlanAttributeDelta delta = entry.getAttributeDelta(PlanItem.AUXILIARY_ITEM);
            return delta != null ? ((Boolean)this.getValue(delta)).booleanValue() : this.fPlanItem.isAuxiliaryPlanItem();
        }

        public boolean isResolved(IPlanElementDelta entry) {
            IPlanAttributeDelta delta = entry.getAttributeDelta(PlanItem.STATE);
            if (delta != null && this.fPlanItem.getWorkflowInfo() != null) {
                IWorkflowInfo workflowInfo = this.fPlanItem.getWorkflowInfo();
                return workflowInfo.getStateGroup((Identifier)this.getValue(delta)) == 2;
            }
            return this.fPlanItem.isResolved();
        }

        public boolean isTopLevelPlanItem(IPlanElementDelta entry) {
            IPlanAttributeDelta delta = entry.getAttributeDelta(PlanItem.ITEM_TYPE);
            if (delta != null) {
                Set topLevelTypes = ((ResolvedIterationPlan)this.fPlanItem.getPlan()).getTopLevelWorkItemTypes();
                return topLevelTypes.contains(this.getValue(delta));
            }
            return this.fPlanItem.isTopLevelPlanItem();
        }

        public long getComplexity(IPlanElementDelta entry) {
            WorkItemEstimator wiEstimator = WorkItemEstimator.getInstance();
            if (this.fCAttribute == null || !this.fCAttribute.isDefined((Object)this.fPlanItem)) {
                return wiEstimator.getComplexity(null);
            }
            IPlanAttributeDelta delta = entry.getAttributeDelta(this.fCAttribute);
            if (delta != null) {
                return wiEstimator.getComplexity(this.getValue(delta));
            }
            return wiEstimator.getComplexity(this.fCAttribute.getValue((Object)this.fPlanItem));
        }

        public PlanDuration getDuration(IPlanElementDelta entry) {
            IPlanAttributeDelta delta = entry.getAttributeDelta(PlanItem.DURATION);
            if (delta != null) {
                return (PlanDuration)this.getValue(delta);
            }
            return this.fPlanItem.getDuration();
        }

        public IProgressInformation getProgressInformation(IPlanElementDelta entry) {
            return null;
        }

        public boolean hasUnloadedChildren(IPlanElementDelta entry) {
            return false;
        }
    }
}

