/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.editor;

import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.ide.ui.ImagePool;
import com.ibm.team.apt.internal.ide.ui.PlanningUIPlugin;
import com.ibm.team.apt.internal.ide.ui.common.PlanCanvas;
import com.ibm.team.apt.internal.ide.ui.editor.Messages;
import com.ibm.team.apt.internal.ide.ui.editor.OutlinePage;
import com.ibm.team.apt.internal.ide.ui.util.UI;
import com.ibm.team.apt.internal.ide.ui.widgets.AnimatedLoadingLabel;
import com.ibm.team.foundation.common.URIReference;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.ActiveControlTracker;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.actions.CommandAction;
import com.ibm.team.foundation.rcp.core.hyperlinks.ContextProvider;
import com.ibm.team.foundation.rcp.core.hyperlinks.Hyperlinks;
import com.ibm.team.foundation.rcp.ui.dnd.DragSupport;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.ui.editor.TeamFormPage;
import com.ibm.team.workitem.client.IWorkItemListener;
import com.ibm.team.workitem.client.IWorkingCopyListener;
import com.ibm.team.workitem.client.WorkItemChangeEvent;
import com.ibm.team.workitem.client.WorkItemEvent;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.client.WorkingCopyEvent;
import com.ibm.team.workitem.common.internal.presentations.EditorPresentation;
import com.ibm.team.workitem.common.internal.presentations.TabDescriptor;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.IWorkItemType;
import com.ibm.team.workitem.common.text.WorkItemTextUtilities;
import com.ibm.team.workitem.ide.ui.internal.WorkItemIDEUIPlugin;
import com.ibm.team.workitem.ide.ui.internal.editor.IAuxiliaryItems;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorInput;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorTabs;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorToolkit;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemUIWorkingCopy;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.PresentationTab;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.presentationhandler.IPresentationContext;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.presentationhandler.PresentationHandlerManager;
import com.ibm.team.workitem.rcp.ui.IWorkItemUIWorkingCopy;
import com.ibm.team.workitem.rcp.ui.UIWorkItemListener;
import com.ibm.team.workitem.rcp.ui.UIWorkItemWorkingCopyListener;
import com.ibm.team.workitem.rcp.ui.WorkItemUI;
import com.ibm.team.workitem.rcp.ui.internal.WorkItemLinkDetectorContextProvider;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.forms.HyperlinkSettings;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.services.IServiceLocator;

public final class PreviewPane
extends PlatformObject {
    public static final String TARGET_IDENTIFIER = "com.ibm.team.apt.ui.internal.previewPane";
    private final Composite fContainer;
    private Composite fContentStack;
    private final ContextProvider fContextProvider = new WorkItemLinkDetectorContextProvider(null){

        public URIReference getContext() {
            if (PreviewPane.this.fEditorInput != null) {
                return PreviewPane.this.fEditorInput.getReference();
            }
            return null;
        }

        public Object getUIContext() {
            return PreviewPane.this.fWorkbenchPart;
        }

        public IProjectAreaHandle getProjectArea() {
            IWorkItem workItem = PreviewPane.this.fEditorInput.getWorkItem();
            if (workItem != null) {
                return workItem.getProjectArea();
            }
            return null;
        }
    };
    private WorkItemEditorInput fEditorInput;
    private boolean fIsVisible;
    private boolean fIsWriteTracked;
    private AnimatedLoadingLabel fLoadingLabel;
    private Composite fLoadingLabelContainer;
    private Job fLoadJob;
    private final Object fLoadJobGuard = new Object();
    private Composite fMessageContainer;
    private PlanCanvas fOutlineControl;
    private PlanItem fPlanItem;
    private final Map<UUID, Map<IWorkItemType, Pane>> fTabCache = new HashMap<UUID, Map<IWorkItemType, Pane>>();
    private Sash fPreviewSash;
    private ResourceManager fResourceManager;
    private CLabel fStatusLabel;
    private FormText fStatusDetails;
    private FormToolkit fToolkit;
    private IWorkbenchPart fWorkbenchPart;
    private final FormEditor fEditor;
    private ActiveControlTracker fActiveControlTracker;
    private Map<String, CommandAction> fActions;
    private final PresentationHandlerManager fPresentationHandlerManager = new PresentationHandlerManager(new IPresentationContext(){

        public WorkItemWorkingCopy getWorkingCopy() {
            return PreviewPane.this.fEditorInput.getWorkingCopy();
        }

        public IWorkbenchWindow getWorkbench() {
            return Workbench.getInstance().getActiveWorkbenchWindow();
        }

        public IAuxiliaryItems getAuxiliaryItems() {
            return PreviewPane.this.fEditorInput;
        }
    });

    public PreviewPane(Composite parent, PlanCanvas outlineControl, OutlinePage outlinePage) {
        this.fContainer = parent;
        this.fEditor = outlinePage.getIterationPlanEditor();
        this.fWorkbenchPart = this.fEditor.getSite().getPart();
        this.createControls(parent, outlineControl);
        this.initActions();
    }

    private void initActions() {
        Object version = Platform.getBundle((String)"org.eclipse.ui").getHeaders().get("Bundle-Version");
        if (version instanceof String && ((String)version).startsWith("3.3")) {
            this.fActions = new HashMap<String, CommandAction>();
            IWorkbenchPartSite serviceLocator = this.fWorkbenchPart.getSite();
            this.fActions.put(ActionFactory.CUT.getId(), new CommandAction((IServiceLocator)serviceLocator, "org.eclipse.ui.edit.cut"));
            this.fActions.put(ActionFactory.COPY.getId(), new CommandAction((IServiceLocator)serviceLocator, "org.eclipse.ui.edit.copy"));
            this.fActions.put(ActionFactory.PASTE.getId(), new CommandAction((IServiceLocator)serviceLocator, "org.eclipse.ui.edit.paste"));
            this.fActions.put(ActionFactory.UNDO.getId(), new CommandAction((IServiceLocator)serviceLocator, "org.eclipse.ui.edit.undo"));
            this.fActions.put(ActionFactory.REDO.getId(), new CommandAction((IServiceLocator)serviceLocator, "org.eclipse.ui.edit.redo"));
        }
    }

    public Action getAction(String id) {
        if (this.fActions == null) {
            return null;
        }
        return (Action)this.fActions.get(id);
    }

    private void createControls(final Composite parent, PlanCanvas outlineControl) {
        this.fOutlineControl = outlineControl;
        this.fToolkit = new WorkItemEditorToolkit(WorkItemIDEUIPlugin.getDefault().getSharedFormColors(parent.getDisplay()));
        this.fResourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)parent);
        this.fPreviewSash = new Sash(parent, 512);
        this.fToolkit.adapt((Control)this.fPreviewSash, true, true);
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment((Control)outlineControl);
        data.bottom = new FormAttachment(100);
        this.fPreviewSash.setLayoutData((Object)data);
        this.fPreviewSash.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (PreviewPane.this.fIsVisible) {
                    Rectangle clientArea = parent.getClientArea();
                    if (event.x < clientArea.x + 40 || event.x > clientArea.x + clientArea.width - 40) {
                        event.doit = false;
                    } else {
                        ((FormData)((PreviewPane)PreviewPane.this).fOutlineControl.getLayoutData()).right = new FormAttachment(event.x, clientArea.width, 0);
                        parent.layout();
                    }
                }
            }
        });
        this.fContentStack = this.fToolkit.createComposite(parent);
        this.fActiveControlTracker = new ActiveControlTracker(this.fContentStack);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment((Control)this.fPreviewSash, 0);
        data.bottom = new FormAttachment(100);
        data.right = new FormAttachment(100);
        this.fContentStack.setLayoutData((Object)data);
        this.fContentStack.setLayout((Layout)new StackLayout());
        this.createMessageContainer(this.fContentStack);
        this.createLoadingContainer(this.fContentStack);
        this.showMessage(Messages.PreviewPane_NO_ITEM_SELECTED, null, null);
    }

    private void createLoadingContainer(Composite parent) {
        this.fLoadingLabelContainer = this.fToolkit.createComposite(parent);
        this.fLoadingLabelContainer.setLayout((Layout)new FillLayout());
        this.fLoadingLabel = new AnimatedLoadingLabel(this.fLoadingLabelContainer, 0);
        this.fLoadingLabel.setFont(JFaceResources.getBannerFont());
    }

    private void createMessageContainer(Composite parent) {
        this.fMessageContainer = this.fToolkit.createComposite(parent);
        GridLayoutFactory.fillDefaults().applyTo(this.fMessageContainer);
        this.fStatusLabel = new CLabel(this.fMessageContainer, 0x1000000);
        this.fToolkit.adapt((Composite)this.fStatusLabel);
        this.fStatusLabel.setFont(JFaceResources.getBannerFont());
        this.fStatusLabel.setForeground(PlanningUIPlugin.getDefault().getMidShadow());
        GridDataFactory.fillDefaults().grab(true, true).align(0x1000000, 0x1000008).applyTo((Control)this.fStatusLabel);
        this.fStatusDetails = this.fToolkit.createFormText(this.fMessageContainer, true);
        this.fToolkit.adapt((Composite)this.fStatusDetails);
        this.fStatusDetails.setHyperlinkSettings((HyperlinkSettings)this.fToolkit.getHyperlinkGroup());
        GridDataFactory.fillDefaults().grab(true, true).align(0x1000000, 128).applyTo((Control)this.fStatusDetails);
        this.fStatusDetails.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                Object href = e.getHref();
                try {
                    URI uri = URI.create(href.toString());
                    Hyperlinks.open((URI)uri, (ContextProvider)PreviewPane.this.fContextProvider);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.fLoadJobGuard;
        synchronized (object) {
            for (Map<IWorkItemType, Pane> m : this.fTabCache.values()) {
                for (Pane p : m.values()) {
                    p.dispose();
                }
                m.clear();
            }
            this.fTabCache.clear();
            if (this.fLoadJob != null) {
                this.fLoadJob.cancel();
                this.fLoadJob = null;
            }
            if (this.fEditorInput != null) {
                this.fEditorInput.release();
                this.fEditorInput = null;
            }
            if (this.fPlanItem != null && this.fIsWriteTracked) {
                this.fPlanItem.endWriteTracking();
            }
            if (this.fToolkit != null) {
                this.fToolkit.dispose();
                this.fToolkit = null;
            }
            if (this.fActions != null) {
                for (CommandAction action : this.fActions.values()) {
                    action.dispose();
                }
            }
            this.fPlanItem = null;
            this.fWorkbenchPart = null;
        }
    }

    private Pane findPresentation(WorkItemEditorInput editorInput, IWorkItemType type, EditorPresentation presentation) {
        Map<IWorkItemType, Pane> types = this.fTabCache.get(editorInput.getWorkItem().getProjectArea().getItemId());
        Pane pane = null;
        if (types != null) {
            pane = types.get(type);
        } else {
            this.fTabCache.put(editorInput.getWorkItem().getProjectArea().getItemId(), new HashMap());
        }
        if (pane != null) {
            return pane;
        }
        String tabId = presentation.getPresentationId();
        TabDescriptor tabDescriptor = new TabDescriptor(tabId, "", new HashMap());
        TeamFormPage tab = WorkItemEditorTabs.createTab((WorkItemEditorInput)editorInput, (Map)editorInput.getEditorPresentation().getPresentationsMap(), (TabDescriptor)tabDescriptor);
        if (tab == null) {
            return null;
        }
        pane = new Pane(this.fContentStack, (PresentationTab)tab);
        this.fTabCache.get(editorInput.getWorkItem().getProjectArea().getItemId()).put(type, pane);
        return pane;
    }

    public Object getAdapter(Class adapter) {
        WorkItemUIWorkingCopy uiWorkingCopy;
        WorkItemWorkingCopy workingCopy;
        if (adapter.isAssignableFrom(IWorkbenchPart.class)) {
            return this.fWorkbenchPart;
        }
        if (ContextProvider.class.equals((Object)adapter)) {
            return this.fContextProvider;
        }
        if (UIWorkItemListener.class.isAssignableFrom(adapter) && this.fEditorInput != null && (workingCopy = this.fEditorInput.getWorkingCopy()) != null && (uiWorkingCopy = (WorkItemUIWorkingCopy)workingCopy.getAdapter(WorkItemUIWorkingCopy.class)) != null) {
            return uiWorkingCopy.getUIWorkItemListener();
        }
        if (IServiceLocator.class.equals((Object)adapter)) {
            return this.fWorkbenchPart.getSite();
        }
        if (IWorkbenchWindow.class.equals((Object)adapter)) {
            return this.fWorkbenchPart.getSite().getWorkbenchWindow();
        }
        if (ActiveControlTracker.class.equals((Object)adapter)) {
            return this.fActiveControlTracker;
        }
        Object result = super.getAdapter(adapter);
        if (result != null) {
            return result;
        }
        if (PresentationHandlerManager.class.equals((Object)adapter)) {
            return this.fPresentationHandlerManager;
        }
        if (EditorPresentation.class.equals((Object)adapter) && this.fEditorInput != null && this.fEditorInput.isResolved()) {
            return this.fEditorInput.getEditorPresentation();
        }
        return null;
    }

    public Control getControl() {
        return this.fContentStack;
    }

    private Control getCurrentContent() {
        return ((StackLayout)this.fContentStack.getLayout()).topControl;
    }

    public void setInput(PlanItem planItem) {
        this.setInput(planItem, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInput(final PlanItem planItem, boolean force) {
        if (planItem == this.fPlanItem && !force) {
            return;
        }
        Object object = this.fLoadJobGuard;
        synchronized (object) {
            if (this.fEditorInput != null) {
                this.fEditorInput.release();
                this.fEditorInput = null;
            }
            if (this.fPlanItem != null && this.fIsWriteTracked) {
                this.fPlanItem.endWriteTracking();
            }
            this.fPlanItem = planItem;
            this.fIsWriteTracked = false;
            if (this.fLoadJob != null) {
                this.fLoadJob.cancel();
                this.fLoadJob = null;
            }
            if (this.fIsVisible && planItem != null) {
                planItem.startWriteTracking();
                this.fIsWriteTracked = true;
                this.showLoadingLabel(0L);
                this.fLoadJob = new Job(Messages.PreviewPane_JOB_LOAD_PLAN_ITEM){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    protected IStatus run(final IProgressMonitor monitor) {
                        final WorkItemEditorInput editorInput = new WorkItemEditorInput(planItem.getWorkItemHandle(), PreviewPane.TARGET_IDENTIFIER);
                        PreviewPane.this.fEditorInput = editorInput;
                        editorInput.acquire();
                        editorInput.acquire();
                        try {
                            final IProjectArea projectArea = planItem.getPlan().getProjectArea();
                            editorInput.getWorkingCopy((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                            final EditorPresentation presentation = editorInput.getEditorPresentation();
                            final IWorkItemType workItemType = planItem.getItemType();
                            if (monitor.isCanceled()) {
                                IStatus iStatus = Status.CANCEL_STATUS;
                                return iStatus;
                            }
                            UI.syncExec((Control)PreviewPane.this.fContentStack, new Runnable(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public void run() {
                                    boolean presentationFound = false;
                                    if (!presentation.getPresentationId().equals("com.ibm.team.workitem.editor.default")) {
                                        Pane p = PreviewPane.this.findPresentation(PreviewPane.this.fEditorInput, workItemType, presentation);
                                        Object object = PreviewPane.this.fLoadJobGuard;
                                        synchronized (object) {
                                            if (p != null) {
                                                presentationFound = true;
                                                if (!monitor.isCanceled() && editorInput.isResolved()) {
                                                    p.setInput(editorInput, workItemType, planItem.getWorkItem(false));
                                                    PreviewPane.this.showContainer(p.getTopComposite(), false);
                                                }
                                            }
                                        }
                                    }
                                    if (!presentationFound) {
                                        Location location = Location.itemLocation((IItemHandle)projectArea, (String)PlanningClientPlugin.getTeamRepository((IItemHandle)projectArea).getRepositoryURI());
                                        PreviewPane.this.showMessage(NLS.bind((String)Messages.PreviewPane_MISSING_EDITOR_BINDING_MSG, (Object)workItemType.getDisplayName(), (Object[])new Object[0]), ImagePool.INFO_OBJ, NLS.bind((String)Messages.PreviewPane_MISSING_EDITOR_BINDING_HINT, (Object)location.toAbsoluteUri().toString(), (Object[])new Object[0]));
                                    }
                                }
                            });
                            Object object = PreviewPane.this.fLoadJobGuard;
                            synchronized (object) {
                                PreviewPane.this.fLoadJob = null;
                            }
                            IStatus iStatus = Status.OK_STATUS;
                            return iStatus;
                        }
                        finally {
                            editorInput.release();
                        }
                    }
                };
                this.fLoadJob.schedule();
            } else {
                if (this.fEditorInput != null) {
                    this.fEditorInput.release();
                    this.fEditorInput = null;
                }
                this.showMessage(Messages.PreviewPane_NO_ITEM_SELECTED, null, null);
            }
        }
    }

    public void setVisible(boolean visible) {
        if (this.fIsVisible == visible) {
            return;
        }
        this.fIsVisible = visible;
        this.fPreviewSash.setVisible(visible);
        this.fContentStack.setVisible(visible);
        if (visible) {
            ((FormData)this.fOutlineControl.getLayoutData()).right = new FormAttachment(50);
            if (this.fPlanItem != null) {
                this.setInput(this.fPlanItem, true);
            }
            this.showContainer((Composite)this.getCurrentContent(), true);
        } else {
            ((FormData)this.fOutlineControl.getLayoutData()).right = new FormAttachment(100);
        }
        this.fContainer.layout(true, true);
    }

    private void showContainer(Composite content, boolean force) {
        if (!force && this.getCurrentContent() == content) {
            return;
        }
        if (content != this.fLoadingLabelContainer) {
            this.fLoadingLabel.stop();
        }
        ((StackLayout)this.fContentStack.getLayout()).topControl = content;
        if (this.fIsVisible) {
            this.fContentStack.layout(true, true);
        }
    }

    private void showLoadingLabel(long timeout) {
        this.fLoadingLabel.start(0);
        this.showContainer(this.fLoadingLabelContainer, false);
    }

    private void showMessage(String message, ImageDescriptor image, String details) {
        this.fStatusLabel.setText(message);
        this.fStatusLabel.setImage(image != null ? this.fResourceManager.createImage(image) : null);
        this.fStatusDetails.setText(details != null ? details : "", details != null, false);
        this.showContainer(this.fMessageContainer, false);
    }

    private class Pane {
        private ILabelProvider fLabelProvider;
        private Composite fContainer;
        private CLabel fLabel;
        private final PresentationTab fTab;
        private final IWorkItemListener fWorkItemListener = new WorkItemListener();
        private WorkItemWorkingCopy fWorkingCopy;
        private final UIWorkItemWorkingCopyListener fWorkingCopyListener = new UIWorkItemWorkingCopyListener(new IWorkingCopyListener(){

            public void workingCopyEvent(WorkingCopyEvent event) {
                if (event.hasType("saved") || event.hasType("saveCanceled") || event.hasType("reverted") || event.hasType("workflowAction")) {
                    PreviewPane.this.fPresentationHandlerManager.presentationEvent((WorkItemEvent)event);
                }
            }
        });

        Pane(Composite parent, PresentationTab tab) {
            this.fLabelProvider = WorkItemUI.createWorkItemLabelProvider();
            this.fTab = tab;
            this.createControls(parent);
        }

        private void createControls(Composite parent) {
            this.fLabelProvider = WorkItemUI.createWorkItemLabelProvider();
            this.fContainer = PreviewPane.this.fToolkit.createComposite(parent);
            GridLayoutFactory.fillDefaults().spacing(0, 3).margins(3, 3).numColumns(1).applyTo(this.fContainer);
            this.createParts();
        }

        public Composite getTopComposite() {
            return this.fContainer;
        }

        private void createParts() {
            this.fLabel = new CLabel(this.fContainer, 0);
            this.fLabel.setBackground(this.fContainer.getBackground());
            new DragSupport((Control)this.fLabel, 4){

                public ISelection getSelection() {
                    return new StructuredSelection((Object)PreviewPane.this.fPlanItem.getWorkItem(false));
                }
            };
            GridDataFactory.fillDefaults().span(2, 0).grab(false, false).applyTo((Control)this.fLabel);
            Font font = this.fContainer.getFont();
            FontData[] datas = font.getFontData();
            FontData[] newDatas = new FontData[datas.length];
            int i = 0;
            while (i < datas.length) {
                FontData data = datas[i];
                newDatas[i] = new FontData(data.getName(), Math.max(6, data.getHeight() + 2), data.getStyle() | 1);
                ++i;
            }
            FormColors formColors = new FormColors(this.fContainer.getDisplay());
            RGB titleColorRGB = formColors.getColor("org.eclipse.ui.forms.TITLE").getRGB();
            formColors.dispose();
            Font titleFont = JazzResources.getFont((ResourceManager)PreviewPane.this.fResourceManager, (FontDescriptor)FontDescriptor.createFrom((FontData[])newDatas), (Font)font);
            Color titleColor = JazzResources.getColor((ResourceManager)PreviewPane.this.fResourceManager, (RGB)titleColorRGB);
            this.fLabel.setFont(titleFont);
            this.fLabel.setForeground(titleColor);
            this.fTab.initialize(PreviewPane.this.fEditor);
            this.fTab.init((IEditorSite)PreviewPane.this.fWorkbenchPart.getSite(), (IEditorInput)PreviewPane.this.fEditorInput);
            this.fTab.createPartControl(this.fContainer);
            this.fTab.getManagedForm().getForm().setLayoutData((Object)new GridData(4, 4, true, true));
        }

        private void addListeners() {
            if (this.fWorkingCopy != null) {
                WorkItemUIWorkingCopy uiCopy = (WorkItemUIWorkingCopy)this.fWorkingCopy.getAdapter(IWorkItemUIWorkingCopy.class);
                UIWorkItemListener listener = uiCopy.getUIWorkItemListener();
                if (listener != null) {
                    listener.addListener(this.fWorkItemListener);
                }
                this.fWorkingCopy.addWorkingCopyListener((IWorkingCopyListener)this.fWorkingCopyListener);
            }
        }

        private void removeListeners() {
            if (this.fWorkingCopy != null) {
                WorkItemUIWorkingCopy uiCopy = (WorkItemUIWorkingCopy)this.fWorkingCopy.getAdapter(IWorkItemUIWorkingCopy.class);
                UIWorkItemListener listener = uiCopy.getUIWorkItemListener();
                if (listener != null) {
                    listener.removeListener(this.fWorkItemListener);
                }
                this.fWorkingCopy.removeWorkingCopyListener((IWorkingCopyListener)this.fWorkingCopyListener);
            }
        }

        public void setInput(WorkItemEditorInput input, IWorkItemType type, IWorkItem item) {
            this.removeListeners();
            this.fWorkingCopy = null;
            if (input != null) {
                this.fWorkingCopy = input.getWorkingCopy();
                this.addListeners();
                this.fLabel.setImage(this.fLabelProvider.getImage((Object)item));
                this.fLabel.setText(NLS.bind((String)Messages.PreviewPane_PREVIEW_TITLE, (Object)type.getDisplayName(), (Object[])new Object[]{WorkItemTextUtilities.getWorkItemId((IWorkItem)item)}));
            }
            this.fTab.getManagedForm().setInput((Object)input);
        }

        public void dispose() {
            this.removeListeners();
            this.fTab.dispose();
            if (this.fLabelProvider != null) {
                this.fLabelProvider.dispose();
                this.fLabelProvider = null;
            }
        }

        private final class WorkItemListener
        implements IWorkItemListener {
            private WorkItemListener() {
            }

            public void workItemAttributeChanged(WorkItemChangeEvent event) {
                if (PreviewPane.this.fPlanItem == null || Pane.this.fWorkingCopy == null) {
                    return;
                }
                if (!event.affects((IWorkItemHandle)PreviewPane.this.fPlanItem.getWorkItem(false))) {
                    return;
                }
                if ((event.affects(IWorkItem.TYPE_PROPERTY) || event.affects(IWorkItem.ID_PROPERTY)) && !Pane.this.fLabel.isDisposed()) {
                    IWorkItem item = event.getWorkItem();
                    Pane.this.fLabel.setImage(Pane.this.fLabelProvider.getImage((Object)item));
                    IWorkItemType workItemType = PreviewPane.this.fPlanItem.getItemType();
                    if (workItemType != null) {
                        Pane.this.fLabel.setText(NLS.bind((String)Messages.PreviewPane_PREVIEW_TITLE, (Object)workItemType.getDisplayName(), (Object[])new Object[]{WorkItemTextUtilities.getWorkItemId((IWorkItem)item)}));
                    }
                }
                PreviewPane.this.fPresentationHandlerManager.presentationEvent((WorkItemEvent)event);
            }

            public void workItemAttributeDependencyChanged(WorkItemChangeEvent event) {
            }
        }
    }
}

