/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.editor;

import com.ibm.team.apt.common.RankingMode;
import com.ibm.team.apt.internal.common.ProgressMode;
import com.ibm.team.apt.internal.common.plantype.IAttributeDefinitionDescriptor;
import com.ibm.team.apt.internal.common.plantype.IColorizeDescription;
import com.ibm.team.apt.internal.common.plantype.IColumnDescriptor;
import com.ibm.team.apt.internal.common.plantype.IFilterDescription;
import com.ibm.team.apt.internal.common.plantype.IGroupModeDescription;
import com.ibm.team.apt.internal.common.plantype.IParameter;
import com.ibm.team.apt.internal.common.plantype.IPlanModeDescription;
import com.ibm.team.apt.internal.common.plantype.ISharedPlanMode;
import com.ibm.team.apt.internal.common.plantype.ISortModeDescription;
import com.ibm.team.apt.internal.common.plantype.IViewModeDescription;
import com.ibm.team.apt.internal.common.plantype.ResolvedPlanMode;
import com.ibm.team.apt.internal.common.process.ConfigurationElementFactory;
import com.ibm.team.apt.internal.ide.ui.common.IOutlineSettingsListener;
import com.ibm.team.apt.internal.ide.ui.common.structure.ItemMovePolicy;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.IPlanOutlineSettings;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.PlanOutlineSettingChangeEvent;
import com.ibm.team.process.common.IProcessDefinitionHandle;
import com.ibm.team.repository.common.IItemHandle;
import java.lang.reflect.Array;
import java.util.ArrayList;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.util.SafeRunnable;
import org.mozilla.javascript.RhinoException;

class PlanModeState
implements IPlanOutlineSettings {
    private final ISharedPlanMode fSharedPlanMode;
    private final IPlanModeDescription fDescription;
    private final ListenerList fSettingListeners = new ListenerList(1);
    private boolean fIsDirty = false;
    private boolean fShowDetails = true;
    private String fDefaultWorkItemType;
    private String fParentId;
    private String fRankingMode;
    private IParameter[] fExplicitRankParams;

    static PlanModeState newState(ResolvedPlanMode resolvedPlanMode, String rankingMode, IParameter[] explicitRankParams) {
        return new PlanModeState(resolvedPlanMode.getSharedPlanMode(), resolvedPlanMode.getDescription(), rankingMode, explicitRankParams);
    }

    static PlanModeState editState(PlanModeState other) {
        ISharedPlanMode sharedPlanMode = other.fSharedPlanMode;
        if (sharedPlanMode.getOwner() instanceof IProcessDefinitionHandle) {
            ISharedPlanMode newSharedPlanMode = (ISharedPlanMode)ISharedPlanMode.ITEM_TYPE.createItem();
            newSharedPlanMode.setOwner(sharedPlanMode.getOwner());
            newSharedPlanMode.setPlan(sharedPlanMode.getPlan());
            sharedPlanMode = newSharedPlanMode;
        }
        PlanModeState result = new PlanModeState(sharedPlanMode, (IPlanModeDescription)ConfigurationElementFactory.copy((Object)other.getDescription()), other.getRankingMode(), other.getExplicitRankParams());
        result.fParentId = other.getId();
        return result;
    }

    static PlanModeState copyState(PlanModeState other) {
        ISharedPlanMode sharedPlanMode = (ISharedPlanMode)ISharedPlanMode.ITEM_TYPE.createItem();
        sharedPlanMode.setOwner(other.fSharedPlanMode.getOwner());
        sharedPlanMode.setPlan(other.fSharedPlanMode.getPlan());
        PlanModeState result = new PlanModeState(sharedPlanMode, (IPlanModeDescription)ConfigurationElementFactory.copy((Object)other.getDescription()), other.getRankingMode(), other.getExplicitRankParams());
        result.fParentId = other.getId();
        return result;
    }

    private PlanModeState(ISharedPlanMode sharedPlanMode, IPlanModeDescription description, String rankingMode, IParameter[] explicitRankParams) {
        this.fSharedPlanMode = sharedPlanMode;
        this.fDescription = description;
        this.fShowDetails = true;
        this.fDefaultWorkItemType = null;
        this.fRankingMode = rankingMode;
        this.fExplicitRankParams = explicitRankParams;
        this.fixRankingMode();
    }

    private IParameter[] getExplicitRankParams() {
        return this.fExplicitRankParams;
    }

    private void fixRankingMode() {
        ISortModeDescription sortModeDescription = this.getSortMode();
        if ("com.ibm.team.apt.shared.ui.internal.sortmode.RankingPlanItemSorter".equals(sortModeDescription.getImplementationName()) && RankingMode.isExplicitRanking((String)this.getRankingMode())) {
            sortModeDescription.setImplementationName("com.ibm.team.apt.shared.ui.internal.sortmode.NewRankingPlanItemSorter");
            sortModeDescription.setParameters(this.getExplicitRankParams());
        }
    }

    public String getRankingMode() {
        return this.fRankingMode;
    }

    public String getParentId() {
        return this.fParentId;
    }

    public ISharedPlanMode getOrigin() {
        return this.fSharedPlanMode;
    }

    IPlanModeDescription getDescription() {
        return this.fDescription;
    }

    public boolean isDirty() {
        return this.fIsDirty;
    }

    public void setDirty(boolean value) {
        this.fIsDirty = value;
    }

    @Override
    public boolean isUsable() {
        return true;
    }

    public String getDisplayName() {
        return this.fDescription.getDisplayName();
    }

    public IFilterDescription[] getFilters() {
        return this.fDescription.getFilters();
    }

    public IAttributeDefinitionDescriptor[] getPlanChecks() {
        return this.fDescription.getPlanChecks();
    }

    public IColorizeDescription[] getColors() {
        return this.fDescription.getColors();
    }

    public IColorizeDescription[] setColors(IColorizeDescription[] value) {
        return this.fDescription.setColors(value);
    }

    public IGroupModeDescription getGroupMode() {
        return this.fDescription.getGroupMode();
    }

    public String getId() {
        return this.fDescription.getId();
    }

    public String isDeprecated() {
        return null;
    }

    public ProgressMode getProgressMode() {
        return this.fDescription.getProgressMode();
    }

    public ISortModeDescription getSortMode() {
        return this.fDescription.getSortMode();
    }

    public IViewModeDescription getViewMode() {
        return this.fDescription.getViewMode();
    }

    @Override
    public boolean isTaskboardViewmode() {
        String implementationName = this.getViewMode().getImplementationName();
        return "com.ibm.team.apt.shared.ui.internal.structure.TaskboardViewMode".equals(implementationName);
    }

    public String setId(String value) {
        return this.fDescription.setId(value);
    }

    public String setDisplayName(String text) {
        String oldValue = this.fDescription.setDisplayName(text);
        if (!oldValue.equals(text)) {
            this.setDirty(true);
        }
        return oldValue;
    }

    @Deprecated
    public IAttributeDefinitionDescriptor[] getLegacyColumns() {
        IColumnDescriptor[] columns = this.getColumns();
        IAttributeDefinitionDescriptor[] result = new IAttributeDefinitionDescriptor[columns.length];
        int i = 0;
        while (i < result.length) {
            result[i] = columns[i].getAttribute();
            ++i;
        }
        return result;
    }

    @Deprecated
    public IAttributeDefinitionDescriptor[] setLegacyColumns(IAttributeDefinitionDescriptor[] value) {
        IColumnDescriptor[] columns = new IColumnDescriptor[value.length];
        int i = 0;
        while (i < columns.length) {
            IColumnDescriptor column = (IColumnDescriptor)ConfigurationElementFactory.emptyInstance(IColumnDescriptor.class);
            column.setAttribute(value[i]);
            columns[i] = column;
            ++i;
        }
        IAttributeDefinitionDescriptor[] oldValue = this.getLegacyColumns();
        this.setColumns(columns);
        return oldValue;
    }

    public IColumnDescriptor[] getColumns() {
        return this.fDescription.getColumns();
    }

    public IColumnDescriptor[] setColumns(IColumnDescriptor[] value) {
        IColumnDescriptor[] oldValue = this.fDescription.setColumns(value);
        if (!PlanModeState.safeEquals(oldValue, value)) {
            this.setDirty(true);
            if (!this.fireChangeEvent(new PlanOutlineSettingChangeEvent(PlanOutlineSettingChangeEvent.Property.COLUMNS, (Object)value, new Object[0]))) {
                this.fDescription.setColumns(value);
                this.fireChangeEvent(new PlanOutlineSettingChangeEvent(PlanOutlineSettingChangeEvent.Property.COLUMNS, (Object)value, new Object[0]));
            }
        }
        return oldValue;
    }

    public ProgressMode setProgressMode(ProgressMode mode) {
        ProgressMode oldValue = this.fDescription.setProgressMode(mode);
        if (!PlanModeState.safeEquals(oldValue, mode)) {
            this.setDirty(true);
            if (!this.fireChangeEvent(new PlanOutlineSettingChangeEvent(PlanOutlineSettingChangeEvent.Property.OWNER_PROGRESS_MODE, (Object)mode, new Object[0]))) {
                this.fDescription.setProgressMode(oldValue);
                this.fireChangeEvent(new PlanOutlineSettingChangeEvent(PlanOutlineSettingChangeEvent.Property.OWNER_PROGRESS_MODE, (Object)oldValue, new Object[0]));
            }
        }
        return oldValue;
    }

    public IViewModeDescription setViewMode(IViewModeDescription mode) {
        IViewModeDescription oldValue = this.fDescription.setViewMode(mode);
        if (!PlanModeState.safeEquals(oldValue, mode)) {
            this.setDirty(true);
            if (!this.fireChangeEvent(new PlanOutlineSettingChangeEvent(PlanOutlineSettingChangeEvent.Property.VIEW_MODE, (Object)mode, new Object[0]))) {
                this.fDescription.setViewMode(oldValue);
                this.fireChangeEvent(new PlanOutlineSettingChangeEvent(PlanOutlineSettingChangeEvent.Property.VIEW_MODE, (Object)oldValue, new Object[0]));
            }
        }
        return oldValue;
    }

    public IGroupModeDescription setGroupMode(IGroupModeDescription mode) {
        IGroupModeDescription oldValue = this.fDescription.setGroupMode(mode);
        if (!mode.equals(oldValue)) {
            this.setDirty(true);
            if (!this.fireChangeEvent(new PlanOutlineSettingChangeEvent(PlanOutlineSettingChangeEvent.Property.GROUP_MODE, (Object)mode, new Object[0]))) {
                this.fDescription.setGroupMode(oldValue);
                this.fireChangeEvent(new PlanOutlineSettingChangeEvent(PlanOutlineSettingChangeEvent.Property.GROUP_MODE, (Object)oldValue, new Object[0]));
            }
        }
        return oldValue;
    }

    public ISortModeDescription setSortMode(ISortModeDescription mode) {
        ISortModeDescription oldValue = this.fDescription.setSortMode(mode);
        if (!mode.equals(oldValue)) {
            this.setDirty(true);
            if (!this.fireChangeEvent(new PlanOutlineSettingChangeEvent(PlanOutlineSettingChangeEvent.Property.SORT_MODE, (Object)mode, new Object[0]))) {
                this.fDescription.setSortMode(oldValue);
                this.fireChangeEvent(new PlanOutlineSettingChangeEvent(PlanOutlineSettingChangeEvent.Property.SORT_MODE, (Object)oldValue, new Object[0]));
            }
        }
        return oldValue;
    }

    public IFilterDescription[] setFilters(IFilterDescription[] value) {
        return this.fDescription.setFilters(value);
    }

    public void addFilter(IFilterDescription filter) {
        IFilterDescription[] oldFilters = this.fDescription.getFilters();
        IFilterDescription[] newFilters = PlanModeState.add(oldFilters, filter);
        if (newFilters != null) {
            this.setDirty(true);
            this.setFilters(newFilters);
            if (!this.fireChangeEvent(new PlanOutlineSettingChangeEvent(PlanOutlineSettingChangeEvent.Property.FILTER, (Object)filter, Boolean.TRUE))) {
                this.setFilters(oldFilters);
                this.fireChangeEvent(new PlanOutlineSettingChangeEvent(PlanOutlineSettingChangeEvent.Property.FILTER, (Object)filter, Boolean.FALSE));
            }
        }
    }

    public void removeFilter(IFilterDescription filter) {
        IFilterDescription[] newFilters = PlanModeState.remove(this.fDescription.getFilters(), filter);
        if (newFilters != null) {
            this.setFilters(newFilters);
            this.setDirty(true);
            this.fireChangeEvent(new PlanOutlineSettingChangeEvent(PlanOutlineSettingChangeEvent.Property.FILTER, (Object)filter, Boolean.FALSE));
        }
    }

    public IAttributeDefinitionDescriptor[] setPlanChecks(IAttributeDefinitionDescriptor[] value) {
        return this.fDescription.setPlanChecks(value);
    }

    public void addColorizeConfiguration(IColorizeDescription config) {
        IColorizeDescription[] newColors = PlanModeState.add(this.fDescription.getColors(), config);
        if (newColors != null) {
            this.setColors(newColors);
            this.setDirty(true);
            this.fireChangeEvent(new PlanOutlineSettingChangeEvent(PlanOutlineSettingChangeEvent.Property.COLORIZE_ADD, (Object)config, new Object[0]));
        }
    }

    public void removeColorizeConfiguration(IColorizeDescription config) {
        IColorizeDescription[] newColors = PlanModeState.remove(this.fDescription.getColors(), config);
        if (newColors != null) {
            this.setColors(newColors);
            this.setDirty(true);
            this.fireChangeEvent(new PlanOutlineSettingChangeEvent(PlanOutlineSettingChangeEvent.Property.COLORIZE_REMOVE, (Object)config, new Object[0]));
        }
    }

    public void updateColorizeConfigurations(IColorizeDescription config) {
        this.setDirty(true);
        this.fireChangeEvent(new PlanOutlineSettingChangeEvent(PlanOutlineSettingChangeEvent.Property.COLORIZE_UPDATE, (Object)config, new Object[0]));
    }

    public IColorizeDescription[] getEnabledColorizeConfigurations() {
        IColorizeDescription[] allConfigs = this.getColors();
        ArrayList<IColorizeDescription> enabledConfigs = new ArrayList<IColorizeDescription>();
        IColorizeDescription[] iColorizeDescriptionArray = allConfigs;
        int n = allConfigs.length;
        int n2 = 0;
        while (n2 < n) {
            IColorizeDescription config = iColorizeDescriptionArray[n2];
            if (config.isEnabled()) {
                enabledConfigs.add(config);
            }
            ++n2;
        }
        return enabledConfigs.toArray(new IColorizeDescription[enabledConfigs.size()]);
    }

    public void updateColorizeConfigEnablement(IColorizeDescription config) {
        this.setDirty(true);
        this.fireChangeEvent(new PlanOutlineSettingChangeEvent(PlanOutlineSettingChangeEvent.Property.COLORIZE_ENABLEMENT, (Object)config, config.isEnabled()));
    }

    private static <T> int indexOf(T[] elements, T element) {
        int index = -1;
        int i = 0;
        while (i < elements.length) {
            if (elements[i].equals(element)) {
                index = i;
                break;
            }
            ++i;
        }
        return index;
    }

    private static <T> T[] add(T[] elements, T element) {
        if (PlanModeState.indexOf(elements, element) != -1) {
            return null;
        }
        Object[] result = (Object[])Array.newInstance(elements.getClass().getComponentType(), elements.length + 1);
        result[0] = element;
        int i = 0;
        while (i < elements.length) {
            result[i + 1] = elements[i];
            ++i;
        }
        return result;
    }

    private static <T> T[] remove(T[] elements, T element) {
        if (PlanModeState.indexOf(elements, element) == -1) {
            return null;
        }
        Object[] result = (Object[])Array.newInstance(elements.getClass().getComponentType(), elements.length - 1);
        int i = 0;
        int j = 0;
        while (i < elements.length) {
            T current = elements[i];
            if (!current.equals(element)) {
                result[j++] = current;
            }
            ++i;
        }
        return result;
    }

    public void setShowDetails(boolean showDetails) {
        if (showDetails != this.fShowDetails) {
            this.fShowDetails = showDetails;
            this.setDirty(true);
            this.fireChangeEvent(new PlanOutlineSettingChangeEvent(PlanOutlineSettingChangeEvent.Property.SHOW_DETAILS, (Object)showDetails, new Object[0]));
        }
    }

    @Override
    public String getDefaultWorkItemType() {
        return this.fDefaultWorkItemType;
    }

    @Override
    public void setDefaultWorkItemType(String workItemType) {
        if (this.fDefaultWorkItemType == null && workItemType == null) {
            return;
        }
        if (this.fDefaultWorkItemType == null && workItemType != null || this.fDefaultWorkItemType != null && workItemType == null || !this.fDefaultWorkItemType.equals(workItemType)) {
            this.fDefaultWorkItemType = workItemType;
            this.setDirty(true);
            this.fireChangeEvent(new PlanOutlineSettingChangeEvent(PlanOutlineSettingChangeEvent.Property.DEFAULT_WORK_ITEM_TYPE, (Object)this.fDefaultWorkItemType, new Object[0]));
        }
    }

    public static boolean safeEquals(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        if (o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    @Override
    public ItemMovePolicy getItemMovePolicy() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean getShowDetails() {
        return this.fShowDetails;
    }

    @Override
    public void addSettingsChangeListener(IOutlineSettingsListener listener) {
        this.fSettingListeners.add((Object)listener);
    }

    @Override
    public void removeSettingsChangeListener(IOutlineSettingsListener listener) {
        this.fSettingListeners.remove((Object)listener);
    }

    private boolean fireChangeEvent(final PlanOutlineSettingChangeEvent event) {
        final boolean[] success = new boolean[]{true};
        ISafeRunnable runnable = new ISafeRunnable(){

            public void run() throws Exception {
                Object[] listeners = PlanModeState.this.fSettingListeners.getListeners();
                int i = 0;
                while (i < listeners.length) {
                    IOutlineSettingsListener listener = (IOutlineSettingsListener)listeners[i];
                    listener.settingChanged(event);
                    ++i;
                }
            }

            public void handleException(Throwable exception) {
                success[0] = !(exception instanceof RhinoException);
            }
        };
        SafeRunnable.run((ISafeRunnable)runnable);
        return success[0];
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PlanModeState)) {
            return false;
        }
        PlanModeState other = (PlanModeState)obj;
        return this.fDescription.equals(other.fDescription) && this.fSharedPlanMode.sameItemId((IItemHandle)other.fSharedPlanMode);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + this.fDescription.hashCode();
        result = prime * result + this.fSharedPlanMode.hashCode();
        return result;
    }
}

