/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.editor;

import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.common.LegacyHelper;
import com.ibm.team.apt.internal.common.ProgressMode;
import com.ibm.team.apt.internal.common.plantype.IFilterDescription;
import com.ibm.team.apt.internal.common.plantype.IGroupModeDescription;
import com.ibm.team.apt.internal.common.plantype.ISortModeDescription;
import com.ibm.team.apt.internal.common.plantype.IViewModeDescription;
import com.ibm.team.apt.internal.ide.ui.common.IOutlineSettingsListener;
import com.ibm.team.apt.internal.ide.ui.common.OutlineSettingChangeEvent;
import com.ibm.team.apt.internal.ide.ui.editor.AbstractPlanModeTab;
import com.ibm.team.apt.internal.ide.ui.editor.ConfigurationDescriptorLabelProvider;
import com.ibm.team.apt.internal.ide.ui.editor.DeprecatedConfigurationElementCheckboxViewerFilter;
import com.ibm.team.apt.internal.ide.ui.editor.Messages;
import com.ibm.team.apt.internal.ide.ui.editor.PlanModeState;
import com.ibm.team.apt.internal.ide.ui.editor.TaskboardConfigurationUI;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.PlanOutlineSettingChangeEvent;
import com.ibm.team.apt.internal.ide.ui.jface.CheckboxListViewer;
import com.ibm.team.apt.internal.ide.ui.jface.ConfigurationUIProvider;
import com.ibm.team.process.common.IProjectArea;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class PlanModeConfigurationTab
extends AbstractPlanModeTab {
    public static final String ID = "com.ibm.team.apt.planmode.ui.basic";
    private Composite fControl;
    private CheckboxListViewer fViewModeViewer;
    private CheckboxListViewer fGroupingsViewer;
    private CheckboxListViewer fSortingsViewer;
    private CheckboxListViewer fFilteringsViewer;
    private CheckboxListViewer fBarViewer;
    private final IProjectArea fProjectArea;
    private ConfigurationUIProvider fConfigurationUiProvider;
    private TaskboardConfigurationUI fTaskboardConfigurationUI;
    private DirtyStateListener fDirtyListener = new DirtyStateListener();
    private StateUpdater fStateUpdater = new StateUpdater();

    public PlanModeConfigurationTab(IProjectArea projectArea) {
        this.fProjectArea = projectArea;
        this.fConfigurationUiProvider = new ConfigurationUIProvider(){

            @Override
            public boolean canConfigure(Object element) {
                if (element instanceof IViewModeDescription) {
                    element = ((IViewModeDescription)element).getId();
                }
                return super.canConfigure(element);
            }

            @Override
            public ConfigurationUIProvider.IConfigurationUI getConfigureUI(Object element) {
                if (element instanceof IViewModeDescription) {
                    element = ((IViewModeDescription)element).getId();
                }
                return super.getConfigureUI(element);
            }
        };
    }

    @Override
    public String getIdentifier() {
        return ID;
    }

    @Override
    public String getName() {
        return Messages.PlanModeConfigurationTab_NAME;
    }

    @Override
    public Control createControl(Composite parent, FormToolkit toolkit) {
        this.fControl = toolkit.createComposite(parent);
        FillLayout layout = new FillLayout(256);
        layout.spacing = LayoutConstants.getSpacing().x;
        this.fControl.setLayout((Layout)layout);
        Section section = toolkit.createSection(this.fControl, 328);
        section.setText(Messages.PlanModeConfigurationPart_TITLE_VIEW_MODE);
        this.fViewModeViewer = new CheckboxListViewer((Composite)section, 16);
        toolkit.adapt((Composite)this.fViewModeViewer.getControl());
        section.setClient(this.fViewModeViewer.getControl());
        this.fViewModeViewer.setLabelProvider((IBaseLabelProvider)new ConfigurationDescriptorLabelProvider());
        this.fViewModeViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fViewModeViewer.setComparator(new ViewerComparator());
        this.fViewModeViewer.addCheckStateListener(this.fDirtyListener);
        this.fViewModeViewer.addCheckStateListener(this.fStateUpdater);
        this.fViewModeViewer.setEnableConfigurationUI(true);
        this.fTaskboardConfigurationUI = new TaskboardConfigurationUI(this.fProjectArea);
        this.fConfigurationUiProvider.register(LegacyHelper.getTaskboardIdentifier(), this.fTaskboardConfigurationUI);
        this.fViewModeViewer.setConfigurationUIProvider(this.fConfigurationUiProvider);
        section = toolkit.createSection(this.fControl, 328);
        section.setText(Messages.PlanModeConfigurationPart_TITLE_GROUPING);
        this.fGroupingsViewer = new CheckboxListViewer((Composite)section, 16);
        toolkit.adapt((Composite)this.fGroupingsViewer.getControl());
        section.setClient(this.fGroupingsViewer.getControl());
        this.fGroupingsViewer.setLabelProvider((IBaseLabelProvider)new ConfigurationDescriptorLabelProvider());
        this.fGroupingsViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fGroupingsViewer.setComparator(new ViewerComparator());
        this.fGroupingsViewer.addCheckStateListener(this.fDirtyListener);
        this.fGroupingsViewer.addCheckStateListener(this.fStateUpdater);
        section = toolkit.createSection(this.fControl, 328);
        section.setText(Messages.PlanModeConfigurationPart_TITLE_SORTING);
        this.fSortingsViewer = new CheckboxListViewer((Composite)section, 16);
        toolkit.adapt((Composite)this.fSortingsViewer.getControl());
        section.setClient(this.fSortingsViewer.getControl());
        this.fSortingsViewer.setLabelProvider((IBaseLabelProvider)new ConfigurationDescriptorLabelProvider());
        this.fSortingsViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fSortingsViewer.setComparator(new ViewerComparator());
        this.fSortingsViewer.addCheckStateListener(this.fDirtyListener);
        this.fSortingsViewer.addCheckStateListener(this.fStateUpdater);
        section = toolkit.createSection(this.fControl, 328);
        section.setText(Messages.PlanModeConfigurationPart_TITLE_FILTER);
        this.fFilteringsViewer = new CheckboxListViewer((Composite)section, 32);
        toolkit.adapt((Composite)this.fFilteringsViewer.getControl());
        section.setClient(this.fFilteringsViewer.getControl());
        this.fFilteringsViewer.setLabelProvider((IBaseLabelProvider)new ConfigurationDescriptorLabelProvider());
        this.fFilteringsViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fFilteringsViewer.setComparator(new ViewerComparator());
        this.fFilteringsViewer.addCheckStateListener(this.fDirtyListener);
        this.fFilteringsViewer.addCheckStateListener(this.fStateUpdater);
        section = toolkit.createSection(this.fControl, 328);
        section.setText(Messages.PlanModeConfigurationPart_TITLE_BARS);
        this.fBarViewer = new CheckboxListViewer((Composite)section, 16);
        toolkit.adapt((Composite)this.fBarViewer.getControl());
        section.setClient(this.fBarViewer.getControl());
        this.fBarViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof ProgressMode) {
                    return ((ProgressMode)element).getLabel();
                }
                return super.getText(element);
            }
        });
        this.fBarViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fBarViewer.setInput(ProgressMode.getEclipseValues());
        this.fBarViewer.addCheckStateListener(this.fDirtyListener);
        this.fBarViewer.addCheckStateListener(this.fStateUpdater);
        return this.fControl;
    }

    @Override
    public Control getControl() {
        return this.fControl;
    }

    @Override
    protected IStatus update() {
        if (this.fInput != null) {
            boolean enable = LegacyHelper.isOwnerGroupMode((IGroupModeDescription)this.fInput.getGroupMode());
            this.fBarViewer.getControl().setEnabled(enable);
            if (!enable && this.fBarViewer.getChecked(ProgressMode.LOAD)) {
                this.fBarViewer.setChecked(ProgressMode.PROGRESS, true);
            }
        }
        if (this.fViewModeViewer.getSelection().isEmpty()) {
            return new Status(4, PlanningClientPlugin.getPluginId(), Messages.PlanModeConfigurationTab_MSG_SELECT_VIEW_MODE);
        }
        if (this.fGroupingsViewer.getSelection().isEmpty()) {
            return new Status(4, PlanningClientPlugin.getPluginId(), Messages.PlanModeConfigurationTab_MSG_SELECT_GOURP);
        }
        if (this.fSortingsViewer.getSelection().isEmpty()) {
            return new Status(4, PlanningClientPlugin.getPluginId(), Messages.PlanModeConfigurationTab_MSG_SELECT_SORT);
        }
        return Status.OK_STATUS;
    }

    public void setViewModes(List<IViewModeDescription> viewmodes) {
        this.fViewModeViewer.setInput(viewmodes);
        this.getConfigurationPart().layout(true, true);
    }

    public void setGroupings(List<IGroupModeDescription> groupings) {
        this.fGroupingsViewer.setInput(groupings);
        this.getConfigurationPart().layout(true, true);
    }

    public void setFilterings(List<IFilterDescription> filterings) {
        this.fFilteringsViewer.setInput(filterings);
        this.getConfigurationPart().layout(true, true);
    }

    public void setSortings(List<ISortModeDescription> sortings) {
        this.fSortingsViewer.setInput(sortings);
        this.getConfigurationPart().layout(true, true);
    }

    @Override
    public void setInput(PlanModeState input) {
        IFilterDescription[] filters;
        if (this.fInput != null) {
            this.fInput.removeSettingsChangeListener(this.fStateUpdater);
        }
        this.fInput = input;
        this.fInput.addSettingsChangeListener(this.fStateUpdater);
        PlanModeState planMode = input;
        this.fViewModeViewer.setSelection((ISelection)new StructuredSelection((Object)planMode.getViewMode()), true);
        this.fGroupingsViewer.setAllChecked(false);
        this.fGroupingsViewer.setChecked(planMode.getGroupMode(), true);
        this.fSortingsViewer.setAllChecked(false);
        this.fSortingsViewer.setChecked(planMode.getSortMode(), true);
        this.fFilteringsViewer.setAllChecked(false);
        IFilterDescription[] iFilterDescriptionArray = filters = planMode.getFilters();
        int n = filters.length;
        int n2 = 0;
        while (n2 < n) {
            IFilterDescription filter = iFilterDescriptionArray[n2];
            this.fFilteringsViewer.setChecked(filter, true);
            ++n2;
        }
        this.fFilteringsViewer.setFilter(new DeprecatedConfigurationElementCheckboxViewerFilter(), false);
        this.fBarViewer.setSelection((ISelection)new StructuredSelection((Object)planMode.getProgressMode()), true);
        this.fTaskboardConfigurationUI.setViewMode(this.fInput.getViewMode());
    }

    private class DirtyStateListener
    implements ICheckStateListener {
        private DirtyStateListener() {
        }

        public void checkStateChanged(CheckStateChangedEvent event) {
            PlanModeConfigurationTab.this.getConfigurationPart().updateStatus();
        }
    }

    private class StateUpdater
    implements ICheckStateListener,
    IOutlineSettingsListener {
        private boolean fIgnoreUpdates = false;

        private StateUpdater() {
        }

        public void checkStateChanged(CheckStateChangedEvent event) {
            Object element = event.getElement();
            boolean checked = event.getChecked();
            if (checked) {
                if (element instanceof IViewModeDescription) {
                    PlanModeConfigurationTab.this.fInput.setViewMode((IViewModeDescription)element);
                } else if (element instanceof IGroupModeDescription) {
                    PlanModeConfigurationTab.this.fInput.setGroupMode((IGroupModeDescription)element);
                } else if (element instanceof ISortModeDescription) {
                    PlanModeConfigurationTab.this.fInput.setSortMode((ISortModeDescription)element);
                } else if (element instanceof ProgressMode) {
                    PlanModeConfigurationTab.this.fInput.setProgressMode((ProgressMode)element);
                }
            }
            if (element instanceof IFilterDescription) {
                if (checked) {
                    PlanModeConfigurationTab.this.fInput.addFilter((IFilterDescription)element);
                } else {
                    PlanModeConfigurationTab.this.fInput.removeFilter((IFilterDescription)element);
                }
            }
            PlanModeConfigurationTab.this.getConfigurationPart().updateStatus();
        }

        @Override
        public void settingChanged(OutlineSettingChangeEvent event) {
            if (this.fIgnoreUpdates) {
                return;
            }
            this.fIgnoreUpdates = true;
            try {
                Object newValue = event.getNewValue();
                if (newValue == null) {
                    return;
                }
                PlanOutlineSettingChangeEvent.Property property = (PlanOutlineSettingChangeEvent.Property)event.getChangedProperty();
                switch (property) {
                    case VIEW_MODE: {
                        StructuredSelection selection = new StructuredSelection(newValue);
                        PlanModeConfigurationTab.this.fViewModeViewer.setSelection((ISelection)selection);
                        break;
                    }
                    case GROUP_MODE: {
                        PlanModeConfigurationTab.this.fGroupingsViewer.setChecked(newValue, true);
                        break;
                    }
                    case SORT_MODE: {
                        PlanModeConfigurationTab.this.fSortingsViewer.setChecked(newValue, true);
                        break;
                    }
                    case FILTER: {
                        Boolean added = (Boolean)event.getParameters()[0];
                        PlanModeConfigurationTab.this.fFilteringsViewer.setChecked(newValue, added);
                    }
                }
            }
            finally {
                this.fIgnoreUpdates = false;
            }
        }
    }
}

