/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.editor;

import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.common.util.Empty;
import com.ibm.team.apt.internal.ide.ui.editor.AbstractPlanModeTab;
import com.ibm.team.apt.internal.ide.ui.editor.Messages;
import com.ibm.team.apt.internal.ide.ui.editor.PlanModeState;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.repository.common.util.NLS;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class PlanModeConfigurationPart
extends Composite {
    public static final Object OK = "save";
    public static final Object CANCEL = "cancel";
    private DirtyStateListener fDirtyListener = new DirtyStateListener();
    private ControlDecoration fDecoNameText;
    private Text fNameText;
    private Image fInfoImage;
    private Image fErrorImage;
    private CTabFolder fTabsFolders;
    private Map<String, AbstractPlanModeTab> fTabs = new HashMap<String, AbstractPlanModeTab>();
    private PlanModeState fInput;
    private FormToolkit fToolkit;

    public PlanModeConfigurationPart(Composite parent, FormToolkit toolkit, int style) {
        super(parent, style);
        this.fToolkit = toolkit;
        this.createResources();
        this.createControl(toolkit);
    }

    public void setInput(PlanModeState input) {
        this.checkWidget();
        this.fInput = input;
        this.fNameText.setText(input.getDisplayName());
        for (AbstractPlanModeTab tab : this.fTabs.values()) {
            tab.setInput(input);
        }
        this.updateStatus();
    }

    public PlanModeState getInput() {
        this.checkWidget();
        this.fInput.setDisplayName(this.fNameText.getText().trim());
        return this.fInput;
    }

    public Action getAction(String id) {
        CTabItem item = this.fTabsFolders.getSelection();
        if (item == null) {
            return null;
        }
        AbstractPlanModeTab tab = (AbstractPlanModeTab)item.getData();
        if (tab == null) {
            return null;
        }
        return tab.getAction(id);
    }

    protected void createControl(FormToolkit toolkit) {
        toolkit.adapt((Composite)this);
        GridLayoutFactory.fillDefaults().margins(0, 0).extendedMargins(6, 6, 10, 3).spacing(0, 10).applyTo((Composite)this);
        Composite composite = this.createSummaryPart(this, toolkit);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)composite);
        composite = this.createTabsPart(this, toolkit);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
    }

    protected void createResources() {
        this.fInfoImage = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_INFORMATION").getImage();
        this.fErrorImage = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage();
    }

    protected Composite createSummaryPart(Composite parent, FormToolkit toolkit) {
        Composite composite = toolkit.createComposite(parent);
        GridLayoutFactory.fillDefaults().numColumns(4).margins(0, 0).spacing(6, 0).applyTo(composite);
        toolkit.createLabel(composite, Messages.PlanModeConfigurationPart_NAME_LABEL);
        this.fNameText = toolkit.createText(composite, "", 2052);
        this.fNameText.setFont(JazzResources.getFont((String)"com.ibm.team.jface.itemview.TitleFont"));
        this.fNameText.setForeground(JazzResources.getColor((String)"com.ibm.team.jface.itemview.TitleColor"));
        this.fNameText.addModifyListener((ModifyListener)this.fDirtyListener);
        GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.fNameText);
        this.fDecoNameText = new ControlDecoration((Control)this.fNameText, 0x1004000);
        Button button = toolkit.createButton(composite, Messages.PlanModeConfigurationPart_LABEL_SAVE, 8);
        button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                event.data = OK;
                PlanModeConfigurationPart.this.notifyListeners(event.type, event);
            }
        });
        button = toolkit.createButton(composite, Messages.PlanModeConfigurationPart_LABEL_CANCEL, 8);
        button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                event.data = CANCEL;
                PlanModeConfigurationPart.this.notifyListeners(event.type, event);
            }
        });
        GridDataFactory.swtDefaults().align(0x1000008, 0x1000000).applyTo((Control)button);
        return composite;
    }

    protected Composite createTabsPart(Composite parent, FormToolkit toolkit) {
        this.fTabsFolders = new CTabFolder((Composite)this, 1024);
        toolkit.adapt((Composite)this.fTabsFolders);
        return this.fTabsFolders;
    }

    public Control addTab(AbstractPlanModeTab tab) {
        this.checkWidget();
        tab.setConfigurationPart(this);
        Control control = tab.createControl((Composite)this.fTabsFolders, this.fToolkit);
        if (this.fInput != null) {
            tab.setInput(this.fInput);
        }
        CTabItem tabItem = new CTabItem(this.fTabsFolders, 0);
        tabItem.setData((Object)tab);
        tabItem.setText(tab.getName());
        tabItem.setControl(control);
        this.fTabs.put(tab.getIdentifier(), tab);
        this.layout(true, true);
        return control;
    }

    public IStatus validate() {
        this.checkWidget();
        String value = this.fNameText.getText().trim();
        if (Empty.is((CharSequence)value)) {
            return new Status(4, PlanningClientPlugin.getPluginId(), Messages.PlanModeConfigurationPart_MSG_NO_NAME);
        }
        if (value.matches("\\d.*")) {
            return new Status(4, PlanningClientPlugin.getPluginId(), Messages.PlanModeConfigurationPart_MSG_ILLEGAL_NAME_NUMBER);
        }
        if (value.matches("\\p{Punct}.*")) {
            return new Status(4, PlanningClientPlugin.getPluginId(), NLS.bind((String)Messages.PlanModeConfigurationPart_MSG_ILLEGAL_NAME_PUNCT, (Object)value.substring(0, 1), (Object[])new Object[0]));
        }
        if (value.length() > 2 && value.substring(0, 3).equalsIgnoreCase("xml")) {
            return new Status(4, PlanningClientPlugin.getPluginId(), NLS.bind((String)Messages.PlanModeConfigurationPart_MSG_ILLEGAL_NAME, (Object)value, (Object[])new Object[0]));
        }
        return Status.OK_STATUS;
    }

    public void updateStatus() {
        this.checkWidget();
        MessageMultiStatus status = new MessageMultiStatus();
        status.add(this.validate());
        for (AbstractPlanModeTab tab : this.fTabs.values()) {
            status.add(tab.update());
        }
        GridData gridData = (GridData)this.fNameText.getLayoutData();
        int oldHIndent = gridData.horizontalIndent;
        if (status.isOK()) {
            gridData.horizontalIndent = 0;
            this.fDecoNameText.hide();
        } else {
            gridData.horizontalIndent = Math.max(this.fErrorImage.getBounds().width, this.fInfoImage.getBounds().width);
            this.fDecoNameText.setImage(status.matches(4) ? this.fErrorImage : this.fInfoImage);
            this.fDecoNameText.setDescriptionText(status.getMessage());
            this.fDecoNameText.show();
        }
        if (oldHIndent != gridData.horizontalIndent) {
            this.layout(new Control[]{this.fNameText, this.fDecoNameText.getControl()});
            this.redraw();
            this.update();
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (!visible) {
            return;
        }
        this.updateStatus();
        if (!this.fTabs.isEmpty()) {
            this.fTabsFolders.setSelection(0);
        }
        this.fNameText.setFocus();
        this.fNameText.selectAll();
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        TypedListener typedListener = new TypedListener((SWTEventListener)listener);
        this.addListener(13, (Listener)typedListener);
        this.addListener(14, (Listener)typedListener);
    }

    private class DirtyStateListener
    implements ModifyListener {
        private DirtyStateListener() {
        }

        public void modifyText(ModifyEvent e) {
            if (PlanModeConfigurationPart.this.fInput != null) {
                PlanModeConfigurationPart.this.updateStatus();
            }
        }
    }

    private final class MessageMultiStatus
    extends MultiStatus {
        private MessageMultiStatus() {
            super(PlanningClientPlugin.getPluginId(), 0, "", null);
        }

        public String getMessage() {
            IStatus[] iStatusArray = this.getChildren();
            int n = iStatusArray.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus child = iStatusArray[n2];
                if (child.matches(this.getSeverity())) {
                    return child.getMessage();
                }
                ++n2;
            }
            return super.getMessage();
        }
    }
}

